/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmAssignee;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmStatusFilter;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.notification.info.AlarmAssignmentNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.AlarmAssignmentTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.AlarmAssignmentNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;

@Service
public class AlarmAssignmentTriggerProcessor
implements NotificationRuleTriggerProcessor<AlarmAssignmentTrigger, AlarmAssignmentNotificationRuleTriggerConfig> {
    public boolean matchesFilter(AlarmAssignmentTrigger trigger, AlarmAssignmentNotificationRuleTriggerConfig triggerConfig) {
        AlarmAssignmentNotificationRuleTriggerConfig.Action action;
        AlarmAssignmentNotificationRuleTriggerConfig.Action action2 = action = trigger.getActionType() == ActionType.ALARM_ASSIGNED ? AlarmAssignmentNotificationRuleTriggerConfig.Action.ASSIGNED : AlarmAssignmentNotificationRuleTriggerConfig.Action.UNASSIGNED;
        if (!triggerConfig.getNotifyOn().contains(action)) {
            return false;
        }
        AlarmInfo alarmInfo = trigger.getAlarmInfo();
        return CollectionsUtil.emptyOrContains((Collection)triggerConfig.getAlarmTypes(), (Object)alarmInfo.getType()) && CollectionsUtil.emptyOrContains((Collection)triggerConfig.getAlarmSeverities(), (Object)alarmInfo.getSeverity()) && (CollectionUtils.isEmpty((Collection)triggerConfig.getAlarmStatuses()) || AlarmStatusFilter.from((Collection)triggerConfig.getAlarmStatuses()).matches((Alarm)alarmInfo));
    }

    public RuleOriginatedNotificationInfo constructNotificationInfo(AlarmAssignmentTrigger trigger) {
        AlarmInfo alarmInfo = trigger.getAlarmInfo();
        AlarmAssignee assignee = alarmInfo.getAssignee();
        return AlarmAssignmentNotificationInfo.builder().action(trigger.getActionType() == ActionType.ALARM_ASSIGNED ? "assigned" : "unassigned").assigneeFirstName(assignee != null ? assignee.getFirstName() : null).assigneeLastName(assignee != null ? assignee.getLastName() : null).assigneeEmail(assignee != null ? assignee.getEmail() : null).assigneeId(assignee != null ? assignee.getId() : null).userEmail(trigger.getUser().getEmail()).userFirstName(trigger.getUser().getFirstName()).userLastName(trigger.getUser().getLastName()).alarmId(alarmInfo.getUuidId()).alarmType(alarmInfo.getType()).alarmOriginator(alarmInfo.getOriginator()).alarmOriginatorName(alarmInfo.getOriginatorName()).alarmSeverity(alarmInfo.getSeverity()).alarmStatus(alarmInfo.getStatus()).alarmCustomerId(alarmInfo.getCustomerId()).dashboardId(alarmInfo.getDashboardId()).build();
    }

    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.ALARM_ASSIGNMENT;
    }
}

