/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.channels;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.info.NotificationInfo;
import org.thingsboard.server.common.data.notification.targets.MicrosoftTeamsNotificationTargetConfig;
import org.thingsboard.server.common.data.notification.template.MicrosoftTeamsDeliveryMethodNotificationTemplate;
import org.thingsboard.server.service.notification.NotificationProcessingContext;
import org.thingsboard.server.service.notification.channels.NotificationChannel;
import org.thingsboard.server.service.notification.channels.TeamsAdaptiveCard;
import org.thingsboard.server.service.notification.channels.TeamsMessageCard;
import org.thingsboard.server.service.security.system.SystemSecurityService;

@Component
public class MicrosoftTeamsNotificationChannel
implements NotificationChannel<MicrosoftTeamsNotificationTargetConfig, MicrosoftTeamsDeliveryMethodNotificationTemplate> {
    private final SystemSecurityService systemSecurityService;
    private RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(Duration.of(15L, ChronoUnit.SECONDS)).setReadTimeout(Duration.of(15L, ChronoUnit.SECONDS)).build();

    public void sendNotification(MicrosoftTeamsNotificationTargetConfig targetConfig, MicrosoftTeamsDeliveryMethodNotificationTemplate processedTemplate, NotificationProcessingContext ctx) throws Exception {
        if (targetConfig.getUseOldApi() == null || Boolean.TRUE.equals(targetConfig.getUseOldApi())) {
            this.sendTeamsMessageCard(targetConfig, processedTemplate, ctx);
        } else {
            this.sendTeamsAdaptiveCard(targetConfig, processedTemplate, ctx);
        }
    }

    private void sendTeamsAdaptiveCard(MicrosoftTeamsNotificationTargetConfig targetConfig, MicrosoftTeamsDeliveryMethodNotificationTemplate processedTemplate, NotificationProcessingContext ctx) throws URISyntaxException, JsonProcessingException {
        TeamsAdaptiveCard teamsAdaptiveCard = new TeamsAdaptiveCard();
        TeamsAdaptiveCard.Attachment attachment = new TeamsAdaptiveCard.Attachment();
        teamsAdaptiveCard.setAttachments(List.of(attachment));
        TeamsAdaptiveCard.AdaptiveCard adaptiveCard = new TeamsAdaptiveCard.AdaptiveCard();
        attachment.setContent(adaptiveCard);
        TeamsAdaptiveCard.BackgroundImage backgroundImage = new TeamsAdaptiveCard.BackgroundImage(processedTemplate.getThemeColor());
        adaptiveCard.setBackgroundImage(backgroundImage);
        if (StringUtils.isEmpty((CharSequence)processedTemplate.getSubject())) {
            TeamsAdaptiveCard.TextBlock textBlock = new TeamsAdaptiveCard.TextBlock();
            textBlock.setText(processedTemplate.getBody());
            textBlock.setWeight("Normal");
            textBlock.setSize("Medium");
            textBlock.setColor(processedTemplate.getThemeColor());
            adaptiveCard.getTextBlocks().add(textBlock);
        } else {
            TeamsAdaptiveCard.TextBlock subjectTextBlock = new TeamsAdaptiveCard.TextBlock();
            subjectTextBlock.setText(processedTemplate.getSubject());
            subjectTextBlock.setWeight("Bolder");
            subjectTextBlock.setSize("Large");
            subjectTextBlock.setColor(processedTemplate.getThemeColor());
            adaptiveCard.getTextBlocks().add(subjectTextBlock);
            TeamsAdaptiveCard.TextBlock bodyTextBlock = new TeamsAdaptiveCard.TextBlock();
            bodyTextBlock.setText(processedTemplate.getBody());
            bodyTextBlock.setWeight("Lighter");
            bodyTextBlock.setSize("Medium");
            bodyTextBlock.setColor(processedTemplate.getThemeColor());
            adaptiveCard.getTextBlocks().add(bodyTextBlock);
        }
        String uri = this.getButtonUri(processedTemplate, ctx);
        if (StringUtils.isNotBlank((CharSequence)uri) && processedTemplate.getButton().getText() != null) {
            TeamsAdaptiveCard.ActionOpenUrl actionOpenUrl = new TeamsAdaptiveCard.ActionOpenUrl();
            actionOpenUrl.setTitle(processedTemplate.getButton().getText());
            actionOpenUrl.setUrl(uri);
            adaptiveCard.getActions().add(actionOpenUrl);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)JacksonUtil.toString((Object)teamsAdaptiveCard), (MultiValueMap)headers);
        this.restTemplate.postForEntity(new URI(targetConfig.getWebhookUrl()), (Object)request, String.class);
    }

    private void sendTeamsMessageCard(MicrosoftTeamsNotificationTargetConfig targetConfig, MicrosoftTeamsDeliveryMethodNotificationTemplate processedTemplate, NotificationProcessingContext ctx) throws JsonProcessingException, URISyntaxException {
        TeamsMessageCard teamsMessageCard = new TeamsMessageCard();
        teamsMessageCard.setThemeColor(Strings.emptyToNull((String)processedTemplate.getThemeColor()));
        if (StringUtils.isEmpty((CharSequence)processedTemplate.getSubject())) {
            teamsMessageCard.setText(processedTemplate.getBody());
        } else {
            teamsMessageCard.setSummary(processedTemplate.getSubject());
            TeamsMessageCard.Section section = new TeamsMessageCard.Section();
            section.setActivityTitle(processedTemplate.getSubject());
            section.setActivitySubtitle(processedTemplate.getBody());
            teamsMessageCard.setSections(List.of(section));
        }
        MicrosoftTeamsDeliveryMethodNotificationTemplate.Button button = processedTemplate.getButton();
        String uri = this.getButtonUri(processedTemplate, ctx);
        if (StringUtils.isNotBlank((CharSequence)uri) && button.getText() != null) {
            TeamsMessageCard.ActionCard actionCard = new TeamsMessageCard.ActionCard();
            actionCard.setType("OpenUri");
            actionCard.setName(button.getText());
            TeamsMessageCard.ActionCard.Target target = new TeamsMessageCard.ActionCard.Target("default", uri);
            actionCard.setTargets(List.of(target));
            teamsMessageCard.setPotentialAction(List.of(actionCard));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)JacksonUtil.toString((Object)teamsMessageCard), (MultiValueMap)headers);
        this.restTemplate.postForEntity(new URI(targetConfig.getWebhookUrl()), (Object)request, String.class);
    }

    private String getButtonUri(MicrosoftTeamsDeliveryMethodNotificationTemplate processedTemplate, NotificationProcessingContext ctx) throws JsonProcessingException {
        MicrosoftTeamsDeliveryMethodNotificationTemplate.Button button = processedTemplate.getButton();
        if (button != null && button.isEnabled()) {
            Object uri;
            if (button.getLinkType() == MicrosoftTeamsDeliveryMethodNotificationTemplate.Button.LinkType.DASHBOARD) {
                String baseUrl;
                String state = null;
                if (button.isSetEntityIdInState() || StringUtils.isNotEmpty((CharSequence)button.getDashboardState())) {
                    ObjectNode stateObject = JacksonUtil.newObjectNode();
                    if (button.isSetEntityIdInState()) {
                        stateObject.putObject("params").set("entityId", (JsonNode)Optional.ofNullable(ctx.getRequest().getInfo()).map(NotificationInfo::getStateEntityId).map(JacksonUtil::valueToTree).orElse(null));
                    } else {
                        stateObject.putObject("params");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)button.getDashboardState())) {
                        stateObject.put("id", button.getDashboardState());
                    }
                    state = Base64.encodeBase64String((byte[])JacksonUtil.OBJECT_MAPPER.writeValueAsBytes(List.of(stateObject)));
                }
                if (StringUtils.isEmpty((CharSequence)(baseUrl = this.systemSecurityService.getBaseUrl(ctx.getTenantId(), null, null)))) {
                    throw new IllegalStateException("Failed to determine base url to construct dashboard link");
                }
                uri = baseUrl + "/dashboards/" + String.valueOf(button.getDashboardId());
                if (state != null) {
                    uri = (String)uri + "?state=" + state;
                }
            } else {
                uri = button.getLink();
            }
            return uri;
        }
        return null;
    }

    public void check(TenantId tenantId) throws Exception {
    }

    public NotificationDeliveryMethod getDeliveryMethod() {
        return NotificationDeliveryMethod.MICROSOFT_TEAMS;
    }

    @ConstructorProperties(value={"systemSecurityService"})
    @Generated
    public MicrosoftTeamsNotificationChannel(SystemSecurityService systemSecurityService) {
        this.systemSecurityService = systemSecurityService;
    }

    @Generated
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

