/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.channels;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.rule.engine.api.TbEmail;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.template.EmailDeliveryMethodNotificationTemplate;
import org.thingsboard.server.service.notification.NotificationProcessingContext;
import org.thingsboard.server.service.notification.channels.NotificationChannel;

@Component
public class EmailNotificationChannel
implements NotificationChannel<User, EmailDeliveryMethodNotificationTemplate> {
    private final MailService mailService;

    public void sendNotification(User recipient, EmailDeliveryMethodNotificationTemplate processedTemplate, NotificationProcessingContext ctx) throws Exception {
        this.mailService.send(ctx.getTenantId(), null, TbEmail.builder().to(recipient.getEmail()).subject(processedTemplate.getSubject()).body(processedTemplate.getBody()).html(true).build());
    }

    public void check(TenantId tenantId) throws Exception {
        if (!this.mailService.isConfigured(tenantId)) {
            throw new RuntimeException("Mail server is not configured");
        }
    }

    public NotificationDeliveryMethod getDeliveryMethod() {
        return NotificationDeliveryMethod.EMAIL;
    }

    @ConstructorProperties(value={"mailService"})
    @Generated
    public EmailNotificationChannel(MailService mailService) {
        this.mailService = mailService;
    }
}

