/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification;

import com.google.common.base.Strings;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.NotificationRequest;
import org.thingsboard.server.common.data.notification.NotificationRequestStats;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.common.data.notification.settings.NotificationDeliveryMethodConfig;
import org.thingsboard.server.common.data.notification.settings.NotificationSettings;
import org.thingsboard.server.common.data.notification.targets.NotificationRecipient;
import org.thingsboard.server.common.data.notification.template.DeliveryMethodNotificationTemplate;
import org.thingsboard.server.common.data.notification.template.NotificationTemplate;
import org.thingsboard.server.common.data.notification.template.NotificationTemplateConfig;
import org.thingsboard.server.common.data.util.TemplateUtils;
import org.thingsboard.server.service.notification.NotificationProcessingContext;

public class NotificationProcessingContext {
    private final TenantId tenantId;
    private final NotificationSettings settings;
    private final NotificationSettings systemSettings;
    private final NotificationRequest request;
    private final Set<NotificationDeliveryMethod> deliveryMethods;
    private final NotificationTemplate notificationTemplate;
    private final NotificationType notificationType;
    private final Map<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate> templates;
    private final NotificationRequestStats stats;

    public NotificationProcessingContext(TenantId tenantId, NotificationRequest request, Set<NotificationDeliveryMethod> deliveryMethods, NotificationTemplate template, NotificationSettings settings, NotificationSettings systemSettings) {
        this.tenantId = tenantId;
        this.request = request;
        this.deliveryMethods = deliveryMethods;
        this.settings = settings;
        this.systemSettings = systemSettings;
        this.notificationTemplate = template;
        this.notificationType = template.getNotificationType();
        this.templates = new EnumMap(NotificationDeliveryMethod.class);
        this.stats = new NotificationRequestStats();
        this.init();
    }

    private void init() {
        NotificationTemplateConfig templateConfig = this.notificationTemplate.getConfiguration();
        templateConfig.getDeliveryMethodsTemplates().forEach((deliveryMethod, template) -> {
            if (template.isEnabled()) {
                template = this.processTemplate(template, null);
                this.templates.put(deliveryMethod, template);
            }
        });
    }

    public <C extends NotificationDeliveryMethodConfig> C getDeliveryMethodConfig(NotificationDeliveryMethod deliveryMethod) {
        NotificationSettings settings = deliveryMethod == NotificationDeliveryMethod.MOBILE_APP ? this.systemSettings : this.settings;
        return (C)((NotificationDeliveryMethodConfig)settings.getDeliveryMethodsConfigs().get(deliveryMethod));
    }

    public <T extends DeliveryMethodNotificationTemplate> T getProcessedTemplate(NotificationDeliveryMethod deliveryMethod, NotificationRecipient recipient) {
        DeliveryMethodNotificationTemplate template = (DeliveryMethodNotificationTemplate)this.templates.get(deliveryMethod);
        if (recipient != null) {
            Map additionalTemplateContext = this.createTemplateContextForRecipient(recipient);
            if (template.getTemplatableValues().stream().anyMatch(value -> value.containsParams(additionalTemplateContext.keySet()))) {
                template = this.processTemplate(template, additionalTemplateContext);
            }
        }
        return (T)template;
    }

    private <T extends DeliveryMethodNotificationTemplate> T processTemplate(T template, Map<String, String> additionalTemplateContext) {
        HashMap<String, String> templateContext = new HashMap<String, String>();
        if (this.request.getInfo() != null) {
            templateContext.putAll(this.request.getInfo().getTemplateData());
        }
        if (additionalTemplateContext != null) {
            templateContext.putAll(additionalTemplateContext);
        }
        if (templateContext.isEmpty()) {
            return template;
        }
        template = template.copy();
        template.getTemplatableValues().forEach(templatableValue -> {
            String value = templatableValue.get();
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                value = TemplateUtils.processTemplate((String)value, (Map)templateContext);
                templatableValue.set(value);
            }
        });
        return template;
    }

    private Map<String, String> createTemplateContextForRecipient(NotificationRecipient recipient) {
        return Map.of("recipientTitle", recipient.getTitle(), "recipientEmail", Strings.nullToEmpty((String)recipient.getEmail()), "recipientFirstName", Strings.nullToEmpty((String)recipient.getFirstName()), "recipientLastName", Strings.nullToEmpty((String)recipient.getLastName()));
    }

    @Generated
    public static NotificationProcessingContextBuilder builder() {
        return new NotificationProcessingContextBuilder();
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public NotificationRequest getRequest() {
        return this.request;
    }

    @Generated
    public Set<NotificationDeliveryMethod> getDeliveryMethods() {
        return this.deliveryMethods;
    }

    @Generated
    public NotificationTemplate getNotificationTemplate() {
        return this.notificationTemplate;
    }

    @Generated
    public NotificationType getNotificationType() {
        return this.notificationType;
    }

    @Generated
    public NotificationRequestStats getStats() {
        return this.stats;
    }
}

