/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.mobile.secret;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.event.TransactionalEventListener;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.security.model.JwtPair;
import org.thingsboard.server.dao.entity.AbstractCachedService;
import org.thingsboard.server.dao.settings.SecuritySettingsService;
import org.thingsboard.server.service.mobile.secret.MobileAppSecretService;
import org.thingsboard.server.service.mobile.secret.MobileSecretEvictEvent;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;

@Service
public class MobileAppSecretServiceImpl
extends AbstractCachedService<String, JwtPair, MobileSecretEvictEvent>
implements MobileAppSecretService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileAppSecretServiceImpl.class);
    private final JwtTokenFactory tokenFactory;
    private final SecuritySettingsService securitySettingsService;

    public String generateMobileAppSecret(SecurityUser securityUser) {
        log.trace("Executing generateSecret for user [{}]", (Object)securityUser.getId());
        Integer mobileSecretKeyLength = this.securitySettingsService.getSecuritySettings().getMobileSecretKeyLength();
        String secret = StringUtils.generateSafeToken((int)(mobileSecretKeyLength == null ? 64 : mobileSecretKeyLength));
        this.cache.put((Serializable)((Object)secret), (Serializable)this.tokenFactory.createTokenPair(securityUser));
        return secret;
    }

    public JwtPair getJwtPair(String secret) throws ThingsboardException {
        TbCacheValueWrapper jwtPair = this.cache.get((Serializable)((Object)secret));
        if (jwtPair != null) {
            return (JwtPair)jwtPair.get();
        }
        throw new ThingsboardException("Jwt token not found or expired!", ThingsboardErrorCode.JWT_TOKEN_EXPIRED);
    }

    @TransactionalEventListener(classes={MobileSecretEvictEvent.class})
    public void handleEvictEvent(MobileSecretEvictEvent event) {
        this.cache.evict((Serializable)((Object)event.getSecret()));
    }

    @ConstructorProperties(value={"tokenFactory", "securitySettingsService"})
    @Generated
    public MobileAppSecretServiceImpl(JwtTokenFactory tokenFactory, SecuritySettingsService securitySettingsService) {
        this.tokenFactory = tokenFactory;
        this.securitySettingsService = securitySettingsService;
    }
}

