/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.job;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.GeneratedMessageV3;
import jakarta.annotation.PreDestroy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.rule.engine.api.JobManager;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.JobId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.job.Job;
import org.thingsboard.server.common.data.job.JobResult;
import org.thingsboard.server.common.data.job.JobStatus;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.common.data.job.task.Task;
import org.thingsboard.server.common.data.job.task.TaskResult;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.dao.job.JobService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.settings.TasksQueueConfig;
import org.thingsboard.server.queue.task.JobStatsService;
import org.thingsboard.server.queue.task.TaskProducerQueueFactory;
import org.thingsboard.server.service.job.DefaultJobManager;
import org.thingsboard.server.service.job.JobProcessor;

@Component
public class DefaultJobManager
implements JobManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultJobManager.class);
    private final JobService jobService;
    private final JobStatsService jobStatsService;
    private final PartitionService partitionService;
    private final TasksQueueConfig queueConfig;
    private final Map<JobType, JobProcessor> jobProcessors;
    private final Map<JobType, TbQueueProducer<TbProtoQueueMsg<TransportProtos.TaskProto>>> taskProducers;
    private final ExecutorService executor;

    public DefaultJobManager(JobService jobService, JobStatsService jobStatsService, PartitionService partitionService, TaskProducerQueueFactory queueFactory, TasksQueueConfig queueConfig, List<JobProcessor> jobProcessors) {
        this.jobService = jobService;
        this.jobStatsService = jobStatsService;
        this.partitionService = partitionService;
        this.queueConfig = queueConfig;
        this.jobProcessors = jobProcessors.stream().collect(Collectors.toMap(JobProcessor::getType, Function.identity()));
        this.taskProducers = Arrays.stream(JobType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((TaskProducerQueueFactory)queueFactory).createTaskProducer(arg_0)));
        this.executor = ThingsBoardExecutors.newWorkStealingPool((int)Math.max(4, Runtime.getRuntime().availableProcessors()), this.getClass());
    }

    public ListenableFuture<Job> submitJob(Job job) {
        log.debug("Submitting job: {}", (Object)job);
        return Futures.submit(() -> this.jobService.saveJob(job.getTenantId(), job), (Executor)this.executor);
    }

    public void onJobUpdate(Job job) {
        JobStatus status = job.getStatus();
        switch (2.$SwitchMap$org$thingsboard$server$common$data$job$JobStatus[status.ordinal()]) {
            case 1: {
                this.executor.execute(() -> {
                    try {
                        this.processJob(job);
                    }
                    catch (Throwable e) {
                        log.error("Failed to process job update: {}", (Object)job, (Object)e);
                    }
                });
                break;
            }
            case 2: 
            case 3: {
                this.executor.execute(() -> {
                    try {
                        this.getJobProcessor(job.getType()).onJobFinished(job);
                    }
                    catch (Throwable e) {
                        log.error("Failed to process job update: {}", (Object)job, (Object)e);
                    }
                });
            }
        }
    }

    private void processJob(Job job) {
        TenantId tenantId = job.getTenantId();
        JobId jobId = (JobId)job.getId();
        try {
            JobProcessor processor = this.getJobProcessor(job.getType());
            List toReprocess = job.getConfiguration().getToReprocess();
            if (toReprocess == null) {
                int tasksCount = processor.process(job, arg_0 -> this.submitTask(arg_0));
                log.info("[{}][{}][{}] Submitted {} tasks", new Object[]{tenantId, jobId, job.getType(), tasksCount});
                this.jobStatsService.reportAllTasksSubmitted(tenantId, jobId, tasksCount);
            } else {
                processor.reprocess(job, toReprocess, arg_0 -> this.submitTask(arg_0));
                log.info("[{}][{}][{}] Submitted {} tasks for reprocessing", new Object[]{tenantId, jobId, job.getType(), toReprocess.size()});
            }
        }
        catch (Throwable e) {
            log.error("[{}][{}][{}] Failed to submit tasks", new Object[]{tenantId, jobId, job.getType(), e});
            this.jobService.markAsFailed(tenantId, jobId, e.getMessage());
        }
    }

    public void cancelJob(TenantId tenantId, JobId jobId) {
        log.info("[{}][{}] Cancelling job", (Object)tenantId, (Object)jobId);
        this.jobService.cancelJob(tenantId, jobId);
    }

    public void reprocessJob(TenantId tenantId, JobId jobId) {
        log.info("[{}][{}] Reprocessing job", (Object)tenantId, (Object)jobId);
        Job job = this.jobService.findJobById(tenantId, jobId);
        if (job.getStatus() != JobStatus.FAILED) {
            throw new IllegalArgumentException("Job is not failed");
        }
        JobResult result = job.getResult();
        if (result.getGeneralError() != null) {
            job.presetResult();
        } else {
            List<TaskResult> taskFailures = result.getResults().stream().filter(taskResult -> !taskResult.isSuccess() && !taskResult.isDiscarded()).toList();
            if (result.getFailedCount() > taskFailures.size()) {
                throw new IllegalArgumentException("Reprocessing not allowed since there are too many failures (more than " + taskFailures.size() + ")");
            }
            result.setFailedCount(0);
            result.setResults(result.getResults().stream().filter(TaskResult::isSuccess).toList());
            job.getConfiguration().setToReprocess(taskFailures);
        }
        job.getConfiguration().setTasksKey(UUID.randomUUID().toString());
        this.jobService.saveJob(tenantId, job);
    }

    private void submitTask(Task<?> task) {
        if (ObjectUtils.anyNull((Object[])new Object[]{task.getTenantId(), task.getJobId(), task.getKey()})) {
            throw new IllegalArgumentException("Task " + String.valueOf(task) + " missing required fields");
        }
        log.debug("[{}][{}] Submitting task: {}", new Object[]{task.getTenantId(), task.getJobId(), task});
        TransportProtos.TaskProto taskProto = TransportProtos.TaskProto.newBuilder().setValue(JacksonUtil.toString(task)).build();
        TbQueueProducer producer = (TbQueueProducer)this.taskProducers.get(task.getJobType());
        EntityId entityId = null;
        if (this.queueConfig.getPartitioningStrategy().equals("entity")) {
            entityId = task.getEntityId();
        }
        if (entityId == null) {
            entityId = task.getTenantId();
        }
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TASK_PROCESSOR, task.getJobType().name(), task.getTenantId(), entityId);
        producer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)taskProto), (TbQueueCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private JobProcessor getJobProcessor(JobType jobType) {
        return (JobProcessor)this.jobProcessors.get(jobType);
    }

    @PreDestroy
    private void destroy() {
        this.executor.shutdownNow();
    }
}

