/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.update;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.query.DynamicValue;
import org.thingsboard.server.common.data.query.FilterPredicateValue;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.service.component.ComponentDiscoveryService;
import org.thingsboard.server.service.component.RuleNodeClassInfo;
import org.thingsboard.server.service.install.DbUpgradeExecutorService;
import org.thingsboard.server.service.install.update.DataUpdateService;
import org.thingsboard.server.utils.TbNodeUpgradeUtils;

@Service
@Profile(value={"install"})
public class DefaultDataUpdateService
implements DataUpdateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDataUpdateService.class);
    private static final int MAX_PENDING_SAVE_RULE_NODE_FUTURES = 256;
    private static final int DEFAULT_PAGE_SIZE = 1024;
    private final RuleChainService ruleChainService;
    private final ComponentDiscoveryService componentDiscoveryService;
    private final DbUpgradeExecutorService executorService;

    public void updateData() throws Exception {
        log.info("Updating data ...");
        log.info("Data updated.");
    }

    public void upgradeRuleNodes() {
        int totalRuleNodesUpgraded = 0;
        log.info("Starting rule nodes upgrade ...");
        List nodeClassToVersionMap = this.componentDiscoveryService.getVersionedNodes();
        log.debug("Found {} versioned nodes to check for upgrade!", (Object)nodeClassToVersionMap.size());
        for (RuleNodeClassInfo ruleNodeClassInfo : nodeClassToVersionMap) {
            String ruleNodeTypeForLogs = ruleNodeClassInfo.getSimpleName();
            int toVersion = ruleNodeClassInfo.getCurrentVersion();
            try {
                log.debug("Going to check for nodes with type: {} to upgrade to version: {}.", (Object)ruleNodeTypeForLogs, (Object)toVersion);
                List ruleNodesIdsToUpgrade = this.getRuleNodesIdsWithTypeAndVersionLessThan(ruleNodeClassInfo.getClassName(), toVersion);
                if (ruleNodesIdsToUpgrade.isEmpty()) {
                    log.debug("There are no active nodes with type {}, or all nodes with this type already set to latest version!", (Object)ruleNodeTypeForLogs);
                    continue;
                }
                List ruleNodeIdsPartitions = Lists.partition((List)ruleNodesIdsToUpgrade, (int)256);
                for (List ruleNodePack : ruleNodeIdsPartitions) {
                    log.info("{} upgraded rule nodes so far ...", (Object)(totalRuleNodesUpgraded += this.processRuleNodePack(ruleNodePack, ruleNodeClassInfo)));
                }
            }
            catch (Exception e) {
                log.error("Unexpected error during {} rule nodes upgrade: ", (Object)ruleNodeTypeForLogs, (Object)e);
            }
        }
        log.info("Finished rule nodes upgrade. Upgraded rule nodes count: {}", (Object)totalRuleNodesUpgraded);
    }

    private int processRuleNodePack(List<RuleNodeId> ruleNodeIdsBatch, RuleNodeClassInfo ruleNodeClassInfo) {
        ArrayList<ListenableFuture> saveFutures = new ArrayList<ListenableFuture>(256);
        String ruleNodeType = ruleNodeClassInfo.getSimpleName();
        int toVersion = ruleNodeClassInfo.getCurrentVersion();
        List ruleNodesPack = this.ruleChainService.findAllRuleNodesByIds(ruleNodeIdsBatch);
        for (RuleNode ruleNode : ruleNodesPack) {
            if (ruleNode == null) continue;
            RuleNodeId ruleNodeId = ruleNode.getId();
            int fromVersion = ruleNode.getConfigurationVersion();
            log.debug("Going to upgrade rule node with id: {} type: {} fromVersion: {} toVersion: {}", new Object[]{ruleNodeId, ruleNodeType, fromVersion, toVersion});
            try {
                TbNodeUpgradeUtils.upgradeConfigurationAndVersion((RuleNode)ruleNode, (RuleNodeClassInfo)ruleNodeClassInfo);
                saveFutures.add(this.executorService.submit(() -> {
                    this.ruleChainService.saveRuleNode(TenantId.SYS_TENANT_ID, ruleNode);
                    log.debug("Successfully upgrade rule node with id: {} type: {} fromVersion: {} toVersion: {}", new Object[]{ruleNodeId, ruleNodeType, fromVersion, toVersion});
                }));
            }
            catch (Exception e) {
                log.warn("Failed to upgrade rule node with id: {} type: {} fromVersion: {} toVersion: {} due to: ", new Object[]{ruleNodeId, ruleNodeType, fromVersion, toVersion, e});
            }
        }
        try {
            return ((List)Futures.allAsList(saveFutures).get()).size();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to process save rule nodes requests due to: ", e);
        }
    }

    private List<RuleNodeId> getRuleNodesIdsWithTypeAndVersionLessThan(String type, int toVersion) {
        ArrayList<RuleNodeId> ruleNodeIds = new ArrayList<RuleNodeId>();
        new PageDataIterable(pageLink -> this.ruleChainService.findAllRuleNodeIdsByTypeAndVersionLessThan(type, toVersion, pageLink), 1024).forEach(ruleNodeIds::add);
        return ruleNodeIds;
    }

    boolean convertDeviceProfileForVersion330(JsonNode profileData) {
        boolean isUpdated = false;
        if (profileData.has("alarms") && !profileData.get("alarms").isNull()) {
            JsonNode alarms = profileData.get("alarms");
            for (JsonNode alarm : alarms) {
                JsonNode spec;
                if (alarm.has("createRules")) {
                    JsonNode createRules = alarm.get("createRules");
                    for (AlarmSeverity severity : AlarmSeverity.values()) {
                        JsonNode spec2;
                        if (!createRules.has(severity.name()) || !this.convertDeviceProfileAlarmRulesForVersion330(spec2 = createRules.get(severity.name()).get("condition").get("spec"))) continue;
                        isUpdated = true;
                    }
                }
                if (!alarm.has("clearRule") || alarm.get("clearRule").isNull() || !this.convertDeviceProfileAlarmRulesForVersion330(spec = alarm.get("clearRule").get("condition").get("spec"))) continue;
                isUpdated = true;
            }
        }
        return isUpdated;
    }

    boolean convertDeviceProfileAlarmRulesForVersion330(JsonNode spec) {
        if (spec != null) {
            if (spec.has("type") && spec.get("type").asText().equals("DURATION")) {
                if (spec.has("value")) {
                    long value = spec.get("value").asLong();
                    FilterPredicateValue predicate = new FilterPredicateValue((Object)value, null, new DynamicValue(null, null, false));
                    ((ObjectNode)spec).remove("value");
                    ((ObjectNode)spec).putPOJO("predicate", (Object)predicate);
                    return true;
                }
            } else if (spec.has("type") && spec.get("type").asText().equals("REPEATING") && spec.has("count")) {
                int count = spec.get("count").asInt();
                FilterPredicateValue predicate = new FilterPredicateValue((Object)count, null, new DynamicValue(null, null, false));
                ((ObjectNode)spec).remove("count");
                ((ObjectNode)spec).putPOJO("predicate", (Object)predicate);
                return true;
            }
        }
        return false;
    }

    public static boolean getEnv(String name, boolean defaultValue) {
        String env = System.getenv(name);
        if (env == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(env);
    }

    @ConstructorProperties(value={"ruleChainService", "componentDiscoveryService", "executorService"})
    @Generated
    public DefaultDataUpdateService(RuleChainService ruleChainService, ComponentDiscoveryService componentDiscoveryService, DbUpgradeExecutorService executorService) {
        this.ruleChainService = ruleChainService;
        this.componentDiscoveryService = componentDiscoveryService;
        this.executorService = executorService;
    }
}

