/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.cql;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.service.install.cql.CQLStatementsParser;

public class CQLStatementsParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CQLStatementsParser.class);
    private String text;
    private State state;
    private int pos;
    private List<String> statements;

    public CQLStatementsParser(Path cql) throws IOException {
        try {
            List<String> lines = Files.readAllLines(cql);
            StringBuilder t = new StringBuilder();
            for (String l : lines) {
                t.append(l.trim());
                t.append('\n');
            }
            this.text = t.toString();
            this.pos = 0;
            this.state = State.DEFAULT;
            this.parseStatements();
        }
        catch (IOException e) {
            log.error("Unable to parse CQL file [{}]!", (Object)cql);
            log.error("Exception", (Throwable)e);
            throw e;
        }
    }

    public List<String> getStatements() {
        return this.statements;
    }

    private void parseStatements() {
        char c;
        this.statements = new ArrayList();
        StringBuilder statementUnderConstruction = new StringBuilder();
        while ((c = this.getChar()) != '\u0000') {
            switch (1.$SwitchMap$org$thingsboard$server$service$install$cql$CQLStatementsParser$State[this.state.ordinal()]) {
                case 1: {
                    this.processDefaultState(c, statementUnderConstruction);
                    break;
                }
                case 2: {
                    if (c != '\n') break;
                    this.state = State.DEFAULT;
                    break;
                }
                case 3: {
                    if (c != '*' || this.peekAhead() != '/') break;
                    this.state = State.DEFAULT;
                    this.advance();
                    break;
                }
                case 4: {
                    this.processInQuoteStringState(c, statementUnderConstruction);
                    break;
                }
                case 5: {
                    this.processInSQuoteStringState(c, statementUnderConstruction);
                }
            }
        }
        String tmp = statementUnderConstruction.toString().trim();
        if (tmp.length() > 0) {
            this.statements.add(tmp);
        }
    }

    private void processDefaultState(char c, StringBuilder statementUnderConstruction) {
        if (c == '/' && this.peekAhead() == '/' || c == '-' && this.peekAhead() == '-') {
            this.state = State.INSINGLELINECOMMENT;
            this.advance();
        } else if (c == '/' && this.peekAhead() == '*') {
            this.state = State.INMULTILINECOMMENT;
            this.advance();
        } else if (c == '\n') {
            statementUnderConstruction.append(' ');
        } else {
            statementUnderConstruction.append(c);
            if (c == '\"') {
                this.state = State.INQUOTESTRING;
            } else if (c == '\'') {
                this.state = State.INSQUOTESTRING;
            } else if (c == ';') {
                this.statements.add(statementUnderConstruction.toString().trim());
                statementUnderConstruction.setLength(0);
            }
        }
    }

    private void processInQuoteStringState(char c, StringBuilder statementUnderConstruction) {
        statementUnderConstruction.append(c);
        if (c == '\"') {
            if (this.peekAhead() == '\"') {
                statementUnderConstruction.append(this.getChar());
            } else {
                this.state = State.DEFAULT;
            }
        }
    }

    private void processInSQuoteStringState(char c, StringBuilder statementUnderConstruction) {
        statementUnderConstruction.append(c);
        if (c == '\'') {
            if (this.peekAhead() == '\'') {
                statementUnderConstruction.append(this.getChar());
            } else {
                this.state = State.DEFAULT;
            }
        }
    }

    private char getChar() {
        if (this.pos < this.text.length()) {
            return this.text.charAt(this.pos++);
        }
        return '\u0000';
    }

    private char peekAhead() {
        if (this.pos < this.text.length()) {
            return this.text.charAt(this.pos);
        }
        return '\u0000';
    }

    private void advance() {
        ++this.pos;
    }
}

