/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.thingsboard.server.dao.util.TimescaleDBTsDao;
import org.thingsboard.server.service.install.SqlAbstractDatabaseSchemaService;
import org.thingsboard.server.service.install.TsDatabaseSchemaService;

@Service
@TimescaleDBTsDao
@Profile(value={"install"})
public class TimescaleTsDatabaseSchemaService
extends SqlAbstractDatabaseSchemaService
implements TsDatabaseSchemaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimescaleTsDatabaseSchemaService.class);
    @Value(value="${sql.timescale.chunk_time_interval:86400000}")
    private long chunkTimeInterval;

    public TimescaleTsDatabaseSchemaService() {
        super("schema-timescale.sql", null);
    }

    public void createDatabaseSchema() throws Exception {
        super.createDatabaseSchema();
        this.executeQuery("SELECT create_hypertable('ts_kv', 'ts', chunk_time_interval => " + this.chunkTimeInterval + ", if_not_exists => true);");
    }
}

