/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.thingsboard.server.service.install.DatabaseSchemaSettingsService;
import org.thingsboard.server.service.install.ProjectInfo;
import org.thingsboard.server.service.install.update.DefaultDataUpdateService;

@Service
public class DefaultDatabaseSchemaSettingsService
implements DatabaseSchemaSettingsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseSchemaSettingsService.class);
    private static final List<String> SUPPORTED_VERSIONS_FOR_UPGRADE = List.of("4.2.0.0", "4.2.1.0");
    private final ProjectInfo projectInfo;
    private final JdbcTemplate jdbcTemplate;
    private String packageSchemaVersion;
    private String schemaVersionFromDb;

    public void validateSchemaSettings() {
        String dbSchemaVersion;
        if (DefaultDataUpdateService.getEnv((String)"SKIP_SCHEMA_VERSION_CHECK", (boolean)false)) {
            log.info("Skipped DB schema version check due to SKIP_SCHEMA_VERSION_CHECK set to 'true'.");
            return;
        }
        String product = this.getProductFromDb();
        if (!this.projectInfo.getProductType().equals(product)) {
            this.onSchemaSettingsError(String.format("Upgrade failed: can't upgrade ThingsBoard %s database using ThingsBoard %s.", product, this.projectInfo.getProductType()));
        }
        if ((dbSchemaVersion = this.getDbSchemaVersion()).equals(this.getPackageSchemaVersion())) {
            this.onSchemaSettingsError("Upgrade failed: database already upgraded to current version. You can set SKIP_SCHEMA_VERSION_CHECK to 'true' if force re-upgrade needed.");
        }
        if (!SUPPORTED_VERSIONS_FOR_UPGRADE.contains(dbSchemaVersion)) {
            this.onSchemaSettingsError(String.format("Upgrade failed: database version '%s' is not supported for upgrade. Supported versions are: %s.", dbSchemaVersion, SUPPORTED_VERSIONS_FOR_UPGRADE));
        }
    }

    public void createSchemaSettings() {
        Long schemaVersion = this.getSchemaVersionFromDb();
        if (schemaVersion == null) {
            this.jdbcTemplate.execute("INSERT INTO tb_schema_settings (schema_version, product) VALUES (" + this.getPackageSchemaVersionForDb() + ", '" + this.projectInfo.getProductType() + "')");
        }
    }

    public void updateSchemaVersion() {
        this.jdbcTemplate.execute("UPDATE tb_schema_settings SET schema_version = " + this.getPackageSchemaVersionForDb());
    }

    public String getPackageSchemaVersion() {
        if (this.packageSchemaVersion == null) {
            this.packageSchemaVersion = this.normalizeVersion(this.projectInfo.getProjectVersion());
        }
        return this.packageSchemaVersion;
    }

    public String getDbSchemaVersion() {
        if (this.schemaVersionFromDb == null) {
            long version;
            Long dbVersion = this.getSchemaVersionFromDb();
            if (dbVersion == null) {
                this.onSchemaSettingsError("Upgrade failed: the database schema version is missing.");
            }
            if ((version = dbVersion.longValue()) < 1000000000L) {
                long major = version / 1000000L;
                long minor = version % 1000000L / 1000L;
                long maintenance = version % 1000L;
                this.schemaVersionFromDb = major + "." + minor + "." + maintenance + ".0";
            } else {
                long major = version / 1000000000L;
                long minor = version % 1000000000L / 1000000L;
                long maintenance = version % 1000000L / 1000L;
                long patch = version % 1000L;
                this.schemaVersionFromDb = major + "." + minor + "." + maintenance + "." + patch;
            }
        }
        return this.schemaVersionFromDb;
    }

    private Long getSchemaVersionFromDb() {
        return this.jdbcTemplate.queryForList("SELECT schema_version FROM tb_schema_settings", Long.class).stream().findFirst().orElse(null);
    }

    private String getProductFromDb() {
        return this.jdbcTemplate.queryForList("SELECT product FROM tb_schema_settings", String.class).stream().findFirst().orElse(null);
    }

    private long getPackageSchemaVersionForDb() {
        String[] versionParts = this.getPackageSchemaVersion().split("\\.");
        long major = Integer.parseInt(versionParts[0]);
        long minor = Integer.parseInt(versionParts[1]);
        long maintenance = Integer.parseInt(versionParts[2]);
        long patch = Integer.parseInt(versionParts[3]);
        return major * 1000000000L + minor * 1000000L + maintenance * 1000L + patch;
    }

    private void onSchemaSettingsError(String message) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> log.error(message)));
        throw new RuntimeException(message);
    }

    private String normalizeVersion(String version) {
        String[] parts = version.split("\\.");
        int major = Integer.parseInt(parts[0]);
        int minor = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        int maintenance = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
        int patch = parts.length > 3 ? Integer.parseInt(parts[3]) : 0;
        return major + "." + minor + "." + maintenance + "." + patch;
    }

    @ConstructorProperties(value={"projectInfo", "jdbcTemplate"})
    @Generated
    public DefaultDatabaseSchemaSettingsService(ProjectInfo projectInfo, JdbcTemplate jdbcTemplate) {
        this.projectInfo = projectInfo;
        this.jdbcTemplate = jdbcTemplate;
    }
}

