/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.processor;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.housekeeper.EntitiesDeletionHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.data.housekeeper.TenantEntitiesDeletionHousekeeperTask;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.Dao;
import org.thingsboard.server.dao.entity.EntityDaoRegistry;
import org.thingsboard.server.service.housekeeper.processor.HousekeeperTaskProcessor;

@Component
public class TenantEntitiesDeletionTaskProcessor
extends HousekeeperTaskProcessor<TenantEntitiesDeletionHousekeeperTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantEntitiesDeletionTaskProcessor.class);
    private final EntityDaoRegistry entityDaoRegistry;

    public void process(TenantEntitiesDeletionHousekeeperTask task) throws Exception {
        List entities;
        EntityType entityType = task.getEntityType();
        TenantId tenantId = task.getTenantId();
        Dao entityDao = this.entityDaoRegistry.getDao(entityType);
        UUID last = null;
        while (!(entities = entityDao.findIdsByTenantIdAndIdOffset(tenantId, last, 128)).isEmpty()) {
            this.housekeeperClient.submitTask((HousekeeperTask)new EntitiesDeletionHousekeeperTask(tenantId, entityType, entities));
            last = (UUID)entities.get(entities.size() - 1);
            log.debug("[{}] Submitted task for deleting {} {}s", new Object[]{tenantId, entities.size(), entityType.getNormalName().toLowerCase()});
        }
    }

    public HousekeeperTaskType getTaskType() {
        return HousekeeperTaskType.DELETE_TENANT_ENTITIES;
    }

    @ConstructorProperties(value={"entityDaoRegistry"})
    @Generated
    public TenantEntitiesDeletionTaskProcessor(EntityDaoRegistry entityDaoRegistry) {
        this.entityDaoRegistry = entityDaoRegistry;
    }
}

