/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.processor;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.data.housekeeper.LatestTsDeletionHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.TsHistoryDeletionHousekeeperTask;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.service.housekeeper.processor.HousekeeperTaskProcessor;

@Component
public class TelemetryDeletionTaskProcessor
extends HousekeeperTaskProcessor<HousekeeperTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelemetryDeletionTaskProcessor.class);
    private final TimeseriesService timeseriesService;

    public void process(HousekeeperTask task) throws Exception {
        TenantId tenantId = task.getTenantId();
        EntityId entityId = task.getEntityId();
        List keys = this.timeseriesService.findAllKeysByEntityIds(tenantId, List.of(entityId));
        for (String key : keys) {
            LatestTsDeletionHousekeeperTask latestTsDeletionTask = new LatestTsDeletionHousekeeperTask(tenantId, entityId, key);
            this.housekeeperClient.submitTask((HousekeeperTask)latestTsDeletionTask);
            TsHistoryDeletionHousekeeperTask tsHistoryDeletionTask = new TsHistoryDeletionHousekeeperTask(tenantId, entityId, key);
            this.housekeeperClient.submitTask((HousekeeperTask)tsHistoryDeletionTask);
        }
        log.trace("[{}][{}][{}] Submitted latest and ts history deletion tasks for {} keys", new Object[]{tenantId, entityId.getEntityType(), entityId, keys.size()});
    }

    public HousekeeperTaskType getTaskType() {
        return HousekeeperTaskType.DELETE_TELEMETRY;
    }

    @ConstructorProperties(value={"timeseriesService"})
    @Generated
    public TelemetryDeletionTaskProcessor(TimeseriesService timeseriesService) {
        this.timeseriesService = timeseriesService;
    }
}

