/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.processor;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.service.housekeeper.processor.HousekeeperTaskProcessor;

@Component
public class AttributesDeletionTaskProcessor
extends HousekeeperTaskProcessor<HousekeeperTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttributesDeletionTaskProcessor.class);
    private final AttributesService attributesService;

    public void process(HousekeeperTask task) throws Exception {
        int deletedCount = this.attributesService.removeAllByEntityId(task.getTenantId(), task.getEntityId());
        log.debug("[{}][{}][{}] Deleted {} attributes", new Object[]{task.getTenantId(), task.getEntityId().getEntityType(), task.getEntityId(), deletedCount});
    }

    public HousekeeperTaskType getTaskType() {
        return HousekeeperTaskType.DELETE_ATTRIBUTES;
    }

    @ConstructorProperties(value={"attributesService"})
    @Generated
    public AttributesDeletionTaskProcessor(AttributesService attributesService) {
        this.attributesService = attributesService;
    }
}

