/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.queue;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileQueueConfiguration;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.dao.queue.QueueService;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.queue.TbQueueService;

@Service
@TbCoreComponent
public class DefaultTbQueueService
extends AbstractTbEntityService
implements TbQueueService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbQueueService.class);
    private final QueueService queueService;
    private final TbClusterService tbClusterService;
    private final TbQueueAdmin tbQueueAdmin;

    public Queue saveQueue(Queue queue) {
        boolean create = queue.getId() == null;
        Queue oldQueue = create ? null : this.queueService.findQueueById(queue.getTenantId(), (QueueId)queue.getId());
        Queue savedQueue = this.queueService.saveQueue(queue);
        this.createTopicsIfNeeded(savedQueue, oldQueue);
        this.tbClusterService.onQueuesUpdate(List.of(savedQueue));
        return savedQueue;
    }

    public void deleteQueue(TenantId tenantId, QueueId queueId) {
        Queue queue = this.queueService.findQueueById(tenantId, queueId);
        this.queueService.deleteQueue(tenantId, queueId);
        this.tbClusterService.onQueuesDelete(List.of(queue));
    }

    public void deleteQueueByQueueName(TenantId tenantId, String queueName) {
        Queue queue = this.queueService.findQueueByTenantIdAndNameInternal(tenantId, queueName);
        this.queueService.deleteQueue(tenantId, (QueueId)queue.getId());
        this.tbClusterService.onQueuesDelete(List.of(queue));
    }

    public void updateQueuesByTenants(List<TenantId> tenantIds, TenantProfile newTenantProfile, TenantProfile oldTenantProfile) {
        boolean oldIsolated = oldTenantProfile != null && oldTenantProfile.isIsolatedTbRuleEngine();
        boolean newIsolated = newTenantProfile.isIsolatedTbRuleEngine();
        if (!oldIsolated && !newIsolated) {
            return;
        }
        if (newTenantProfile.equals((Object)oldTenantProfile)) {
            return;
        }
        Map<Object, Object> oldQueues = oldIsolated ? oldTenantProfile.getProfileData().getQueueConfiguration().stream().collect(Collectors.toMap(TenantProfileQueueConfiguration::getName, q -> q)) : Collections.emptyMap();
        Map<Object, Object> newQueues = newIsolated ? newTenantProfile.getProfileData().getQueueConfiguration().stream().collect(Collectors.toMap(TenantProfileQueueConfiguration::getName, q -> q)) : Collections.emptyMap();
        ArrayList<String> toRemove = new ArrayList<String>();
        ArrayList<String> toCreate = new ArrayList<String>();
        ArrayList<String> toUpdate = new ArrayList<String>();
        for (String string : oldQueues.keySet()) {
            if (newQueues.containsKey(string)) continue;
            toRemove.add(string);
        }
        for (String string : newQueues.keySet()) {
            if (oldQueues.containsKey(string)) {
                toUpdate.add(string);
                continue;
            }
            toCreate.add(string);
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Handling profile queue config update: creating queues {}, updating {}, deleting {}. Affected tenants: {}", new Object[]{newTenantProfile.getUuidId(), toCreate, toUpdate, toRemove, tenantIds});
        }
        List<Object> updated = new ArrayList<Queue>();
        ArrayList<Queue> arrayList = new ArrayList<Queue>();
        for (TenantId tenantId : tenantIds) {
            for (String name : toCreate) {
                updated.add(new Queue(tenantId, (TenantProfileQueueConfiguration)newQueues.get(name)));
            }
            for (String name : toUpdate) {
                Queue queue2 = new Queue(tenantId, (TenantProfileQueueConfiguration)newQueues.get(name));
                Queue foundQueue = this.queueService.findQueueByTenantIdAndName(tenantId, name);
                if (foundQueue != null) {
                    queue2.setId((UUIDBased)((QueueId)foundQueue.getId()));
                    queue2.setCreatedTime(foundQueue.getCreatedTime());
                }
                if (queue2.equals((Object)foundQueue)) continue;
                updated.add(queue2);
                this.createTopicsIfNeeded(queue2, foundQueue);
            }
            for (String name : toRemove) {
                Queue queue2 = this.queueService.findQueueByTenantIdAndNameInternal(tenantId, name);
                arrayList.add(queue2);
            }
        }
        if (!updated.isEmpty()) {
            updated = updated.stream().map(arg_0 -> ((QueueService)this.queueService).saveQueue(arg_0)).collect(Collectors.toList());
            this.tbClusterService.onQueuesUpdate(updated);
        }
        if (!arrayList.isEmpty()) {
            arrayList.forEach(queue -> this.queueService.deleteQueue(queue.getTenantId(), (QueueId)queue.getId()));
            this.tbClusterService.onQueuesDelete(arrayList);
        }
    }

    private void createTopicsIfNeeded(Queue queue, Queue oldQueue) {
        int oldPartitions;
        int newPartitions = queue.getPartitions();
        for (int i = oldPartitions = oldQueue != null ? oldQueue.getPartitions() : 0; i < newPartitions; ++i) {
            this.tbQueueAdmin.createTopicIfNotExists(new TopicPartitionInfo(queue.getTopic(), queue.getTenantId(), Integer.valueOf(i), false).getFullTopicName(), queue.getCustomProperties(), true);
        }
    }

    @ConstructorProperties(value={"queueService", "tbClusterService", "tbQueueAdmin"})
    @Generated
    public DefaultTbQueueService(QueueService queueService, TbClusterService tbClusterService, TbQueueAdmin tbQueueAdmin) {
        this.queueService = queueService;
        this.tbClusterService = tbClusterService;
        this.tbQueueAdmin = tbQueueAdmin;
    }
}

