/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.mobile;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.MobileAppId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mobile.app.MobileApp;
import org.thingsboard.server.dao.mobile.MobileAppService;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.mobile.TbMobileAppService;

@Service
public class DefaultTbMobileAppService
extends AbstractTbEntityService
implements TbMobileAppService {
    private final MobileAppService mobileAppService;

    public MobileApp save(MobileApp mobileApp, User user) throws Exception {
        ActionType actionType = mobileApp.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = mobileApp.getTenantId();
        try {
            MobileApp savedMobileApp = (MobileApp)this.checkNotNull((Object)this.mobileAppService.saveMobileApp(tenantId, mobileApp));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)((MobileAppId)savedMobileApp.getId()), (HasName)savedMobileApp, actionType, user, new Object[0]);
            return savedMobileApp;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.MOBILE_APP), (HasName)mobileApp, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    public void delete(MobileApp mobileApp, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = mobileApp.getTenantId();
        MobileAppId mobileAppId = (MobileAppId)mobileApp.getId();
        try {
            this.mobileAppService.deleteMobileAppById(tenantId, mobileAppId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)mobileAppId, (HasName)mobileApp, actionType, user, new Object[0]);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)mobileAppId, (HasName)mobileApp, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @ConstructorProperties(value={"mobileAppService"})
    @Generated
    public DefaultTbMobileAppService(MobileAppService mobileAppService) {
        this.mobileAppService = mobileAppService;
    }
}

