/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.dashboard;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.ShortCustomerInfo;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.dashboard.TbDashboardService;
import org.thingsboard.server.service.resource.TbResourceService;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service
@TbCoreComponent
public class DefaultTbDashboardService
extends AbstractTbEntityService
implements TbDashboardService {
    private final DashboardService dashboardService;
    private final TbResourceService tbResourceService;

    public Dashboard save(Dashboard dashboard, SecurityUser user) throws Exception {
        ActionType actionType = dashboard.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = dashboard.getTenantId();
        if (CollectionUtils.isNotEmpty((Collection)dashboard.getResources())) {
            this.tbResourceService.importResources(dashboard.getResources(), user);
        }
        try {
            Dashboard savedDashboard = (Dashboard)this.checkNotNull((Object)this.dashboardService.saveDashboard(dashboard));
            this.autoCommit((User)user, (EntityId)savedDashboard.getId());
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedDashboard.getId(), (HasName)savedDashboard, null, actionType, (User)user, new Object[0]);
            return savedDashboard;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DASHBOARD), (HasName)dashboard, actionType, (User)user, e, new Object[0]);
            throw e;
        }
    }

    public void delete(Dashboard dashboard, User user) {
        ActionType actionType = ActionType.DELETED;
        DashboardId dashboardId = dashboard.getId();
        TenantId tenantId = dashboard.getTenantId();
        try {
            this.dashboardService.deleteDashboard(tenantId, dashboardId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)dashboardId, (HasName)dashboard, null, actionType, user, new Object[]{dashboardId.toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DASHBOARD), actionType, user, e, new Object[]{dashboardId.toString()});
            throw e;
        }
    }

    public Dashboard assignDashboardToCustomer(Dashboard dashboard, Customer customer, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_CUSTOMER;
        TenantId tenantId = dashboard.getTenantId();
        CustomerId customerId = customer.getId();
        DashboardId dashboardId = dashboard.getId();
        try {
            Dashboard savedDashboard = (Dashboard)this.checkNotNull((Object)this.dashboardService.assignDashboardToCustomer(tenantId, dashboardId, customerId));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)dashboardId, (HasName)savedDashboard, customerId, actionType, user, new Object[]{dashboardId.toString(), customerId.toString(), customer.getName()});
            return savedDashboard;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DASHBOARD), actionType, user, e, new Object[]{dashboardId.toString(), customerId.toString()});
            throw e;
        }
    }

    public Dashboard assignDashboardToPublicCustomer(Dashboard dashboard, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_CUSTOMER;
        TenantId tenantId = dashboard.getTenantId();
        DashboardId dashboardId = dashboard.getId();
        try {
            Customer publicCustomer = this.customerService.findOrCreatePublicCustomer(tenantId);
            Dashboard savedDashboard = (Dashboard)this.checkNotNull((Object)this.dashboardService.assignDashboardToCustomer(tenantId, dashboardId, publicCustomer.getId()));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)dashboardId, (HasName)savedDashboard, publicCustomer.getId(), actionType, user, new Object[]{dashboardId.toString(), publicCustomer.getId().toString(), publicCustomer.getName()});
            return savedDashboard;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DASHBOARD), actionType, user, e, new Object[]{dashboardId.toString()});
            throw e;
        }
    }

    public Dashboard unassignDashboardFromPublicCustomer(Dashboard dashboard, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UNASSIGNED_FROM_CUSTOMER;
        TenantId tenantId = dashboard.getTenantId();
        DashboardId dashboardId = dashboard.getId();
        try {
            Customer publicCustomer = this.customerService.findOrCreatePublicCustomer(tenantId);
            Dashboard savedDashboard = (Dashboard)this.checkNotNull((Object)this.dashboardService.unassignDashboardFromCustomer(tenantId, dashboardId, publicCustomer.getId()));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)dashboardId, (HasName)dashboard, publicCustomer.getId(), actionType, user, new Object[]{dashboardId.toString(), publicCustomer.getId().toString(), publicCustomer.getName()});
            return savedDashboard;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DASHBOARD), actionType, user, e, new Object[]{dashboardId.toString()});
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Dashboard updateDashboardCustomers(Dashboard dashboard, Set<CustomerId> customerIds, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_CUSTOMER;
        TenantId tenantId = dashboard.getTenantId();
        DashboardId dashboardId = dashboard.getId();
        try {
            void var10_17;
            ShortCustomerInfo customerInfo;
            HashSet<CustomerId> addedCustomerIds = new HashSet<CustomerId>();
            HashSet<CustomerId> removedCustomerIds = new HashSet<CustomerId>();
            for (CustomerId customerId : customerIds) {
                if (dashboard.isAssignedToCustomer(customerId)) continue;
                addedCustomerIds.add(customerId);
            }
            Set assignedCustomers = dashboard.getAssignedCustomers();
            if (assignedCustomers != null) {
                for (ShortCustomerInfo customerInfo2 : assignedCustomers) {
                    if (customerIds.contains(customerInfo2.getCustomerId())) continue;
                    removedCustomerIds.add(customerInfo2.getCustomerId());
                }
            }
            if (addedCustomerIds.isEmpty() && removedCustomerIds.isEmpty()) {
                return dashboard;
            }
            Object var10_14 = null;
            for (CustomerId customerId : addedCustomerIds) {
                Dashboard dashboard2 = (Dashboard)this.checkNotNull((Object)this.dashboardService.assignDashboardToCustomer(tenantId, dashboardId, customerId));
                customerInfo = dashboard2.getAssignedCustomerInfo(customerId);
                this.logEntityActionService.logEntityAction(tenantId, (EntityId)dashboard2.getId(), (HasName)dashboard2, customerId, actionType, user, new Object[]{dashboardId.toString(), customerId.toString(), customerInfo.getTitle()});
            }
            actionType = ActionType.UNASSIGNED_FROM_CUSTOMER;
            for (CustomerId customerId : removedCustomerIds) {
                customerInfo = dashboard.getAssignedCustomerInfo(customerId);
                Dashboard dashboard3 = (Dashboard)this.checkNotNull((Object)this.dashboardService.unassignDashboardFromCustomer(tenantId, dashboardId, customerId));
                this.logEntityActionService.logEntityAction(tenantId, (EntityId)dashboard3.getId(), (HasName)dashboard3, customerId, actionType, user, new Object[]{dashboardId.toString(), customerId.toString(), customerInfo.getTitle()});
            }
            return var10_17;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DASHBOARD), actionType, user, e, new Object[]{dashboardId.toString()});
            throw e;
        }
    }

    public Dashboard addDashboardCustomers(Dashboard dashboard, Set<CustomerId> customerIds, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_CUSTOMER;
        TenantId tenantId = dashboard.getTenantId();
        DashboardId dashboardId = dashboard.getId();
        try {
            HashSet<CustomerId> addedCustomerIds = new HashSet<CustomerId>();
            for (CustomerId customerId : customerIds) {
                if (dashboard.isAssignedToCustomer(customerId)) continue;
                addedCustomerIds.add(customerId);
            }
            if (addedCustomerIds.isEmpty()) {
                return dashboard;
            }
            Dashboard savedDashboard = null;
            for (CustomerId customerId : addedCustomerIds) {
                savedDashboard = (Dashboard)this.checkNotNull((Object)this.dashboardService.assignDashboardToCustomer(tenantId, dashboardId, customerId));
                ShortCustomerInfo customerInfo = savedDashboard.getAssignedCustomerInfo(customerId);
                this.logEntityActionService.logEntityAction(tenantId, (EntityId)dashboardId, (HasName)savedDashboard, customerId, actionType, user, new Object[]{dashboardId.toString(), customerId.toString(), customerInfo.getTitle()});
            }
            return savedDashboard;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DASHBOARD), actionType, user, e, new Object[]{dashboardId.toString()});
            throw e;
        }
    }

    public Dashboard removeDashboardCustomers(Dashboard dashboard, Set<CustomerId> customerIds, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UNASSIGNED_FROM_CUSTOMER;
        TenantId tenantId = dashboard.getTenantId();
        DashboardId dashboardId = dashboard.getId();
        try {
            HashSet<CustomerId> removedCustomerIds = new HashSet<CustomerId>();
            for (CustomerId customerId : customerIds) {
                if (!dashboard.isAssignedToCustomer(customerId)) continue;
                removedCustomerIds.add(customerId);
            }
            if (removedCustomerIds.isEmpty()) {
                return dashboard;
            }
            Dashboard savedDashboard = null;
            for (CustomerId customerId : removedCustomerIds) {
                ShortCustomerInfo customerInfo = dashboard.getAssignedCustomerInfo(customerId);
                savedDashboard = (Dashboard)this.checkNotNull((Object)this.dashboardService.unassignDashboardFromCustomer(tenantId, dashboardId, customerId));
                this.logEntityActionService.logEntityAction(tenantId, (EntityId)dashboardId, (HasName)savedDashboard, customerId, actionType, user, new Object[]{dashboardId.toString(), customerId.toString(), customerInfo.getTitle()});
            }
            return savedDashboard;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DASHBOARD), actionType, user, e, new Object[]{dashboardId.toString()});
            throw e;
        }
    }

    public Dashboard asignDashboardToEdge(TenantId tenantId, DashboardId dashboardId, Edge edge, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_EDGE;
        EdgeId edgeId = edge.getId();
        try {
            Dashboard savedDashboard = (Dashboard)this.checkNotNull((Object)this.dashboardService.assignDashboardToEdge(tenantId, dashboardId, edgeId));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)dashboardId, (HasName)savedDashboard, null, actionType, user, new Object[]{dashboardId.toString(), edgeId.toString(), edge.getName()});
            return savedDashboard;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), actionType, user, e, new Object[]{dashboardId.toString(), edgeId});
            throw e;
        }
    }

    public Dashboard unassignDashboardFromEdge(Dashboard dashboard, Edge edge, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UNASSIGNED_FROM_EDGE;
        TenantId tenantId = dashboard.getTenantId();
        DashboardId dashboardId = dashboard.getId();
        EdgeId edgeId = edge.getId();
        try {
            Dashboard savedDevice = (Dashboard)this.checkNotNull((Object)this.dashboardService.unassignDashboardFromEdge(tenantId, dashboardId, edgeId));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)dashboardId, (HasName)dashboard, null, actionType, user, new Object[]{dashboardId.toString(), edgeId.toString(), edge.getName()});
            return savedDevice;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DASHBOARD), actionType, user, e, new Object[]{dashboardId.toString(), edgeId.toString()});
            throw e;
        }
    }

    public Dashboard unassignDashboardFromCustomer(Dashboard dashboard, Customer customer, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UNASSIGNED_FROM_CUSTOMER;
        TenantId tenantId = dashboard.getTenantId();
        DashboardId dashboardId = dashboard.getId();
        try {
            Dashboard savedDashboard = (Dashboard)this.checkNotNull((Object)this.dashboardService.unassignDashboardFromCustomer(tenantId, dashboardId, customer.getId()));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)dashboardId, (HasName)savedDashboard, customer.getId(), actionType, user, new Object[]{dashboardId.toString(), customer.getId().toString(), customer.getName()});
            return savedDashboard;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DASHBOARD), actionType, user, e, new Object[]{dashboardId.toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"dashboardService", "tbResourceService"})
    @Generated
    public DefaultTbDashboardService(DashboardService dashboardService, TbResourceService tbResourceService) {
        this.dashboardService = dashboardService;
        this.tbResourceService = tbResourceService;
    }
}

