/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.cf;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.cf.DefaultTbCalculatedFieldService;
import org.thingsboard.server.service.entitiy.cf.TbCalculatedFieldService;
import org.thingsboard.server.service.security.model.SecurityUser;

@TbCoreComponent
@Service
public class DefaultTbCalculatedFieldService
extends AbstractTbEntityService
implements TbCalculatedFieldService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbCalculatedFieldService.class);
    private final CalculatedFieldService calculatedFieldService;

    public CalculatedField save(CalculatedField calculatedField, SecurityUser user) throws ThingsboardException {
        ActionType actionType = calculatedField.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = calculatedField.getTenantId();
        try {
            if (ActionType.UPDATED.equals((Object)actionType)) {
                CalculatedField existingCf = this.calculatedFieldService.findById(tenantId, calculatedField.getId());
                this.checkForEntityChange(existingCf, calculatedField);
            }
            this.checkEntityExistence(tenantId, calculatedField.getEntityId());
            CalculatedField savedCalculatedField = (CalculatedField)this.checkNotNull((Object)this.calculatedFieldService.save(calculatedField));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedCalculatedField.getId(), (HasName)savedCalculatedField, actionType, (User)user, new Object[0]);
            return savedCalculatedField;
        }
        catch (ThingsboardException e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.CALCULATED_FIELD), (HasName)calculatedField, actionType, (User)user, (Exception)((Object)e), new Object[0]);
            throw e;
        }
    }

    public CalculatedField findById(CalculatedFieldId calculatedFieldId, SecurityUser user) {
        return this.calculatedFieldService.findById(user.getTenantId(), calculatedFieldId);
    }

    public PageData<CalculatedField> findAllByTenantIdAndEntityId(EntityId entityId, SecurityUser user, PageLink pageLink) {
        TenantId tenantId = user.getTenantId();
        this.checkEntityExistence(tenantId, entityId);
        return this.calculatedFieldService.findAllCalculatedFieldsByEntityId(tenantId, entityId, pageLink);
    }

    @Transactional
    public void delete(CalculatedField calculatedField, SecurityUser user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = calculatedField.getTenantId();
        CalculatedFieldId calculatedFieldId = calculatedField.getId();
        try {
            this.calculatedFieldService.deleteCalculatedField(tenantId, calculatedFieldId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)calculatedFieldId, (HasName)calculatedField, actionType, (User)user, new Object[]{calculatedFieldId.toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.CALCULATED_FIELD), actionType, (User)user, e, new Object[]{calculatedFieldId.toString()});
            throw e;
        }
    }

    private void checkForEntityChange(CalculatedField oldCalculatedField, CalculatedField newCalculatedField) {
        if (!oldCalculatedField.getEntityId().equals(newCalculatedField.getEntityId())) {
            throw new IllegalArgumentException("Changing the calculated field target entity after initialization is prohibited.");
        }
    }

    private void checkEntityExistence(TenantId tenantId, EntityId entityId) {
        switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Optional.ofNullable(this.entityService.fetchEntity(tenantId, entityId)).orElseThrow(() -> new IllegalArgumentException(entityId.getEntityType().getNormalName() + " with id [" + String.valueOf(entityId.getId()) + "] does not exist."));
                break;
            }
            default: {
                throw new IllegalArgumentException("Entity type '" + String.valueOf(entityId.getEntityType()) + "' does not support calculated fields.");
            }
        }
    }

    @ConstructorProperties(value={"calculatedFieldService"})
    @Generated
    public DefaultTbCalculatedFieldService(CalculatedFieldService calculatedFieldService) {
        this.calculatedFieldService = calculatedFieldService;
    }
}

