/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.asset;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.asset.TbAssetService;

@Service
public class DefaultTbAssetService
extends AbstractTbEntityService
implements TbAssetService {
    private final AssetService assetService;

    public Asset save(Asset asset, User user) throws Exception {
        ActionType actionType = asset.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = asset.getTenantId();
        try {
            Asset savedAsset = (Asset)this.checkNotNull((Object)this.assetService.saveAsset(asset));
            this.autoCommit(user, (EntityId)savedAsset.getId());
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedAsset.getId(), (HasName)savedAsset, asset.getCustomerId(), actionType, user, new Object[0]);
            return savedAsset;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ASSET), (HasName)asset, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @Transactional
    public void delete(Asset asset, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = asset.getTenantId();
        AssetId assetId = asset.getId();
        try {
            this.assetService.deleteAsset(tenantId, assetId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)assetId, (HasName)asset, asset.getCustomerId(), actionType, user, new Object[]{assetId.toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ASSET), actionType, user, e, new Object[]{assetId.toString()});
            throw e;
        }
    }

    public Asset assignAssetToCustomer(TenantId tenantId, AssetId assetId, Customer customer, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_CUSTOMER;
        CustomerId customerId = customer.getId();
        try {
            Asset savedAsset = (Asset)this.checkNotNull((Object)this.assetService.assignAssetToCustomer(tenantId, assetId, customerId));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)assetId, (HasName)savedAsset, customerId, actionType, user, new Object[]{assetId.toString(), customerId.toString(), customer.getName()});
            return savedAsset;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ASSET), actionType, user, e, new Object[]{assetId.toString(), customerId.toString()});
            throw e;
        }
    }

    public Asset unassignAssetToCustomer(TenantId tenantId, AssetId assetId, Customer customer, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UNASSIGNED_FROM_CUSTOMER;
        try {
            Asset savedAsset = (Asset)this.checkNotNull((Object)this.assetService.unassignAssetFromCustomer(tenantId, assetId));
            CustomerId customerId = customer.getId();
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)assetId, (HasName)savedAsset, customerId, actionType, user, new Object[]{assetId.toString(), customerId.toString(), customer.getName()});
            return savedAsset;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ASSET), actionType, user, e, new Object[]{assetId.toString()});
            throw e;
        }
    }

    public Asset assignAssetToPublicCustomer(TenantId tenantId, AssetId assetId, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_CUSTOMER;
        try {
            Customer publicCustomer = this.customerService.findOrCreatePublicCustomer(tenantId);
            Asset savedAsset = (Asset)this.checkNotNull((Object)this.assetService.assignAssetToCustomer(tenantId, assetId, publicCustomer.getId()));
            CustomerId customerId = publicCustomer.getId();
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)assetId, (HasName)savedAsset, customerId, actionType, user, new Object[]{assetId.toString(), customerId.toString(), publicCustomer.getName()});
            return savedAsset;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ASSET), actionType, user, e, new Object[]{assetId.toString()});
            throw e;
        }
    }

    public Asset assignAssetToEdge(TenantId tenantId, AssetId assetId, Edge edge, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_EDGE;
        EdgeId edgeId = edge.getId();
        try {
            Asset savedAsset = (Asset)this.checkNotNull((Object)this.assetService.assignAssetToEdge(tenantId, assetId, edgeId));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)assetId, (HasName)savedAsset, savedAsset.getCustomerId(), actionType, user, new Object[]{assetId.toString(), edgeId.toString(), edge.getName()});
            return savedAsset;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ASSET), actionType, user, e, new Object[]{assetId.toString(), edgeId.toString()});
            throw e;
        }
    }

    public Asset unassignAssetFromEdge(TenantId tenantId, Asset asset, Edge edge, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UNASSIGNED_FROM_EDGE;
        AssetId assetId = asset.getId();
        EdgeId edgeId = edge.getId();
        try {
            Asset savedAsset = (Asset)this.checkNotNull((Object)this.assetService.unassignAssetFromEdge(tenantId, assetId, edgeId));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)assetId, (HasName)asset, asset.getCustomerId(), actionType, user, new Object[]{assetId.toString(), edgeId.toString(), edge.getName()});
            return savedAsset;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ASSET), actionType, user, e, new Object[]{assetId.toString(), edgeId.toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"assetService"})
    @Generated
    public DefaultTbAssetService(AssetService assetService) {
        this.assetService = assetService;
    }
}

