/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edqs;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ObjectType;
import org.thingsboard.server.common.data.edqs.AttributeKv;
import org.thingsboard.server.common.data.edqs.EdqsEventType;
import org.thingsboard.server.common.data.edqs.EdqsObject;
import org.thingsboard.server.common.data.edqs.Entity;
import org.thingsboard.server.common.data.edqs.LatestTsKv;
import org.thingsboard.server.common.data.edqs.fields.EntityFields;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.dao.Dao;
import org.thingsboard.server.dao.attributes.AttributesDao;
import org.thingsboard.server.dao.dictionary.KeyDictionaryDao;
import org.thingsboard.server.dao.entity.EntityDaoRegistry;
import org.thingsboard.server.dao.model.sql.AttributeKvEntity;
import org.thingsboard.server.dao.model.sql.RelationEntity;
import org.thingsboard.server.dao.model.sqlts.dictionary.KeyDictionaryEntry;
import org.thingsboard.server.dao.model.sqlts.latest.TsKvLatestEntity;
import org.thingsboard.server.dao.sql.relation.RelationRepository;
import org.thingsboard.server.dao.sqlts.latest.TsKvLatestRepository;
import org.thingsboard.server.service.edqs.DefaultEdqsService;
import org.thingsboard.server.service.edqs.EdqsSyncService;

public abstract class EdqsSyncService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdqsSyncService.class);
    @Value(value="${queue.edqs.sync.entity_batch_size:10000}")
    private int entityBatchSize;
    @Value(value="${queue.edqs.sync.ts_batch_size:10000}")
    private int tsBatchSize;
    @Autowired
    private EntityDaoRegistry entityDaoRegistry;
    @Autowired
    private AttributesDao attributesDao;
    @Autowired
    private KeyDictionaryDao keyDictionaryDao;
    @Autowired
    private RelationRepository relationRepository;
    @Autowired
    private TsKvLatestRepository tsKvLatestRepository;
    @Autowired
    @Lazy
    private DefaultEdqsService edqsService;
    private final ConcurrentHashMap<UUID, EntityIdInfo> entityInfoMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, String> keys = new ConcurrentHashMap();
    private final Map<ObjectType, AtomicInteger> counters = new ConcurrentHashMap();

    public abstract boolean isSyncNeeded();

    public void sync() {
        log.info("Synchronizing data to EDQS");
        long startTs = System.currentTimeMillis();
        this.counters.clear();
        this.syncTenantEntities();
        this.syncRelations();
        this.loadKeyDictionary();
        this.syncAttributes();
        this.syncLatestTimeseries();
        this.counters.clear();
        log.info("Finished synchronizing data to EDQS in {} ms", (Object)(System.currentTimeMillis() - startTs));
    }

    private void process(TenantId tenantId, ObjectType type, EdqsObject object) {
        AtomicInteger counter = this.counters.computeIfAbsent(type, t -> new AtomicInteger());
        if (counter.incrementAndGet() % 10000 == 0) {
            log.info("Processed {} {} objects", (Object)counter.get(), (Object)type);
        }
        this.edqsService.processEvent(tenantId, type, EdqsEventType.UPDATED, object);
    }

    private void syncTenantEntities() {
        for (ObjectType type : ObjectType.edqsTenantTypes) {
            List batch;
            log.info("Synchronizing {} entities to EDQS", (Object)type);
            long ts = System.currentTimeMillis();
            EntityType entityType = type.toEntityType();
            Dao dao = this.entityDaoRegistry.getDao(entityType);
            UUID lastId = UUID.fromString("00000000-0000-0000-0000-000000000000");
            while (!(batch = dao.findNextBatch(lastId, this.entityBatchSize)).isEmpty()) {
                for (EntityFields entityFields : batch) {
                    TenantId tenantId = TenantId.fromUUID((UUID)entityFields.getTenantId());
                    this.entityInfoMap.put(entityFields.getId(), new EntityIdInfo(entityType, tenantId));
                    this.process(tenantId, type, (EdqsObject)new Entity(entityType, entityFields));
                }
                EntityFields lastRecord = (EntityFields)batch.get(batch.size() - 1);
                lastId = lastRecord.getId();
            }
            log.info("Finished synchronizing {} entities to EDQS in {} ms", (Object)type, (Object)(System.currentTimeMillis() - ts));
        }
    }

    private void syncRelations() {
        List batch;
        log.info("Synchronizing relations to EDQS");
        long ts = System.currentTimeMillis();
        UUID lastFromEntityId = UUID.fromString("00000000-0000-0000-0000-000000000000");
        String lastFromEntityType = "";
        String lastRelationTypeGroup = "";
        String lastRelationType = "";
        UUID lastToEntityId = UUID.fromString("00000000-0000-0000-0000-000000000000");
        String lastToEntityType = "";
        while (!(batch = this.relationRepository.findNextBatch(lastFromEntityId, lastFromEntityType, lastRelationTypeGroup, lastRelationType, lastToEntityId, lastToEntityType, this.entityBatchSize)).isEmpty()) {
            this.processRelationBatch(batch);
            RelationEntity lastRecord = (RelationEntity)batch.get(batch.size() - 1);
            lastFromEntityId = lastRecord.getFromId();
            lastFromEntityType = lastRecord.getFromType();
            lastRelationTypeGroup = lastRecord.getRelationTypeGroup();
            lastRelationType = lastRecord.getRelationType();
            lastToEntityId = lastRecord.getToId();
            lastToEntityType = lastRecord.getToType();
        }
        log.info("Finished synchronizing relations to EDQS in {} ms", (Object)(System.currentTimeMillis() - ts));
    }

    private void processRelationBatch(List<RelationEntity> relations) {
        for (RelationEntity relation : relations) {
            try {
                if (!RelationTypeGroup.COMMON.name().equals(relation.getRelationTypeGroup())) continue;
                EntityIdInfo entityIdInfo = (EntityIdInfo)this.entityInfoMap.get(relation.getFromId());
                if (entityIdInfo != null) {
                    this.process(entityIdInfo.tenantId(), ObjectType.RELATION, (EdqsObject)relation.toData());
                    continue;
                }
                log.info("Relation from id not found: {} ", (Object)relation);
            }
            catch (Exception e) {
                log.error("Failed to sync relation: {}", (Object)relation, (Object)e);
            }
        }
    }

    private void loadKeyDictionary() {
        log.info("Loading key dictionary");
        long ts = System.currentTimeMillis();
        PageDataIterable keyDictionaryEntries = new PageDataIterable(arg_0 -> ((KeyDictionaryDao)this.keyDictionaryDao).findAll(arg_0), 10000);
        for (KeyDictionaryEntry keyDictionaryEntry : keyDictionaryEntries) {
            this.keys.put(keyDictionaryEntry.getKeyId(), keyDictionaryEntry.getKey());
        }
        log.info("Finished loading key dictionary in {} ms", (Object)(System.currentTimeMillis() - ts));
    }

    private void syncAttributes() {
        List batch;
        log.info("Synchronizing attributes to EDQS");
        long ts = System.currentTimeMillis();
        UUID lastEntityId = UUID.fromString("00000000-0000-0000-0000-000000000000");
        int lastAttributeType = Integer.MIN_VALUE;
        int lastAttributeKey = Integer.MIN_VALUE;
        while (!(batch = this.attributesDao.findNextBatch(lastEntityId, lastAttributeType, lastAttributeKey, this.tsBatchSize)).isEmpty()) {
            this.processAttributeBatch(batch);
            AttributeKvEntity lastRecord = (AttributeKvEntity)batch.get(batch.size() - 1);
            lastEntityId = lastRecord.getId().getEntityId();
            lastAttributeType = lastRecord.getId().getAttributeType();
            lastAttributeKey = lastRecord.getId().getAttributeKey();
        }
        log.info("Finished synchronizing attributes to EDQS in {} ms", (Object)(System.currentTimeMillis() - ts));
    }

    private void processAttributeBatch(List<AttributeKvEntity> batch) {
        for (AttributeKvEntity attribute : batch) {
            try {
                attribute.setStrKey(this.getStrKeyOrFetchFromDb(attribute.getId().getAttributeKey()));
                UUID entityId = attribute.getId().getEntityId();
                EntityIdInfo entityIdInfo = (EntityIdInfo)this.entityInfoMap.get(entityId);
                if (entityIdInfo == null) {
                    log.debug("Skipping attribute with entity UUID {} as it is not found in entityInfoMap", (Object)entityId);
                    continue;
                }
                AttributeKv attributeKv = new AttributeKv(EntityIdFactory.getByTypeAndUuid((EntityType)entityIdInfo.entityType(), (UUID)entityId), AttributeScope.valueOf((int)attribute.getId().getAttributeType()), attribute.toData(), attribute.getVersion().longValue());
                this.process(entityIdInfo.tenantId(), ObjectType.ATTRIBUTE_KV, (EdqsObject)attributeKv);
            }
            catch (Exception e) {
                log.error("Failed to sync attribute: {}", (Object)attribute, (Object)e);
            }
        }
    }

    private void syncLatestTimeseries() {
        List batch;
        log.info("Synchronizing latest timeseries to EDQS");
        long ts = System.currentTimeMillis();
        UUID lastEntityId = UUID.fromString("00000000-0000-0000-0000-000000000000");
        int lastKey = Integer.MIN_VALUE;
        while (!(batch = this.tsKvLatestRepository.findNextBatch(lastEntityId, lastKey, this.tsBatchSize)).isEmpty()) {
            this.processTsKvLatestBatch(batch);
            TsKvLatestEntity lastRecord = (TsKvLatestEntity)batch.get(batch.size() - 1);
            lastEntityId = lastRecord.getEntityId();
            lastKey = lastRecord.getKey();
        }
        log.info("Finished synchronizing latest timeseries to EDQS in {} ms", (Object)(System.currentTimeMillis() - ts));
    }

    private void processTsKvLatestBatch(List<TsKvLatestEntity> tsKvLatestEntities) {
        for (TsKvLatestEntity tsKvLatestEntity : tsKvLatestEntities) {
            try {
                String strKey = this.getStrKeyOrFetchFromDb(tsKvLatestEntity.getKey());
                if (strKey == null) {
                    log.debug("Skipping latest timeseries with key {} as it is not found in key dictionary", (Object)tsKvLatestEntity.getKey());
                    continue;
                }
                tsKvLatestEntity.setStrKey(strKey);
                UUID entityUuid = tsKvLatestEntity.getEntityId();
                EntityIdInfo entityIdInfo = (EntityIdInfo)this.entityInfoMap.get(entityUuid);
                if (entityIdInfo == null) continue;
                EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)entityIdInfo.entityType(), (UUID)entityUuid);
                LatestTsKv latestTsKv = new LatestTsKv(entityId, tsKvLatestEntity.toData(), tsKvLatestEntity.getVersion());
                this.process(entityIdInfo.tenantId(), ObjectType.LATEST_TS_KV, (EdqsObject)latestTsKv);
            }
            catch (Exception e) {
                log.error("Failed to sync latest timeseries: {}", (Object)tsKvLatestEntity, (Object)e);
            }
        }
    }

    private String getStrKeyOrFetchFromDb(int key) {
        String strKey = (String)this.keys.get(key);
        if (strKey != null) {
            return strKey;
        }
        strKey = this.keyDictionaryDao.getKey(Integer.valueOf(key));
        if (strKey != null) {
            this.keys.put(key, strKey);
        }
        return strKey;
    }
}

