/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.stats;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.dao.edge.stats.EdgeStatsCounterService;
import org.thingsboard.server.dao.edge.stats.EdgeStatsKey;
import org.thingsboard.server.dao.edge.stats.MsgCounters;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.kafka.KafkaAdmin;
import org.thingsboard.server.queue.util.TbCoreComponent;

@TbCoreComponent
@ConditionalOnProperty(prefix="edges.stats", name={"enabled"}, havingValue="true", matchIfMissing=false)
@Service
public class EdgeStatsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdgeStatsService.class);
    private final TimeseriesService tsService;
    private final EdgeStatsCounterService statsCounterService;
    private final TopicService topicService;
    private final Optional<KafkaAdmin> kafkaAdmin;
    @Value(value="${edges.stats.ttl:30}")
    private int edgesStatsTtlDays;
    @Value(value="${edges.stats.report-interval-millis:600000}")
    private long reportIntervalMillis;

    @Scheduled(fixedDelayString="${edges.stats.report-interval-millis:600000}", initialDelayString="${edges.stats.report-interval-millis:600000}")
    public void reportStats() {
        log.debug("Reporting Edge communication stats...");
        long now = System.currentTimeMillis();
        long ts = now - now % this.reportIntervalMillis;
        ConcurrentHashMap countersByEdge = this.statsCounterService.getCounterByEdge();
        Map lagByEdgeId = this.kafkaAdmin.isPresent() ? this.getEdgeLagByEdgeId((Map)countersByEdge) : Collections.emptyMap();
        HashMap<EdgeId, MsgCounters> countersByEdgeSnapshot = new HashMap<EdgeId, MsgCounters>(this.statsCounterService.getCounterByEdge());
        countersByEdgeSnapshot.forEach((edgeId, counters) -> {
            TenantId tenantId = counters.getTenantId();
            if (this.kafkaAdmin.isPresent()) {
                counters.getMsgsLag().set(lagByEdgeId.getOrDefault(edgeId, 0L));
            }
            List<BasicTsKvEntry> statsEntries = List.of(this.entry(ts, EdgeStatsKey.DOWNLINK_MSGS_ADDED.getKey(), counters.getMsgsAdded().get()), this.entry(ts, EdgeStatsKey.DOWNLINK_MSGS_PUSHED.getKey(), counters.getMsgsPushed().get()), this.entry(ts, EdgeStatsKey.DOWNLINK_MSGS_PERMANENTLY_FAILED.getKey(), counters.getMsgsPermanentlyFailed().get()), this.entry(ts, EdgeStatsKey.DOWNLINK_MSGS_TMP_FAILED.getKey(), counters.getMsgsTmpFailed().get()), this.entry(ts, EdgeStatsKey.DOWNLINK_MSGS_LAG.getKey(), counters.getMsgsLag().get()));
            log.trace("Reported Edge communication stats: {} tenantId - {}, edgeId - {}", new Object[]{statsEntries, tenantId, edgeId});
            this.saveTs(tenantId, edgeId, statsEntries);
        });
    }

    private Map<EdgeId, Long> getEdgeLagByEdgeId(Map<EdgeId, MsgCounters> countersByEdge) {
        Map<EdgeId, String> edgeToTopicMap = countersByEdge.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.topicService.buildEdgeEventNotificationsTopicPartitionInfo(((MsgCounters)e.getValue()).getTenantId(), (EdgeId)e.getKey()).getTopic()));
        Map lagByTopic = ((KafkaAdmin)this.kafkaAdmin.get()).getTotalLagForGroupsBulk(new HashSet<String>(edgeToTopicMap.values()));
        return edgeToTopicMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> lagByTopic.getOrDefault(e.getValue(), 0L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTs(TenantId tenantId, EdgeId edgeId, List<TsKvEntry> statsEntries) {
        try {
            ListenableFuture future = this.tsService.save(tenantId, (EntityId)edgeId, statsEntries, TimeUnit.DAYS.toSeconds(this.edgesStatsTtlDays));
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
        }
        finally {
            this.statsCounterService.clear(edgeId);
        }
    }

    private BasicTsKvEntry entry(long ts, String key, long value) {
        return new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry(key, Long.valueOf(value)));
    }

    @ConstructorProperties(value={"tsService", "statsCounterService", "topicService", "kafkaAdmin"})
    @Generated
    public EdgeStatsService(TimeseriesService tsService, EdgeStatsCounterService statsCounterService, TopicService topicService, Optional<KafkaAdmin> kafkaAdmin) {
        this.tsService = tsService;
        this.statsCounterService = statsCounterService;
        this.topicService = topicService;
        this.kafkaAdmin = kafkaAdmin;
    }
}

