/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.sync;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;
import org.thingsboard.server.common.data.widget.WidgetType;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.edge.EdgeEventService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;
import org.thingsboard.server.gen.edge.v1.AttributesRequestMsg;
import org.thingsboard.server.gen.edge.v1.CalculatedFieldRequestMsg;
import org.thingsboard.server.gen.edge.v1.DeviceCredentialsRequestMsg;
import org.thingsboard.server.gen.edge.v1.EntityViewsRequestMsg;
import org.thingsboard.server.gen.edge.v1.RelationRequestMsg;
import org.thingsboard.server.gen.edge.v1.RuleChainMetadataRequestMsg;
import org.thingsboard.server.gen.edge.v1.UserCredentialsRequestMsg;
import org.thingsboard.server.gen.edge.v1.WidgetBundleTypesRequestMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.rpc.sync.EdgeRequestsService;
import org.thingsboard.server.service.entitiy.entityview.TbEntityViewService;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;
import org.thingsboard.server.service.state.DefaultDeviceStateService;

@Service
@TbCoreComponent
public class DefaultEdgeRequestsService
implements EdgeRequestsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEdgeRequestsService.class);
    @Autowired
    private EdgeEventService edgeEventService;
    @Autowired
    private AttributesService attributesService;
    @Autowired
    private TimeseriesService timeseriesService;
    @Autowired
    private RelationService relationService;
    @Lazy
    @Autowired
    private TbEntityViewService entityViewService;
    @Autowired
    private WidgetsBundleService widgetsBundleService;
    @Autowired
    private WidgetTypeService widgetTypeService;
    @Autowired
    private CalculatedFieldService calculatedFieldService;
    @Autowired
    private DbCallbackExecutorService dbCallbackExecutorService;

    public ListenableFuture<Void> processRuleChainMetadataRequestMsg(TenantId tenantId, Edge edge, RuleChainMetadataRequestMsg ruleChainMetadataRequestMsg) {
        log.trace("[{}] processRuleChainMetadataRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), ruleChainMetadataRequestMsg});
        if (ruleChainMetadataRequestMsg.getRuleChainIdMSB() == 0L || ruleChainMetadataRequestMsg.getRuleChainIdLSB() == 0L) {
            return Futures.immediateFuture(null);
        }
        RuleChainId ruleChainId = new RuleChainId(new UUID(ruleChainMetadataRequestMsg.getRuleChainIdMSB(), ruleChainMetadataRequestMsg.getRuleChainIdLSB()));
        return this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.RULE_CHAIN_METADATA, EdgeEventActionType.ADDED, (EntityId)ruleChainId, null);
    }

    public ListenableFuture<Void> processAttributesRequestMsg(TenantId tenantId, Edge edge, AttributesRequestMsg attributesRequestMsg) {
        log.trace("[{}] processAttributesRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), attributesRequestMsg});
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)attributesRequestMsg.getEntityType()), (UUID)new UUID(attributesRequestMsg.getEntityIdMSB(), attributesRequestMsg.getEntityIdLSB()));
        EdgeEventType entityType = EdgeUtils.getEdgeEventTypeByEntityType((EntityType)entityId.getEntityType());
        if (entityType == null) {
            log.warn("[{}] Type doesn't supported {}", (Object)tenantId, (Object)entityId.getEntityType());
            return Futures.immediateFuture(null);
        }
        String scope = attributesRequestMsg.getScope();
        ListenableFuture findAttrFuture = this.attributesService.findAll(tenantId, entityId, AttributeScope.valueOf((String)scope));
        return Futures.transformAsync((ListenableFuture)findAttrFuture, ssAttributes -> this.processEntityAttributesAndAddToEdgeQueue(tenantId, entityId, edge, entityType, scope, ssAttributes, attributesRequestMsg), (Executor)this.dbCallbackExecutorService);
    }

    private ListenableFuture<Void> processEntityAttributesAndAddToEdgeQueue(TenantId tenantId, EntityId entityId, Edge edge, EdgeEventType entityType, String scope, List<AttributeKvEntry> ssAttributes, AttributesRequestMsg attributesRequestMsg) {
        HashMap<String, Object> entityData = null;
        ObjectNode attributes = null;
        try {
            ListenableFuture future;
            if (ssAttributes == null || ssAttributes.isEmpty()) {
                log.trace("[{}][{}] No attributes found for entity {} [{}]", new Object[]{tenantId, edge.getName(), entityId.getEntityType(), entityId.getId()});
                future = Futures.immediateFuture(null);
            } else {
                entityData = new HashMap<String, Object>();
                attributes = JacksonUtil.newObjectNode();
                for (AttributeKvEntry attr : ssAttributes) {
                    if (DefaultDeviceStateService.ACTIVITY_KEYS_WITHOUT_INACTIVITY_TIMEOUT.contains(attr.getKey())) continue;
                    if (attr.getDataType() == DataType.BOOLEAN && attr.getBooleanValue().isPresent()) {
                        attributes.put(attr.getKey(), (Boolean)attr.getBooleanValue().get());
                        continue;
                    }
                    if (attr.getDataType() == DataType.DOUBLE && attr.getDoubleValue().isPresent()) {
                        attributes.put(attr.getKey(), (Double)attr.getDoubleValue().get());
                        continue;
                    }
                    if (attr.getDataType() == DataType.LONG && attr.getLongValue().isPresent()) {
                        attributes.put(attr.getKey(), (Long)attr.getLongValue().get());
                        continue;
                    }
                    if (attr.getDataType() == DataType.JSON && attr.getJsonValue().isPresent()) {
                        attributes.set(attr.getKey(), JacksonUtil.toJsonNode((String)((String)attr.getJsonValue().get())));
                        continue;
                    }
                    attributes.put(attr.getKey(), attr.getValueAsString());
                }
                if (!attributes.isEmpty()) {
                    entityData.put("kv", attributes);
                    entityData.put("scope", scope);
                    JsonNode body = JacksonUtil.valueToTree(entityData);
                    log.debug("[{}] Sending attributes data msg, entityId [{}], attributes [{}]", new Object[]{tenantId, entityId, body});
                    future = this.saveEdgeEvent(tenantId, edge.getId(), entityType, EdgeEventActionType.ATTRIBUTES_UPDATED, entityId, body);
                } else {
                    future = Futures.immediateFuture(null);
                }
            }
            return Futures.transformAsync((ListenableFuture)future, v -> this.processLatestTimeseriesAndAddToEdgeQueue(tenantId, entityId, edge, entityType), (Executor)this.dbCallbackExecutorService);
        }
        catch (Exception e) {
            String errMsg = String.format("[%s][%s] Failed to save attribute updates to the edge [%s], scope = %s, entityData = %s, attributes = %s", tenantId, edge.getId(), attributesRequestMsg, scope, entityData, attributes);
            log.error(errMsg, (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
        }
    }

    private ListenableFuture<Void> processLatestTimeseriesAndAddToEdgeQueue(TenantId tenantId, EntityId entityId, Edge edge, EdgeEventType entityType) {
        ListenableFuture getAllLatestFuture = this.timeseriesService.findAllLatest(tenantId, entityId);
        return Futures.transformAsync((ListenableFuture)getAllLatestFuture, tsKvEntries -> {
            if (tsKvEntries == null || tsKvEntries.isEmpty()) {
                log.trace("[{}][{}] No timeseries found for entity {} [{}]", new Object[]{tenantId, edge.getName(), entityId.getEntityType(), entityId.getId()});
                return Futures.immediateFuture(null);
            }
            HashMap<Long, Map> tsData = new HashMap<Long, Map>();
            for (TsKvEntry tsKvEntry : tsKvEntries) {
                if (DefaultDeviceStateService.ACTIVITY_KEYS_WITH_INACTIVITY_TIMEOUT.contains(tsKvEntry.getKey())) continue;
                tsData.computeIfAbsent(tsKvEntry.getTs(), k -> new HashMap()).put(tsKvEntry.getKey(), tsKvEntry.getValue());
            }
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
            for (Map.Entry entry : tsData.entrySet()) {
                HashMap<String, Object> entityBody = new HashMap<String, Object>();
                entityBody.put("data", entry.getValue());
                entityBody.put("ts", entry.getKey());
                futures.add(this.saveEdgeEvent(tenantId, edge.getId(), entityType, EdgeEventActionType.TIMESERIES_UPDATED, entityId, JacksonUtil.valueToTree(entityBody)));
            }
            return Futures.transform((ListenableFuture)Futures.allAsList(futures), v -> null, (Executor)this.dbCallbackExecutorService);
        }, (Executor)this.dbCallbackExecutorService);
    }

    public ListenableFuture<Void> processRelationRequestMsg(TenantId tenantId, Edge edge, RelationRequestMsg relationRequestMsg) {
        log.trace("[{}] processRelationRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), relationRequestMsg});
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)relationRequestMsg.getEntityType()), (UUID)new UUID(relationRequestMsg.getEntityIdMSB(), relationRequestMsg.getEntityIdLSB()));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        futures.add(this.findRelationByQuery(tenantId, edge, entityId, EntitySearchDirection.FROM));
        futures.add(this.findRelationByQuery(tenantId, edge, entityId, EntitySearchDirection.TO));
        ListenableFuture relationsListFuture = Futures.allAsList(futures);
        SettableFuture futureToSet = SettableFuture.create();
        Futures.addCallback((ListenableFuture)relationsListFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.dbCallbackExecutorService);
        return futureToSet;
    }

    public ListenableFuture<Void> processCalculatedFieldRequestMsg(TenantId tenantId, Edge edge, CalculatedFieldRequestMsg calculatedFieldRequestMsg) {
        log.trace("[{}] processCalculatedFieldRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), calculatedFieldRequestMsg});
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)calculatedFieldRequestMsg.getEntityType()), (UUID)new UUID(calculatedFieldRequestMsg.getEntityIdMSB(), calculatedFieldRequestMsg.getEntityIdLSB()));
        log.trace("[{}] processCalculatedField [{}][{}] for entity [{}][{}]", new Object[]{tenantId, edge.getName(), calculatedFieldRequestMsg, entityId.getEntityType(), entityId.getId()});
        return this.saveCalculatedFieldsToEdge(tenantId, edge.getId(), entityId);
    }

    private ListenableFuture<Void> saveCalculatedFieldsToEdge(TenantId tenantId, EdgeId edgeId, EntityId entityId) {
        return Futures.transformAsync((ListenableFuture)this.dbCallbackExecutorService.submit(() -> this.calculatedFieldService.findCalculatedFieldsByEntityId(tenantId, entityId)), calculatedFields -> {
            log.trace("[{}][{}][{}][{}] calculatedField(s) are going to be pushed to edge.", new Object[]{tenantId, edgeId, entityId, calculatedFields.size()});
            List<ListenableFuture> futures = calculatedFields.stream().map(calculatedField -> {
                try {
                    return this.saveEdgeEvent(tenantId, edgeId, EdgeEventType.CALCULATED_FIELD, EdgeEventActionType.ADDED, (EntityId)calculatedField.getId(), JacksonUtil.valueToTree((Object)calculatedField));
                }
                catch (Exception e) {
                    log.error("[{}][{}] Exception during loading calculatedField [{}] to edge on sync!", new Object[]{tenantId, edgeId, calculatedField, e});
                    return Futures.immediateFailedFuture((Throwable)e);
                }
            }).toList();
            return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
        }, (Executor)this.dbCallbackExecutorService);
    }

    private ListenableFuture<List<EntityRelation>> findRelationByQuery(TenantId tenantId, Edge edge, EntityId entityId, EntitySearchDirection direction) {
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters(entityId, direction, 1, false));
        return this.relationService.findByQuery(tenantId, query);
    }

    public ListenableFuture<Void> processDeviceCredentialsRequestMsg(TenantId tenantId, Edge edge, DeviceCredentialsRequestMsg deviceCredentialsRequestMsg) {
        log.trace("[{}] processDeviceCredentialsRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), deviceCredentialsRequestMsg});
        if (deviceCredentialsRequestMsg.getDeviceIdMSB() == 0L || deviceCredentialsRequestMsg.getDeviceIdLSB() == 0L) {
            return Futures.immediateFuture(null);
        }
        DeviceId deviceId = new DeviceId(new UUID(deviceCredentialsRequestMsg.getDeviceIdMSB(), deviceCredentialsRequestMsg.getDeviceIdLSB()));
        return this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.DEVICE, EdgeEventActionType.CREDENTIALS_UPDATED, (EntityId)deviceId, null);
    }

    public ListenableFuture<Void> processUserCredentialsRequestMsg(TenantId tenantId, Edge edge, UserCredentialsRequestMsg userCredentialsRequestMsg) {
        log.trace("[{}] processUserCredentialsRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), userCredentialsRequestMsg});
        if (userCredentialsRequestMsg.getUserIdMSB() == 0L || userCredentialsRequestMsg.getUserIdLSB() == 0L) {
            return Futures.immediateFuture(null);
        }
        UserId userId = new UserId(new UUID(userCredentialsRequestMsg.getUserIdMSB(), userCredentialsRequestMsg.getUserIdLSB()));
        return this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.USER, EdgeEventActionType.CREDENTIALS_UPDATED, (EntityId)userId, null);
    }

    public ListenableFuture<Void> processWidgetBundleTypesRequestMsg(TenantId tenantId, Edge edge, WidgetBundleTypesRequestMsg widgetBundleTypesRequestMsg) {
        WidgetsBundleId widgetsBundleId;
        WidgetsBundle widgetsBundleById;
        log.trace("[{}] processWidgetBundleTypesRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), widgetBundleTypesRequestMsg});
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        if (widgetBundleTypesRequestMsg.getWidgetBundleIdMSB() != 0L && widgetBundleTypesRequestMsg.getWidgetBundleIdLSB() != 0L && (widgetsBundleById = this.widgetsBundleService.findWidgetsBundleById(tenantId, widgetsBundleId = new WidgetsBundleId(new UUID(widgetBundleTypesRequestMsg.getWidgetBundleIdMSB(), widgetBundleTypesRequestMsg.getWidgetBundleIdLSB())))) != null) {
            List widgetTypesToPush = this.widgetTypeService.findWidgetTypesByWidgetsBundleId(widgetsBundleById.getTenantId(), widgetsBundleId);
            for (WidgetType widgetType : widgetTypesToPush) {
                futures.add(this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.WIDGET_TYPE, EdgeEventActionType.ADDED, (EntityId)widgetType.getId(), null));
            }
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)this.dbCallbackExecutorService);
    }

    public ListenableFuture<Void> processEntityViewsRequestMsg(TenantId tenantId, Edge edge, EntityViewsRequestMsg entityViewsRequestMsg) {
        log.trace("[{}] processEntityViewsRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), entityViewsRequestMsg});
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)entityViewsRequestMsg.getEntityType()), (UUID)new UUID(entityViewsRequestMsg.getEntityIdMSB(), entityViewsRequestMsg.getEntityIdLSB()));
        SettableFuture futureToSet = SettableFuture.create();
        Futures.addCallback((ListenableFuture)this.entityViewService.findEntityViewsByTenantIdAndEntityIdAsync(tenantId, entityId), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.dbCallbackExecutorService);
        return futureToSet;
    }

    private ListenableFuture<Void> saveEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body) {
        log.trace("Pushing edge event to edge queue. tenantId [{}], edgeId [{}], type [{}], action[{}], entityId [{}], body [{}]", new Object[]{tenantId, edgeId, type, action, entityId, body});
        EdgeEvent edgeEvent = EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edgeId, (EdgeEventType)type, (EdgeEventActionType)action, (EntityId)entityId, (JsonNode)body);
        return this.edgeEventService.saveAsync(edgeEvent);
    }
}

