/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.resource;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.ResourceUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseResourceProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseResourceProcessor.class);
    @Autowired
    private DataValidator<TbResource> resourceValidator;

    protected boolean saveOrUpdateTbResource(TenantId tenantId, TbResourceId tbResourceId, ResourceUpdateMsg resourceUpdateMsg) {
        boolean resourceKeyUpdated = false;
        try {
            TbResource resource = (TbResource)JacksonUtil.fromString((String)resourceUpdateMsg.getEntity(), TbResource.class, (boolean)true);
            if (resource == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] resourceUpdateMsg {" + String.valueOf(resourceUpdateMsg) + " } cannot be converted to resource");
            }
            boolean created = false;
            TbResource resourceById = this.edgeCtx.getResourceService().findResourceById(tenantId, tbResourceId);
            if (resourceById == null) {
                resource.setCreatedTime(Uuids.unixTimestamp((UUID)tbResourceId.getId()));
                created = true;
                resource.setId(null);
            } else {
                resource.setId((UUIDBased)tbResourceId);
            }
            Object resourceKey = resource.getResourceKey();
            ResourceType resourceType = resource.getResourceType();
            if (!created && !resourceType.isUpdatable()) {
                resource.setData(null);
            }
            PageDataIterable resourcesIterable = new PageDataIterable(link -> this.edgeCtx.getResourceService().findTenantResourcesByResourceTypeAndPageLink(tenantId, resourceType, link), 1024);
            for (TbResource tbResource : resourcesIterable) {
                if (!tbResource.getResourceKey().equals(resourceKey) || tbResourceId.equals((Object)tbResource.getId())) continue;
                resourceKey = StringUtils.randomAlphabetic((int)15) + "_" + (String)resourceKey;
                log.warn("[{}] Resource with resource type {} and key {} already exists. Renaming resource key to {}", new Object[]{tenantId, resourceType, resource.getResourceKey(), resourceKey});
                resourceKeyUpdated = true;
            }
            resource.setResourceKey((String)resourceKey);
            this.resourceValidator.validate((BaseData)resource, TbResourceInfo::getTenantId);
            if (created) {
                resource.setId((UUIDBased)tbResourceId);
            }
            this.edgeCtx.getResourceService().saveResource(resource, false);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process resource update msg [{}]", new Object[]{tenantId, resourceUpdateMsg, e});
            throw e;
        }
        return resourceKeyUpdated;
    }
}

