/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.ota;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.OtaPackageUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.ota.OtaPackageEdgeProcessor;

@Component
@TbCoreComponent
public class OtaPackageEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OtaPackageEdgeProcessor.class);

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        OtaPackageId otaPackageId = new OtaPackageId(edgeEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                OtaPackage otaPackage = this.edgeCtx.getOtaPackageService().findOtaPackageById(edgeEvent.getTenantId(), otaPackageId);
                if (otaPackage == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                OtaPackageUpdateMsg otaPackageUpdateMsg = EdgeMsgConstructorUtils.constructOtaPackageUpdatedMsg((UpdateMsgType)msgType, (OtaPackage)otaPackage);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addOtaPackageUpdateMsg(otaPackageUpdateMsg).build();
            }
            case 3: {
                OtaPackageUpdateMsg otaPackageUpdateMsg = EdgeMsgConstructorUtils.constructOtaPackageDeleteMsg((OtaPackageId)otaPackageId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addOtaPackageUpdateMsg(otaPackageUpdateMsg).build();
            }
        }
        return null;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.OTA_PACKAGE;
    }
}

