/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.entityview;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.EntityViewUpdateMsg;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.entityview.BaseEntityViewProcessor;
import org.thingsboard.server.service.edge.rpc.processor.entityview.EntityViewEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.entityview.EntityViewProcessor;

@Component
@TbCoreComponent
public class EntityViewEdgeProcessor
extends BaseEntityViewProcessor
implements EntityViewProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityViewEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processEntityViewMsgFromEdge(TenantId tenantId, Edge edge, EntityViewUpdateMsg entityViewUpdateMsg) {
        log.trace("[{}] executing processEntityViewMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, entityViewUpdateMsg, edge.getId()});
        EntityViewId entityViewId = new EntityViewId(new UUID(entityViewUpdateMsg.getIdMSB(), entityViewUpdateMsg.getIdLSB()));
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[entityViewUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    this.saveOrUpdateEntityView(tenantId, entityViewId, entityViewUpdateMsg, edge);
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
                case 3: {
                    EntityView entityViewToDelete = this.edgeCtx.getEntityViewService().findEntityViewById(tenantId, entityViewId);
                    if (entityViewToDelete != null) {
                        this.edgeCtx.getEntityViewService().unassignEntityViewFromEdge(tenantId, entityViewId, edge.getId());
                    }
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
            }
            ListenableFuture listenableFuture = this.handleUnsupportedMsgType(entityViewUpdateMsg.getMsgType());
            return listenableFuture;
        }
        catch (DataValidationException e) {
            if (e.getMessage().contains("limit reached")) {
                log.warn("[{}] Number of allowed entity views violated {}", new Object[]{tenantId, entityViewUpdateMsg, e});
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    private void saveOrUpdateEntityView(TenantId tenantId, EntityViewId entityViewId, EntityViewUpdateMsg entityViewUpdateMsg, Edge edge) {
        Boolean assetNameUpdated;
        Pair resultPair = super.saveOrUpdateEntityView(tenantId, entityViewId, entityViewUpdateMsg);
        Boolean created = (Boolean)resultPair.getFirst();
        if (created.booleanValue()) {
            this.createRelationFromEdge(tenantId, edge.getId(), (EntityId)entityViewId);
            this.pushEntityViewCreatedEventToRuleEngine(tenantId, edge, entityViewId);
            this.edgeCtx.getEntityViewService().assignEntityViewToEdge(tenantId, entityViewId, edge.getId());
        }
        if ((assetNameUpdated = (Boolean)resultPair.getSecond()).booleanValue()) {
            this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.ENTITY_VIEW, EdgeEventActionType.UPDATED, (EntityId)entityViewId, null);
        }
    }

    private void pushEntityViewCreatedEventToRuleEngine(TenantId tenantId, Edge edge, EntityViewId entityViewId) {
        try {
            EntityView entityView = this.edgeCtx.getEntityViewService().findEntityViewById(tenantId, entityViewId);
            String entityViewAsString = JacksonUtil.toString((Object)entityView);
            TbMsgMetaData msgMetaData = this.getEdgeActionTbMsgMetaData(edge, entityView.getCustomerId());
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)entityViewId, entityView.getCustomerId(), TbMsgType.ENTITY_CREATED, entityViewAsString, msgMetaData);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push entity view action to rule engine: {}", new Object[]{tenantId, entityViewId, TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        EntityViewId entityViewId = new EntityViewId(edgeEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                EntityView entityView = this.edgeCtx.getEntityViewService().findEntityViewById(edgeEvent.getTenantId(), entityViewId);
                if (entityView == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                EntityViewUpdateMsg entityViewUpdateMsg = EdgeMsgConstructorUtils.constructEntityViewUpdatedMsg((UpdateMsgType)msgType, (EntityView)entityView);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addEntityViewUpdateMsg(entityViewUpdateMsg).build();
            }
            case 6: 
            case 7: {
                EntityViewUpdateMsg entityViewUpdateMsg = EdgeMsgConstructorUtils.constructEntityViewDeleteMsg((EntityViewId)entityViewId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addEntityViewUpdateMsg(entityViewUpdateMsg).build();
            }
        }
        return null;
    }

    protected void setCustomerId(TenantId tenantId, CustomerId customerId, EntityView entityView, EntityViewUpdateMsg entityViewUpdateMsg) {
        CustomerId customerUUID = entityView.getCustomerId() != null ? entityView.getCustomerId() : customerId;
        entityView.setCustomerId(customerUUID);
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.ENTITY_VIEW;
    }
}

