/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.cf;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.CalculatedFieldUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.cf.BaseCalculatedFieldProcessor;
import org.thingsboard.server.service.edge.rpc.processor.cf.CalculatedFieldEdgeProcessor;
import org.thingsboard.server.service.edge.rpc.processor.cf.CalculatedFieldProcessor;

@Component
@TbCoreComponent
public class CalculatedFieldEdgeProcessor
extends BaseCalculatedFieldProcessor
implements CalculatedFieldProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> processCalculatedFieldMsgFromEdge(TenantId tenantId, Edge edge, CalculatedFieldUpdateMsg calculatedFieldUpdateMsg) {
        CalculatedFieldId calculatedFieldId = new CalculatedFieldId(new UUID(calculatedFieldUpdateMsg.getIdMSB(), calculatedFieldUpdateMsg.getIdLSB()));
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            switch (1.$SwitchMap$org$thingsboard$server$gen$edge$v1$UpdateMsgType[calculatedFieldUpdateMsg.getMsgType().ordinal()]) {
                case 1: 
                case 2: {
                    this.processCalculatedField(tenantId, calculatedFieldId, calculatedFieldUpdateMsg, edge);
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
                case 3: {
                    CalculatedField calculatedField = this.edgeCtx.getCalculatedFieldService().findById(tenantId, calculatedFieldId);
                    if (calculatedField != null) {
                        this.edgeCtx.getCalculatedFieldService().deleteCalculatedField(tenantId, calculatedFieldId);
                    }
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
            }
            ListenableFuture listenableFuture = this.handleUnsupportedMsgType(calculatedFieldUpdateMsg.getMsgType());
            return listenableFuture;
        }
        catch (DataValidationException e) {
            if (e.getMessage().contains("limit reached")) {
                log.warn("[{}] Number of allowed calculatedField violated {}", new Object[]{tenantId, calculatedFieldUpdateMsg, e});
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        CalculatedFieldId calculatedFieldId = new CalculatedFieldId(edgeEvent.getEntityId());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[edgeEvent.getAction().ordinal()]) {
            case 1: 
            case 2: {
                CalculatedField calculatedField = this.edgeCtx.getCalculatedFieldService().findById(edgeEvent.getTenantId(), calculatedFieldId);
                if (calculatedField == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                CalculatedFieldUpdateMsg calculatedFieldUpdateMsg = EdgeMsgConstructorUtils.constructCalculatedFieldUpdatedMsg((UpdateMsgType)msgType, (CalculatedField)calculatedField);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addCalculatedFieldUpdateMsg(calculatedFieldUpdateMsg).build();
            }
            case 3: {
                CalculatedFieldUpdateMsg calculatedFieldUpdateMsg = EdgeMsgConstructorUtils.constructCalculatedFieldDeleteMsg((CalculatedFieldId)calculatedFieldId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addCalculatedFieldUpdateMsg(calculatedFieldUpdateMsg).build();
            }
        }
        return null;
    }

    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.CALCULATED_FIELD;
    }

    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        EdgeEventType type = EdgeEventType.valueOf((String)edgeNotificationMsg.getType());
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction());
        EntityId entityId = EntityIdFactory.getByEdgeEventTypeAndUuid((EdgeEventType)type, (UUID)new UUID(edgeNotificationMsg.getEntityIdMSB(), edgeNotificationMsg.getEntityIdLSB()));
        EdgeId originatorEdgeId = this.safeGetEdgeId(edgeNotificationMsg.getOriginatorEdgeIdMSB(), edgeNotificationMsg.getOriginatorEdgeIdLSB());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$edge$EdgeEventActionType[actionType.ordinal()]) {
            case 1: 
            case 2: {
                EntityId calculatedFieldOwnerId = (EntityId)JacksonUtil.fromString((String)edgeNotificationMsg.getBody(), EntityId.class);
                if (calculatedFieldOwnerId != null && (EntityType.DEVICE.equals((Object)calculatedFieldOwnerId.getEntityType()) || EntityType.ASSET.equals((Object)calculatedFieldOwnerId.getEntityType()))) {
                    JsonNode body = JacksonUtil.toJsonNode((String)edgeNotificationMsg.getBody());
                    EdgeId edgeId = this.safeGetEdgeId(edgeNotificationMsg.getEdgeIdMSB(), edgeNotificationMsg.getEdgeIdLSB());
                    return edgeId != null ? this.saveEdgeEvent(tenantId, edgeId, type, actionType, entityId, body) : this.processNotificationToRelatedEdges(tenantId, calculatedFieldOwnerId, entityId, type, actionType, originatorEdgeId);
                }
                return this.processActionForAllEdges(tenantId, type, actionType, entityId, null, originatorEdgeId);
            }
        }
        return super.processEntityNotification(tenantId, edgeNotificationMsg);
    }

    private void processCalculatedField(TenantId tenantId, CalculatedFieldId calculatedFieldId, CalculatedFieldUpdateMsg calculatedFieldUpdateMsg, Edge edge) {
        Boolean nameWasUpdated;
        Pair resultPair = super.saveOrUpdateCalculatedField(tenantId, calculatedFieldId, calculatedFieldUpdateMsg);
        Boolean wasCreated = (Boolean)resultPair.getFirst();
        if (wasCreated.booleanValue()) {
            this.pushCalculatedFieldCreatedEventToRuleEngine(tenantId, edge, calculatedFieldId);
        }
        if ((nameWasUpdated = (Boolean)resultPair.getSecond()).booleanValue()) {
            this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.CALCULATED_FIELD, EdgeEventActionType.UPDATED, (EntityId)calculatedFieldId, null);
        }
    }

    private void pushCalculatedFieldCreatedEventToRuleEngine(TenantId tenantId, Edge edge, CalculatedFieldId calculatedFieldId) {
        try {
            CalculatedField calculatedField = this.edgeCtx.getCalculatedFieldService().findById(tenantId, calculatedFieldId);
            String calculatedFieldAsString = JacksonUtil.toString((Object)calculatedField);
            TbMsgMetaData msgMetaData = this.getEdgeActionTbMsgMetaData(edge, edge.getCustomerId());
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)calculatedFieldId, edge.getCustomerId(), TbMsgType.ENTITY_CREATED, calculatedFieldAsString, msgMetaData);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push calculatedField action to rule engine: {}", new Object[]{tenantId, calculatedFieldId, TbMsgType.ENTITY_CREATED.name(), e});
        }
    }
}

