/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class RuleChainsEdgeEventFetcher
extends BasePageableEdgeEventFetcher<RuleChain> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleChainsEdgeEventFetcher.class);
    private final RuleChainService ruleChainService;

    PageData<RuleChain> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        return this.ruleChainService.findRuleChainsByTenantIdAndEdgeId(tenantId, edge.getId(), pageLink);
    }

    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, RuleChain ruleChain) {
        ObjectNode isRootBody = JacksonUtil.newObjectNode();
        boolean isRoot = false;
        try {
            isRoot = ruleChain.getId().equals((Object)edge.getRootRuleChainId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        isRootBody.put("isRoot", isRoot);
        return EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.RULE_CHAIN, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)ruleChain.getId(), (JsonNode)isRootBody);
    }

    @ConstructorProperties(value={"ruleChainService"})
    @Generated
    public RuleChainsEdgeEventFetcher(RuleChainService ruleChainService) {
        this.ruleChainService = ruleChainService;
    }
}

