/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class DashboardsEdgeEventFetcher
extends BasePageableEdgeEventFetcher<DashboardInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardsEdgeEventFetcher.class);
    private final DashboardService dashboardService;

    PageData<DashboardInfo> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        return this.dashboardService.findDashboardsByTenantIdAndEdgeId(tenantId, edge.getId(), pageLink);
    }

    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, DashboardInfo dashboardInfo) {
        return EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.DASHBOARD, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)dashboardInfo.getId(), null);
    }

    @ConstructorProperties(value={"dashboardService"})
    @Generated
    public DashboardsEdgeEventFetcher(DashboardService dashboardService) {
        this.dashboardService = dashboardService;
    }
}

