/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;

public abstract class BasePageableEdgeEventFetcher<T>
implements EdgeEventFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasePageableEdgeEventFetcher.class);

    public PageLink getPageLink(int pageSize) {
        return new PageLink(pageSize);
    }

    public PageData<EdgeEvent> fetchEdgeEvents(TenantId tenantId, Edge edge, PageLink pageLink) {
        log.trace("[{}][{}] start fetching edge events [{}], pageLink {}", new Object[]{this.getClass().getSimpleName(), tenantId, edge.getId(), pageLink});
        PageData entities = this.fetchEntities(tenantId, edge, pageLink);
        ArrayList<EdgeEvent> result = new ArrayList<EdgeEvent>();
        if (!entities.getData().isEmpty()) {
            for (Object entity : entities.getData()) {
                result.add(this.constructEdgeEvent(tenantId, edge, entity));
            }
        }
        return new PageData(result, entities.getTotalPages(), entities.getTotalElements(), entities.hasNext());
    }

    abstract PageData<T> fetchEntities(TenantId var1, Edge var2, PageLink var3);

    abstract EdgeEvent constructEdgeEvent(TenantId var1, Edge var2, T var3);
}

