/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class AssetsEdgeEventFetcher
extends BasePageableEdgeEventFetcher<Asset> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetsEdgeEventFetcher.class);
    private final AssetService assetService;

    PageData<Asset> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        return this.assetService.findAssetsByTenantIdAndEdgeId(tenantId, edge.getId(), pageLink);
    }

    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, Asset asset) {
        return EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.ASSET, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)asset.getId(), null);
    }

    @ConstructorProperties(value={"assetService"})
    @Generated
    public AssetsEdgeEventFetcher(AssetService assetService) {
        this.assetService = assetService;
    }
}

