/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class AssetProfilesEdgeEventFetcher
extends BasePageableEdgeEventFetcher<AssetProfile> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetProfilesEdgeEventFetcher.class);
    private final AssetProfileService assetProfileService;

    PageData<AssetProfile> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        return this.assetProfileService.findAssetProfiles(tenantId, pageLink);
    }

    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, AssetProfile assetProfile) {
        return EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.ASSET_PROFILE, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)assetProfile.getId(), null);
    }

    @ConstructorProperties(value={"assetProfileService"})
    @Generated
    public AssetProfilesEdgeEventFetcher(AssetProfileService assetProfileService) {
        this.assetProfileService = assetProfileService;
    }
}

