/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.GeneratedMessageV3;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.edge.BaseEdgeEventService;
import org.thingsboard.server.dao.edge.stats.EdgeStatsCounterService;
import org.thingsboard.server.dao.edge.stats.EdgeStatsKey;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;

@Service
@ConditionalOnExpression(value="'${queue.type:null}'=='kafka'")
public class KafkaEdgeEventService
extends BaseEdgeEventService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaEdgeEventService.class);
    private final TopicService topicService;
    private final TbQueueProducerProvider producerProvider;
    private final Optional<EdgeStatsCounterService> statsCounterService;

    public ListenableFuture<Void> saveAsync(EdgeEvent edgeEvent) {
        this.validateEdgeEvent(edgeEvent);
        TopicPartitionInfo tpi = this.topicService.getEdgeEventNotificationsTopic(edgeEvent.getTenantId(), edgeEvent.getEdgeId());
        TransportProtos.ToEdgeEventNotificationMsg msg = TransportProtos.ToEdgeEventNotificationMsg.newBuilder().setEdgeEventMsg(ProtoUtils.toProto((EdgeEvent)edgeEvent)).build();
        this.producerProvider.getTbEdgeEventsMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)msg), null);
        this.statsCounterService.ifPresent(statsCounterService -> statsCounterService.recordEvent(EdgeStatsKey.DOWNLINK_MSGS_ADDED, edgeEvent.getTenantId(), edgeEvent.getEdgeId(), 1L));
        return Futures.immediateFuture(null);
    }

    @ConstructorProperties(value={"topicService", "producerProvider", "statsCounterService"})
    @Generated
    public KafkaEdgeEventService(TopicService topicService, TbQueueProducerProvider producerProvider, Optional<EdgeStatsCounterService> statsCounterService) {
        this.topicService = topicService;
        this.producerProvider = producerProvider;
        this.statsCounterService = statsCounterService;
    }
}

