/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.dao.edge.RelatedEdgesService;
import org.thingsboard.server.dao.eventsourcing.ActionEntityEvent;
import org.thingsboard.server.dao.eventsourcing.DeleteEntityEvent;
import org.thingsboard.server.service.edge.RelatedEdgesSourcingListener;

@Component
public class RelatedEdgesSourcingListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RelatedEdgesSourcingListener.class);
    private final RelatedEdgesService relatedEdgesService;
    private ExecutorService executorService;

    @PostConstruct
    public void init() {
        log.debug("RelatedEdgesSourcingListener initiated");
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"related-edges-listener"));
    }

    @PreDestroy
    public void destroy() {
        log.debug("RelatedEdgesSourcingListener destroy");
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(ActionEntityEvent<?> event) {
        this.executorService.submit(() -> {
            log.trace("[{}] ActionEntityEvent called: {}", (Object)event.getTenantId(), (Object)event);
            try {
                switch (1.$SwitchMap$org$thingsboard$server$common$data$audit$ActionType[event.getActionType().ordinal()]) {
                    case 1: 
                    case 2: {
                        this.relatedEdgesService.publishRelatedEdgeIdsEvictEvent(event.getTenantId(), event.getEntityId());
                    }
                }
            }
            catch (Exception e) {
                log.error("[{}] failed to process ActionEntityEvent: {}", new Object[]{event.getTenantId(), event, e});
            }
        });
    }

    @TransactionalEventListener(fallbackExecution=true, condition="#event.entityId.getEntityType() != T(org.thingsboard.server.common.data.EntityType).AI_MODEL")
    public void handleEvent(DeleteEntityEvent<?> event) {
        this.executorService.submit(() -> {
            log.trace("[{}] DeleteEntityEvent called: {}", (Object)event.getTenantId(), (Object)event);
            try {
                this.relatedEdgesService.publishRelatedEdgeIdsEvictEvent(event.getTenantId(), event.getEntityId());
            }
            catch (Exception e) {
                log.error("[{}] failed to process DeleteEntityEvent: {}", new Object[]{event.getTenantId(), event, e});
            }
        });
    }

    @ConstructorProperties(value={"relatedEdgesService"})
    @Generated
    public RelatedEdgesSourcingListener(RelatedEdgesService relatedEdgesService) {
        this.relatedEdgesService = relatedEdgesService;
    }
}

