/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.alarm.EntityAlarm;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.domain.Domain;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.dao.edge.EdgeSynchronizationManager;
import org.thingsboard.server.dao.eventsourcing.ActionEntityEvent;
import org.thingsboard.server.dao.eventsourcing.DeleteEntityEvent;
import org.thingsboard.server.dao.eventsourcing.RelationActionEvent;
import org.thingsboard.server.dao.eventsourcing.SaveEntityEvent;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.service.edge.EdgeEventSourcingListener;

@Component
public class EdgeEventSourcingListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdgeEventSourcingListener.class);
    private final TbClusterService tbClusterService;
    private final TenantService tenantService;
    private final EdgeSynchronizationManager edgeSynchronizationManager;

    @PostConstruct
    public void init() {
        log.debug("EdgeEventSourcingListener initiated");
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(SaveEntityEvent<?> event) {
        if (Boolean.FALSE.equals(event.getBroadcastEvent())) {
            log.trace("Ignoring event {}", event);
            return;
        }
        try {
            if (!this.isValidSaveEntityEventForEdgeProcessing(event)) {
                return;
            }
            log.trace("[{}] SaveEntityEvent called: {}", (Object)event.getTenantId(), event);
            boolean isCreated = Boolean.TRUE.equals(event.getCreated());
            String body = this.getBodyMsgForEntityEvent(event.getEntity());
            EdgeEventType type = this.getEdgeEventTypeForEntityEvent(event.getEntity());
            EdgeEventActionType action = this.getActionForEntityEvent(event.getEntity(), isCreated);
            this.tbClusterService.sendNotificationMsgToEdge(event.getTenantId(), null, event.getEntityId(), body, type, action, (EdgeId)this.edgeSynchronizationManager.getEdgeId().get());
        }
        catch (Exception e) {
            log.error("[{}] failed to process SaveEntityEvent: {}", new Object[]{event.getTenantId(), event, e});
        }
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(DeleteEntityEvent<?> event) {
        TenantId tenantId = event.getTenantId();
        EntityType entityType = event.getEntityId().getEntityType();
        if (!tenantId.isSysTenantId() && !this.tenantService.tenantExists(tenantId)) {
            log.debug("[{}] Ignoring DeleteEntityEvent because tenant does not exist: {}", (Object)tenantId, event);
            return;
        }
        try {
            if (EntityType.TENANT == entityType || EntityType.EDGE == entityType || EntityType.AI_MODEL == entityType) {
                return;
            }
            log.trace("[{}] DeleteEntityEvent called: {}", (Object)tenantId, event);
            EdgeEventType type = this.getEdgeEventTypeForEntityEvent(event.getEntity());
            EdgeEventActionType actionType = this.getEdgeEventActionTypeForEntityEvent(event.getEntity());
            this.tbClusterService.sendNotificationMsgToEdge(tenantId, null, event.getEntityId(), JacksonUtil.toString((Object)event.getEntity()), type, actionType, (EdgeId)this.edgeSynchronizationManager.getEdgeId().get());
        }
        catch (Exception e) {
            log.error("[{}] failed to process DeleteEntityEvent: {}", new Object[]{tenantId, event, e});
        }
    }

    private EdgeEventActionType getEdgeEventActionTypeForEntityEvent(Object entity) {
        if (entity instanceof AlarmComment) {
            return EdgeEventActionType.DELETED_COMMENT;
        }
        if (entity instanceof Alarm) {
            return EdgeEventActionType.ALARM_DELETE;
        }
        return EdgeEventActionType.DELETED;
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(ActionEntityEvent<?> event) {
        if (EntityType.DEVICE.equals((Object)event.getEntityId().getEntityType()) && ActionType.ASSIGNED_TO_TENANT.equals((Object)event.getActionType())) {
            return;
        }
        if (EntityType.ALARM.equals((Object)event.getEntityId().getEntityType())) {
            return;
        }
        try {
            if (event.getEntityId().getEntityType().equals((Object)EntityType.RULE_CHAIN) && event.getEdgeId() != null && event.getActionType().equals((Object)ActionType.ASSIGNED_TO_EDGE)) {
                try {
                    Edge edge = (Edge)JacksonUtil.fromString((String)event.getBody(), Edge.class);
                    if (edge != null && new RuleChainId(event.getEntityId().getId()).equals((Object)edge.getRootRuleChainId())) {
                        log.trace("[{}] skipping ASSIGNED_TO_EDGE event of RULE_CHAIN entity in case Edge Root Rule Chain: {}", (Object)event.getTenantId(), event);
                        return;
                    }
                }
                catch (Exception ignored) {
                    return;
                }
            }
            log.trace("[{}] ActionEntityEvent called: {}", (Object)event.getTenantId(), event);
            this.tbClusterService.sendNotificationMsgToEdge(event.getTenantId(), event.getEdgeId(), event.getEntityId(), event.getBody(), null, EdgeUtils.getEdgeEventActionTypeByActionType((ActionType)event.getActionType()), (EdgeId)this.edgeSynchronizationManager.getEdgeId().get());
        }
        catch (Exception e) {
            log.error("[{}] failed to process ActionEntityEvent: {}", new Object[]{event.getTenantId(), event, e});
        }
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(RelationActionEvent event) {
        try {
            TenantId tenantId = event.getTenantId();
            if (ActionType.RELATION_DELETED.equals((Object)event.getActionType()) && !this.tenantService.tenantExists(tenantId)) {
                log.debug("[{}] Ignoring RelationActionEvent because tenant does not exist: {}", (Object)tenantId, (Object)event);
                return;
            }
            EntityRelation relation = event.getRelation();
            if (relation == null) {
                log.trace("[{}] skipping RelationActionEvent event in case relation is null: {}", (Object)event.getTenantId(), (Object)event);
                return;
            }
            if (!RelationTypeGroup.COMMON.equals((Object)relation.getTypeGroup())) {
                log.trace("[{}] skipping RelationActionEvent event in case NOT COMMON relation type group: {}", (Object)event.getTenantId(), (Object)event);
                return;
            }
            log.trace("[{}] RelationActionEvent called: {}", (Object)event.getTenantId(), (Object)event);
            this.tbClusterService.sendNotificationMsgToEdge(event.getTenantId(), null, null, JacksonUtil.toString((Object)relation), EdgeEventType.RELATION, EdgeUtils.getEdgeEventActionTypeByActionType((ActionType)event.getActionType()), (EdgeId)this.edgeSynchronizationManager.getEdgeId().get());
        }
        catch (Exception e) {
            log.error("[{}] failed to process RelationActionEvent: {}", new Object[]{event.getTenantId(), event, e});
        }
    }

    private boolean isValidSaveEntityEventForEdgeProcessing(SaveEntityEvent<?> event) {
        Object entity = event.getEntity();
        Object oldEntity = event.getOldEntity();
        if (event.getEntityId() != null) {
            switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[event.getEntityId().getEntityType().ordinal()]) {
                case 1: {
                    if (!(entity instanceof RuleChain)) break;
                    RuleChain ruleChain = (RuleChain)entity;
                    return RuleChainType.EDGE.equals((Object)ruleChain.getType());
                }
                case 2: {
                    if (!(entity instanceof User)) break;
                    User user = (User)entity;
                    if (Authority.SYS_ADMIN.equals((Object)user.getAuthority())) {
                        return false;
                    }
                    if (oldEntity == null) break;
                    user = (User)JacksonUtil.clone((Object)user);
                    User oldUser = (User)JacksonUtil.clone((Object)((User)oldEntity));
                    this.cleanUpUserAdditionalInfo(oldUser);
                    this.cleanUpUserAdditionalInfo(user);
                    return !user.equals((Object)oldUser);
                }
                case 3: {
                    if (!(entity instanceof OtaPackageInfo)) break;
                    OtaPackageInfo otaPackageInfo = (OtaPackageInfo)entity;
                    return otaPackageInfo.hasUrl() || otaPackageInfo.isHasData();
                }
                case 4: {
                    if (!(entity instanceof AlarmApiCallResult) && !(entity instanceof Alarm) && !(entity instanceof EntityAlarm)) break;
                    return false;
                }
                case 5: {
                    return event.getCreated() == false;
                }
                case 6: 
                case 7: 
                case 8: {
                    return false;
                }
                case 9: {
                    if (!(entity instanceof Domain)) break;
                    Domain domain = (Domain)entity;
                    return domain.isPropagateToEdge();
                }
            }
        }
        return true;
    }

    private void cleanUpUserAdditionalInfo(User user) {
        JsonNode jsonNode;
        if (user.getAdditionalInfo() instanceof NullNode) {
            user.setAdditionalInfo(null);
        }
        if ((jsonNode = user.getAdditionalInfo()) instanceof ObjectNode) {
            ObjectNode additionalInfo = (ObjectNode)jsonNode;
            if (additionalInfo.isEmpty()) {
                user.setAdditionalInfo(null);
            } else {
                user.setAdditionalInfo((JsonNode)additionalInfo);
            }
        }
        user.setVersion(null);
    }

    private EdgeEventType getEdgeEventTypeForEntityEvent(Object entity) {
        if (entity instanceof AlarmComment) {
            return EdgeEventType.ALARM_COMMENT;
        }
        return null;
    }

    private String getBodyMsgForEntityEvent(Object entity) {
        if (entity instanceof AlarmComment) {
            return JacksonUtil.toString((Object)entity);
        }
        if (entity instanceof CalculatedField) {
            CalculatedField calculatedField = (CalculatedField)entity;
            return JacksonUtil.toString((Object)calculatedField.getEntityId());
        }
        return null;
    }

    private EdgeEventActionType getActionForEntityEvent(Object entity, boolean isCreated) {
        if (entity instanceof AlarmComment) {
            return isCreated ? EdgeEventActionType.ADDED_COMMENT : EdgeEventActionType.UPDATED_COMMENT;
        }
        return isCreated ? EdgeEventActionType.ADDED : EdgeEventActionType.UPDATED;
    }

    @ConstructorProperties(value={"tbClusterService", "tenantService", "edgeSynchronizationManager"})
    @Generated
    public EdgeEventSourcingListener(TbClusterService tbClusterService, TenantService tenantService, EdgeSynchronizationManager edgeSynchronizationManager) {
        this.tbClusterService = tbClusterService;
        this.tenantService = tenantService;
        this.edgeSynchronizationManager = edgeSynchronizationManager;
    }
}

