/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.device;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.AttributesDeleteRequest;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.rule.engine.api.RuleEngineTelemetryService;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.device.ClaimDataInfo;
import org.thingsboard.server.dao.device.ClaimDevicesService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.device.claim.ClaimData;
import org.thingsboard.server.dao.device.claim.ClaimResponse;
import org.thingsboard.server.dao.device.claim.ClaimResult;
import org.thingsboard.server.dao.device.claim.ReclaimResult;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.queue.util.TbCoreComponent;

@Service
@TbCoreComponent
public class ClaimDevicesServiceImpl
implements ClaimDevicesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClaimDevicesServiceImpl.class);
    private static final String CLAIM_ATTRIBUTE_NAME = "claimingAllowed";
    private static final String CLAIM_DATA_ATTRIBUTE_NAME = "claimingData";
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private AttributesService attributesService;
    @Autowired
    private RuleEngineTelemetryService telemetryService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${security.claim.allowClaimingByDefault}")
    private boolean isAllowedClaimingByDefault;
    @Value(value="${security.claim.duration}")
    private long systemDurationMs;

    public ListenableFuture<Void> registerClaimingInfo(TenantId tenantId, DeviceId deviceId, String secretKey, long durationMs) {
        Device device = this.deviceService.findDeviceById(tenantId, deviceId);
        Cache cache = this.cacheManager.getCache("claimDevices");
        List key = this.constructCacheKey(device.getId());
        String deviceName = device.getName();
        if (this.isAllowedClaimingByDefault) {
            if (device.getCustomerId().getId().equals(ModelConstants.NULL_UUID)) {
                this.persistInCache(secretKey, durationMs, cache, key);
                return Futures.immediateFuture(null);
            }
            return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("Device [" + deviceName + "] has been already claimed!"));
        }
        ListenableFuture claimingAllowedFuture = this.attributesService.find(tenantId, (EntityId)device.getId(), AttributeScope.SERVER_SCOPE, List.of(CLAIM_ATTRIBUTE_NAME));
        return Futures.transform((ListenableFuture)claimingAllowedFuture, list -> {
            Optional claimingAllowedOptional;
            if (list != null && !list.isEmpty() && (claimingAllowedOptional = ((AttributeKvEntry)list.get(0)).getBooleanValue()).isPresent() && ((Boolean)claimingAllowedOptional.get()).booleanValue() && device.getCustomerId().getId().equals(ModelConstants.NULL_UUID)) {
                this.persistInCache(secretKey, durationMs, cache, key);
                return null;
            }
            throw new IllegalArgumentException("Failed to find claimingAllowed attribute for device [" + deviceName + "] or it is already claimed!");
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<ClaimDataInfo> getClaimData(Cache cache, Device device) {
        List key = this.constructCacheKey(device.getId());
        ClaimData claimDataFromCache = (ClaimData)cache.get((Object)key, ClaimData.class);
        if (claimDataFromCache != null) {
            return Futures.immediateFuture((Object)new ClaimDataInfo(true, key, claimDataFromCache));
        }
        ListenableFuture claimDataAttrFuture = this.attributesService.find(device.getTenantId(), (EntityId)device.getId(), AttributeScope.SERVER_SCOPE, CLAIM_DATA_ATTRIBUTE_NAME);
        return Futures.transform((ListenableFuture)claimDataAttrFuture, claimDataAttr -> {
            if (claimDataAttr.isPresent()) {
                ClaimData claimDataFromAttribute = (ClaimData)JacksonUtil.fromString((String)((AttributeKvEntry)claimDataAttr.get()).getValueAsString(), ClaimData.class);
                return new ClaimDataInfo(false, key, claimDataFromAttribute);
            }
            return null;
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<ClaimResult> claimDevice(Device device, CustomerId customerId, String secretKey) {
        Cache cache = this.cacheManager.getCache("claimDevices");
        ListenableFuture claimDataFuture = this.getClaimData(cache, device);
        return Futures.transformAsync((ListenableFuture)claimDataFuture, claimData -> {
            if (claimData != null) {
                long currTs = System.currentTimeMillis();
                if (currTs > claimData.getData().getExpirationTime() || !this.secretKeyIsEmptyOrEqual(secretKey, claimData.getData().getSecretKey())) {
                    log.warn("The claiming timeout occurred or wrong 'secretKey' provided for the device [{}]", (Object)device.getName());
                    if (claimData.isFromCache()) {
                        cache.evict((Object)claimData.getKey());
                    }
                    return Futures.immediateFuture((Object)new ClaimResult(null, ClaimResponse.FAILURE));
                }
                if (device.getCustomerId().getId().equals(ModelConstants.NULL_UUID)) {
                    device.setCustomerId(customerId);
                    Device savedDevice = this.deviceService.saveDevice(device);
                    return Futures.transform((ListenableFuture)this.removeClaimingSavedData(cache, claimData, device), result -> new ClaimResult(savedDevice, ClaimResponse.SUCCESS), (Executor)MoreExecutors.directExecutor());
                }
                return Futures.transform((ListenableFuture)this.removeClaimingSavedData(cache, claimData, device), result -> new ClaimResult(null, ClaimResponse.CLAIMED), (Executor)MoreExecutors.directExecutor());
            }
            log.warn("Failed to find the device's claiming message![{}]", (Object)device.getName());
            if (device.getCustomerId().getId().equals(ModelConstants.NULL_UUID)) {
                return Futures.immediateFuture((Object)new ClaimResult(null, ClaimResponse.FAILURE));
            }
            return Futures.immediateFuture((Object)new ClaimResult(null, ClaimResponse.CLAIMED));
        }, (Executor)MoreExecutors.directExecutor());
    }

    private boolean secretKeyIsEmptyOrEqual(String secretKeyA, String secretKeyB) {
        return StringUtils.isEmpty((String)secretKeyA) && StringUtils.isEmpty((String)secretKeyB) || secretKeyA.equals(secretKeyB);
    }

    public ListenableFuture<ReclaimResult> reClaimDevice(TenantId tenantId, Device device) {
        if (!device.getCustomerId().getId().equals(ModelConstants.NULL_UUID)) {
            this.cacheEviction(device.getId());
            Customer unassignedCustomer = this.customerService.findCustomerById(tenantId, device.getCustomerId());
            device.setCustomerId(null);
            Device savedDevice = this.deviceService.saveDevice(device);
            if (this.isAllowedClaimingByDefault) {
                return Futures.immediateFuture((Object)new ReclaimResult(unassignedCustomer));
            }
            SettableFuture result = SettableFuture.create();
            this.telemetryService.saveAttributes(AttributesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)savedDevice.getId()).scope(AttributeScope.SERVER_SCOPE).entry((KvEntry)new BooleanDataEntry(CLAIM_ATTRIBUTE_NAME, Boolean.valueOf(true))).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
            return result;
        }
        this.cacheEviction(device.getId());
        return Futures.immediateFuture((Object)new ReclaimResult(null));
    }

    private List<Object> constructCacheKey(DeviceId deviceId) {
        return List.of(deviceId);
    }

    private void persistInCache(String secretKey, long durationMs, Cache cache, List<Object> key) {
        ClaimData claimData = new ClaimData(secretKey, System.currentTimeMillis() + this.validateDurationMs(durationMs));
        cache.putIfAbsent(key, (Object)claimData);
    }

    private long validateDurationMs(long durationMs) {
        if (durationMs > 0L) {
            return durationMs;
        }
        return this.systemDurationMs;
    }

    private ListenableFuture<Void> removeClaimingSavedData(Cache cache, ClaimDataInfo data, Device device) {
        if (data.isFromCache()) {
            cache.evict((Object)data.getKey());
        }
        SettableFuture result = SettableFuture.create();
        this.telemetryService.deleteAttributes(AttributesDeleteRequest.builder().tenantId(device.getTenantId()).entityId((EntityId)device.getId()).scope(AttributeScope.SERVER_SCOPE).keys(Arrays.asList(CLAIM_ATTRIBUTE_NAME, CLAIM_DATA_ATTRIBUTE_NAME)).future(result).build());
        return result;
    }

    private void cacheEviction(DeviceId deviceId) {
        Cache cache = this.cacheManager.getCache("claimDevices");
        cache.evict((Object)this.constructCacheKey(deviceId));
    }
}

