/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.script.api.tbel.TbelCfArg;
import org.thingsboard.script.api.tbel.TbelCfCtx;
import org.thingsboard.script.api.tbel.TbelCfSingleValueArg;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.BaseCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;

public class ScriptCalculatedFieldState
extends BaseCalculatedFieldState {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScriptCalculatedFieldState.class);

    public ScriptCalculatedFieldState(List<String> requiredArguments) {
        super(requiredArguments);
    }

    public CalculatedFieldType getType() {
        return CalculatedFieldType.SCRIPT;
    }

    protected void validateNewEntry(ArgumentEntry newEntry) {
    }

    public ListenableFuture<CalculatedFieldResult> performCalculation(CalculatedFieldCtx ctx) {
        LinkedHashMap<String, TbelCfArg> arguments = new LinkedHashMap<String, TbelCfArg>();
        ArrayList<Object> args = new ArrayList<Object>(ctx.getArgNames().size() + 1);
        args.add(new Object());
        for (String argName : ctx.getArgNames()) {
            TbelCfArg arg = this.toTbelArgument(argName);
            arguments.put(argName, arg);
            if (arg instanceof TbelCfSingleValueArg) {
                TbelCfSingleValueArg svArg = (TbelCfSingleValueArg)arg;
                args.add(svArg.getValue());
                continue;
            }
            args.add(arg);
        }
        args.set(0, new TbelCfCtx(arguments, this.getLatestTimestamp()));
        ListenableFuture resultFuture = ctx.getCalculatedFieldScriptEngine().executeJsonAsync(args.toArray());
        Output output = ctx.getOutput();
        return Futures.transform((ListenableFuture)resultFuture, result -> new CalculatedFieldResult(output.getType(), output.getScope(), result), (Executor)MoreExecutors.directExecutor());
    }

    private TbelCfArg toTbelArgument(String key) {
        return ((ArgumentEntry)this.arguments.get(key)).toTbelCfArg();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptCalculatedFieldState)) {
            return false;
        }
        ScriptCalculatedFieldState other = (ScriptCalculatedFieldState)o;
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScriptCalculatedFieldState;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "ScriptCalculatedFieldState()";
    }

    @Generated
    public ScriptCalculatedFieldState() {
    }
}

