/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.MultipleTbCallback;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.OutputType;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.usagerecord.ApiLimitService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.util.TbRuleEngineComponent;
import org.thingsboard.server.service.cf.CalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.DefaultCalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.TsRollingArgumentEntry;
import org.thingsboard.server.utils.CalculatedFieldArgumentUtils;
import org.thingsboard.server.utils.CalculatedFieldUtils;

@TbRuleEngineComponent
@Service
public class DefaultCalculatedFieldProcessingService
implements CalculatedFieldProcessingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCalculatedFieldProcessingService.class);
    private final AttributesService attributesService;
    private final TimeseriesService timeseriesService;
    private final TbClusterService clusterService;
    private final ApiLimitService apiLimitService;
    private final PartitionService partitionService;
    private ListeningExecutorService calculatedFieldCallbackExecutor;

    @PostConstruct
    public void init() {
        this.calculatedFieldCallbackExecutor = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)Math.max(4, Runtime.getRuntime().availableProcessors()), (String)"calculated-field-callback"));
    }

    @PreDestroy
    public void stop() {
        if (this.calculatedFieldCallbackExecutor != null) {
            this.calculatedFieldCallbackExecutor.shutdownNow();
        }
    }

    public ListenableFuture<CalculatedFieldState> fetchStateFromDb(CalculatedFieldCtx ctx, EntityId entityId) {
        HashMap<String, ListenableFuture> argFutures = new HashMap<String, ListenableFuture>();
        for (Map.Entry entry : ctx.getArguments().entrySet()) {
            EntityId argEntityId = ((Argument)entry.getValue()).getRefEntityId() != null ? ((Argument)entry.getValue()).getRefEntityId() : entityId;
            ListenableFuture argValueFuture = this.fetchKvEntry(ctx.getTenantId(), argEntityId, (Argument)entry.getValue());
            argFutures.put((String)entry.getKey(), argValueFuture);
        }
        return Futures.whenAllComplete(argFutures.values()).call(() -> {
            CalculatedFieldState result = CalculatedFieldArgumentUtils.createStateByType((CalculatedFieldCtx)ctx);
            result.updateState(ctx, argFutures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                try {
                    return (ArgumentEntry)((ListenableFuture)entry.getValue()).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException("Error getting future result for key: " + (String)entry.getKey(), e);
                }
            })));
            return result;
        }, (Executor)this.calculatedFieldCallbackExecutor);
    }

    public Map<String, ArgumentEntry> fetchArgsFromDb(TenantId tenantId, EntityId entityId, Map<String, Argument> arguments) {
        HashMap<String, ListenableFuture> argFutures = new HashMap<String, ListenableFuture>();
        for (Map.Entry<String, Argument> entry2 : arguments.entrySet()) {
            EntityId argEntityId = entry2.getValue().getRefEntityId() != null ? entry2.getValue().getRefEntityId() : entityId;
            ListenableFuture argValueFuture = this.fetchKvEntry(tenantId, argEntityId, entry2.getValue());
            argFutures.put(entry2.getKey(), argValueFuture);
        }
        return argFutures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            try {
                return (ArgumentEntry)((ListenableFuture)entry.getValue()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Error getting future result for key: " + (String)entry.getKey(), e);
            }
        }));
    }

    public void pushMsgToRuleEngine(TenantId tenantId, EntityId entityId, CalculatedFieldResult calculatedFieldResult, List<CalculatedFieldId> cfIds, TbCallback callback) {
        try {
            OutputType type = calculatedFieldResult.getType();
            TbMsgType msgType = OutputType.ATTRIBUTES.equals((Object)type) ? TbMsgType.POST_ATTRIBUTES_REQUEST : TbMsgType.POST_TELEMETRY_REQUEST;
            TbMsgMetaData md = OutputType.ATTRIBUTES.equals((Object)type) ? new TbMsgMetaData(Map.of("scope", calculatedFieldResult.getScope().name())) : TbMsgMetaData.EMPTY;
            TbMsg msg = TbMsg.newMsg().type(msgType).originator(entityId).previousCalculatedFieldIds(cfIds).metaData(md).data(calculatedFieldResult.getResult().toString()).build();
            this.clusterService.pushMsgToRuleEngine(tenantId, entityId, msg, (TbQueueCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push message to rule engine. CalculatedFieldResult: {}", new Object[]{tenantId, entityId, calculatedFieldResult, e});
            callback.onFailure((Throwable)e);
        }
    }

    public void pushMsgToLinks(CalculatedFieldTelemetryMsg msg, List<CalculatedFieldEntityCtxId> linkedCalculatedFields, TbCallback callback) {
        HashMap<TopicPartitionInfo, List> unicasts = new HashMap<TopicPartitionInfo, List>();
        ArrayList<CalculatedFieldEntityCtxId> broadcasts = new ArrayList<CalculatedFieldEntityCtxId>();
        for (CalculatedFieldEntityCtxId link : linkedCalculatedFields) {
            boolean broadcast;
            EntityId linkEntityId = link.entityId();
            EntityType linkEntityType = linkEntityId.getEntityType();
            boolean bl = broadcast = EntityType.DEVICE_PROFILE.equals((Object)linkEntityType) || EntityType.ASSET_PROFILE.equals((Object)linkEntityType);
            if (broadcast) {
                broadcasts.add(link);
                continue;
            }
            TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_RULE_ENGINE, "CalculatedFields", link.tenantId(), link.entityId());
            unicasts.computeIfAbsent(tpi, k -> new ArrayList()).add(link);
        }
        MultipleTbCallback linkCallback = new MultipleTbCallback(2, callback);
        if (!broadcasts.isEmpty()) {
            this.broadcast(broadcasts, msg, linkCallback);
        } else {
            linkCallback.onSuccess();
        }
        if (!unicasts.isEmpty()) {
            this.unicast(unicasts, msg, linkCallback);
        } else {
            linkCallback.onSuccess();
        }
    }

    private void unicast(Map<TopicPartitionInfo, List<CalculatedFieldEntityCtxId>> unicasts, CalculatedFieldTelemetryMsg msg, MultipleTbCallback mainCallback) {
        TbCallbackWrapper callback = new TbCallbackWrapper((TbCallback)new MultipleTbCallback(unicasts.size(), (TbCallback)mainCallback));
        unicasts.forEach((arg_0, arg_1) -> this.lambda$unicast$4(msg, (TbQueueCallback)callback, arg_0, arg_1));
    }

    private void broadcast(List<CalculatedFieldEntityCtxId> broadcasts, CalculatedFieldTelemetryMsg msg, MultipleTbCallback mainCallback) {
        TbCallbackWrapper callback = new TbCallbackWrapper((TbCallback)mainCallback);
        TransportProtos.CalculatedFieldLinkedTelemetryMsgProto linkedTelemetryMsgProto = this.buildLinkedTelemetryMsgProto(msg.getProto(), broadcasts);
        this.clusterService.broadcastToCalculatedFields(TransportProtos.ToCalculatedFieldNotificationMsg.newBuilder().setLinkedTelemetryMsg(linkedTelemetryMsgProto).build(), (TbQueueCallback)callback);
    }

    private TransportProtos.CalculatedFieldLinkedTelemetryMsgProto buildLinkedTelemetryMsgProto(TransportProtos.CalculatedFieldTelemetryMsgProto telemetryProto, List<CalculatedFieldEntityCtxId> links) {
        TransportProtos.CalculatedFieldLinkedTelemetryMsgProto.Builder builder = TransportProtos.CalculatedFieldLinkedTelemetryMsgProto.newBuilder();
        builder.setMsg(telemetryProto);
        for (CalculatedFieldEntityCtxId link : links) {
            builder.addLinks(CalculatedFieldUtils.toProto((CalculatedFieldEntityCtxId)link));
        }
        return builder.build();
    }

    private ListenableFuture<ArgumentEntry> fetchKvEntry(TenantId tenantId, EntityId entityId, Argument argument) {
        return switch (2.$SwitchMap$org$thingsboard$server$common$data$cf$configuration$ArgumentType[argument.getRefEntityKey().getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.fetchTsRolling(tenantId, entityId, argument);
            case 2 -> Futures.transform((ListenableFuture)this.attributesService.find(tenantId, entityId, argument.getRefEntityKey().getScope(), argument.getRefEntityKey().getKey()), result -> CalculatedFieldArgumentUtils.transformSingleValueArgument((KvEntry)((KvEntry)result.orElseGet(() -> CalculatedFieldArgumentUtils.createDefaultAttributeEntry((Argument)argument, (long)System.currentTimeMillis())))), (Executor)this.calculatedFieldCallbackExecutor);
            case 3 -> Futures.transform((ListenableFuture)this.timeseriesService.findLatest(tenantId, entityId, argument.getRefEntityKey().getKey()), result -> CalculatedFieldArgumentUtils.transformSingleValueArgument((KvEntry)((KvEntry)result.orElseGet(() -> CalculatedFieldArgumentUtils.createDefaultTsKvEntry((Argument)argument, (long)System.currentTimeMillis())))), (Executor)this.calculatedFieldCallbackExecutor);
        };
    }

    private ListenableFuture<ArgumentEntry> fetchTsRolling(TenantId tenantId, EntityId entityId, Argument argument) {
        long currentTime = System.currentTimeMillis();
        long timeWindow = argument.getTimeWindow() == 0L ? System.currentTimeMillis() : argument.getTimeWindow();
        long startTs = currentTime - timeWindow;
        long maxDataPoints = this.apiLimitService.getLimit(tenantId, DefaultTenantProfileConfiguration::getMaxDataPointsPerRollingArg);
        int argumentLimit = argument.getLimit();
        int limit = argumentLimit == 0 || (long)argumentLimit > maxDataPoints ? (int)maxDataPoints : argument.getLimit();
        BaseReadTsKvQuery query = new BaseReadTsKvQuery(argument.getRefEntityKey().getKey(), startTs, currentTime, 0L, limit, Aggregation.NONE);
        ListenableFuture tsRollingFuture = this.timeseriesService.findAll(tenantId, entityId, List.of(query));
        return Futures.transform((ListenableFuture)tsRollingFuture, tsRolling -> tsRolling == null ? new TsRollingArgumentEntry(limit, timeWindow) : ArgumentEntry.createTsRollingArgument((List)tsRolling, (int)limit, (long)timeWindow), (Executor)this.calculatedFieldCallbackExecutor);
    }

    @ConstructorProperties(value={"attributesService", "timeseriesService", "clusterService", "apiLimitService", "partitionService"})
    @Generated
    public DefaultCalculatedFieldProcessingService(AttributesService attributesService, TimeseriesService timeseriesService, TbClusterService clusterService, ApiLimitService apiLimitService, PartitionService partitionService) {
        this.attributesService = attributesService;
        this.timeseriesService = timeseriesService;
        this.clusterService = clusterService;
        this.apiLimitService = apiLimitService;
        this.partitionService = partitionService;
    }

    private /* synthetic */ void lambda$unicast$4(CalculatedFieldTelemetryMsg msg, TbQueueCallback callback, TopicPartitionInfo topicPartitionInfo, List ctxIds) {
        TransportProtos.CalculatedFieldLinkedTelemetryMsgProto linkedTelemetryMsgProto = this.buildLinkedTelemetryMsgProto(msg.getProto(), ctxIds);
        this.clusterService.pushMsgToCalculatedFields(topicPartitionInfo, UUID.randomUUID(), TransportProtos.ToCalculatedFieldMsg.newBuilder().setLinkedTelemetryMsg(linkedTelemetryMsgProto).build(), callback);
    }
}

