/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.apiusage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.springframework.data.util.Pair;
import org.thingsboard.server.common.data.ApiFeature;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.ApiUsageStateValue;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileData;
import org.thingsboard.server.service.apiusage.BaseApiUsageState;

public class TenantApiUsageState
extends BaseApiUsageState {
    private TenantProfileId tenantProfileId;
    private TenantProfileData tenantProfileData;

    public TenantApiUsageState(TenantProfile tenantProfile, ApiUsageState apiUsageState) {
        super(apiUsageState);
        this.tenantProfileId = tenantProfile.getId();
        this.tenantProfileData = tenantProfile.getProfileData();
    }

    public TenantApiUsageState(ApiUsageState apiUsageState) {
        super(apiUsageState);
    }

    public long getProfileThreshold(ApiUsageRecordKey key) {
        return this.tenantProfileData.getConfiguration().getProfileThreshold(key);
    }

    public boolean getProfileFeatureEnabled(ApiUsageRecordKey key) {
        return this.tenantProfileData.getConfiguration().getProfileFeatureEnabled(key);
    }

    public long getProfileWarnThreshold(ApiUsageRecordKey key) {
        return this.tenantProfileData.getConfiguration().getWarnThreshold(key);
    }

    private Pair<ApiFeature, ApiUsageStateValue> checkStateUpdatedDueToThreshold(ApiFeature feature) {
        ApiUsageStateValue featureValue = ApiUsageStateValue.ENABLED;
        for (ApiUsageRecordKey recordKey : ApiUsageRecordKey.getKeys((ApiFeature)feature)) {
            ApiUsageStateValue tmpValue;
            long value = this.get(recordKey);
            boolean featureEnabled = this.getProfileFeatureEnabled(recordKey);
            if (featureEnabled) {
                long threshold = this.getProfileThreshold(recordKey);
                long warnThreshold = this.getProfileWarnThreshold(recordKey);
                tmpValue = threshold == 0L || value == 0L || value < warnThreshold ? ApiUsageStateValue.ENABLED : (value < threshold ? ApiUsageStateValue.WARNING : ApiUsageStateValue.DISABLED);
            } else {
                tmpValue = ApiUsageStateValue.DISABLED;
            }
            featureValue = ApiUsageStateValue.toMoreRestricted((ApiUsageStateValue)featureValue, (ApiUsageStateValue)tmpValue);
        }
        return this.setFeatureValue(feature, featureValue) ? Pair.of((Object)feature, (Object)featureValue) : null;
    }

    public Map<ApiFeature, ApiUsageStateValue> checkStateUpdatedDueToThresholds() {
        return this.checkStateUpdatedDueToThreshold(new HashSet<ApiFeature>(Arrays.asList(ApiFeature.values())));
    }

    public Map<ApiFeature, ApiUsageStateValue> checkStateUpdatedDueToThreshold(Set<ApiFeature> features) {
        HashMap<ApiFeature, ApiUsageStateValue> result = new HashMap<ApiFeature, ApiUsageStateValue>();
        for (ApiFeature feature : features) {
            Pair tmp = this.checkStateUpdatedDueToThreshold(feature);
            if (tmp == null) continue;
            result.put((ApiFeature)tmp.getFirst(), (ApiUsageStateValue)tmp.getSecond());
        }
        return result;
    }

    public EntityType getEntityType() {
        return EntityType.TENANT;
    }

    @Generated
    public TenantProfileId getTenantProfileId() {
        return this.tenantProfileId;
    }

    @Generated
    public void setTenantProfileId(TenantProfileId tenantProfileId) {
        this.tenantProfileId = tenantProfileId;
    }

    @Generated
    public TenantProfileData getTenantProfileData() {
        return this.tenantProfileData;
    }

    @Generated
    public void setTenantProfileData(TenantProfileData tenantProfileData) {
        this.tenantProfileData = tenantProfileData;
    }
}

