/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.apiusage;

import com.google.common.util.concurrent.ListenableFuture;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.common.data.ApiFeature;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.ApiUsageRecordState;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.ApiUsageStateValue;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.ApiUsageStateId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.notification.rule.trigger.ApiUsageLimitTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileData;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.msg.tools.SchedulerUtils;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.usagerecord.ApiUsageStateService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.service.apiusage.BaseApiUsageState;
import org.thingsboard.server.service.apiusage.CustomerApiUsageState;
import org.thingsboard.server.service.apiusage.DefaultTbApiUsageStateService;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.apiusage.TenantApiUsageState;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;
import org.thingsboard.server.service.mail.MailExecutorService;
import org.thingsboard.server.service.partition.AbstractPartitionBasedService;
import org.thingsboard.server.service.telemetry.InternalTelemetryService;

@Service
public class DefaultTbApiUsageStateService
extends AbstractPartitionBasedService<EntityId>
implements TbApiUsageStateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbApiUsageStateService.class);
    public static final String HOURLY = "Hourly";
    private final PartitionService partitionService;
    private final TenantService tenantService;
    private final TimeseriesService tsService;
    private final ApiUsageStateService apiUsageStateService;
    private final TbTenantProfileCache tenantProfileCache;
    private final MailService mailService;
    private final NotificationRuleProcessor notificationRuleProcessor;
    private final DbCallbackExecutorService dbExecutor;
    private final MailExecutorService mailExecutor;
    @Lazy
    @Autowired
    private InternalTelemetryService tsWsService;
    final Map<EntityId, BaseApiUsageState> myUsageStates = new ConcurrentHashMap();
    final Map<EntityId, ApiUsageState> otherUsageStates = new ConcurrentHashMap();
    final Set<EntityId> deletedEntities = Collections.newSetFromMap(new ConcurrentHashMap());
    @Value(value="${usage.stats.report.enabled:true}")
    private boolean enabled;
    @Value(value="${usage.stats.check.cycle:60000}")
    private long nextCycleCheckInterval;
    @Value(value="${usage.stats.gauge_report_interval:180000}")
    private long gaugeReportInterval;
    private final Lock updateLock = new ReentrantLock();

    @PostConstruct
    public void init() {
        super.init();
        if (this.enabled) {
            log.info("Starting api usage service.");
            this.scheduledExecutor.scheduleAtFixedRate(() -> this.checkStartOfNextCycle(), this.nextCycleCheckInterval, this.nextCycleCheckInterval, TimeUnit.MILLISECONDS);
            log.info("Started api usage service.");
        }
    }

    protected String getServiceName() {
        return "API Usage";
    }

    protected String getSchedulerExecutorName() {
        return "api-usage-scheduled";
    }

    public void process(TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg> msgPack, TbCallback callback) {
        List<TransportProtos.UsageStatsServiceMsg> msgs;
        TransportProtos.ToUsageStatsServiceMsg serviceMsg = (TransportProtos.ToUsageStatsServiceMsg)msgPack.getValue();
        String serviceId = serviceMsg.getServiceId();
        if (serviceMsg.getMsgsList().isEmpty()) {
            TransportProtos.UsageStatsServiceMsg oldMsg = TransportProtos.UsageStatsServiceMsg.newBuilder().setTenantIdMSB(serviceMsg.getTenantIdMSB()).setTenantIdLSB(serviceMsg.getTenantIdLSB()).setCustomerIdMSB(serviceMsg.getCustomerIdMSB()).setCustomerIdLSB(serviceMsg.getCustomerIdLSB()).setEntityIdMSB(serviceMsg.getEntityIdMSB()).setEntityIdLSB(serviceMsg.getEntityIdLSB()).addAllValues((Iterable)serviceMsg.getValuesList()).build();
            msgs = List.of(oldMsg);
        } else {
            msgs = serviceMsg.getMsgsList();
        }
        msgs.forEach(msg -> {
            TenantId tenantId = TenantId.fromUUID((UUID)new UUID(msg.getTenantIdMSB(), msg.getTenantIdLSB()));
            Object ownerId = msg.getCustomerIdMSB() != 0L && msg.getCustomerIdLSB() != 0L ? new CustomerId(new UUID(msg.getCustomerIdMSB(), msg.getCustomerIdLSB())) : tenantId;
            this.processEntityUsageStats(tenantId, (EntityId)ownerId, msg.getValuesList(), serviceId);
        });
        callback.onSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntityUsageStats(TenantId tenantId, EntityId ownerId, List<TransportProtos.UsageStatsKVProto> values, String serviceId) {
        Map result;
        ArrayList<BasicTsKvEntry> updatedEntries;
        BaseApiUsageState usageState;
        if (this.deletedEntities.contains(ownerId)) {
            return;
        }
        this.updateLock.lock();
        try {
            usageState = this.getOrFetchState(tenantId, ownerId);
            long ts = usageState.getCurrentCycleTs();
            long hourTs = usageState.getCurrentHourTs();
            long newHourTs = SchedulerUtils.getStartOfCurrentHour();
            if (newHourTs != hourTs) {
                usageState.setHour(newHourTs);
            }
            if (log.isTraceEnabled()) {
                log.trace("[{}][{}] Processing usage stats from {} (currentCycleTs={}, currentHourTs={}): {}", new Object[]{tenantId, ownerId, serviceId, ts, newHourTs, values});
            }
            updatedEntries = new ArrayList<BasicTsKvEntry>(ApiUsageRecordKey.values().length);
            HashSet<ApiFeature> apiFeatures = new HashSet<ApiFeature>();
            for (TransportProtos.UsageStatsKVProto statsItem : values) {
                ApiUsageRecordKey recordKey = StringUtils.isNotEmpty((String)statsItem.getKey()) ? ApiUsageRecordKey.valueOf((String)statsItem.getKey()) : ProtoUtils.fromProto((TransportProtos.ApiUsageRecordKeyProto)statsItem.getRecordKey());
                BaseApiUsageState.StatsCalculationResult calculationResult = usageState.calculate(recordKey, statsItem.getValue(), serviceId);
                if (calculationResult.isValueChanged()) {
                    long newValue = calculationResult.getNewValue();
                    updatedEntries.add(new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry(recordKey.getApiCountKey(), Long.valueOf(newValue))));
                }
                if (calculationResult.isHourlyValueChanged()) {
                    long newHourlyValue = calculationResult.getNewHourlyValue();
                    updatedEntries.add(new BasicTsKvEntry(newHourTs, (KvEntry)new LongDataEntry(recordKey.getApiCountKey() + HOURLY, Long.valueOf(newHourlyValue))));
                }
                if (recordKey.getApiFeature() == null) continue;
                apiFeatures.add(recordKey.getApiFeature());
            }
            result = usageState.getEntityType() == EntityType.TENANT && !usageState.getEntityId().equals(TenantId.SYS_TENANT_ID) ? ((TenantApiUsageState)usageState).checkStateUpdatedDueToThreshold(apiFeatures) : Collections.emptyMap();
        }
        finally {
            this.updateLock.unlock();
        }
        log.trace("[{}][{}] Saving new stats: {}", new Object[]{tenantId, ownerId, updatedEntries});
        this.tsWsService.saveTimeseriesInternal(TimeseriesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)usageState.getApiUsageState().getId()).entries(updatedEntries).build());
        if (!result.isEmpty()) {
            this.persistAndNotify(usageState, result);
        }
    }

    public ApiUsageState getApiUsageState(TenantId tenantId) {
        TenantApiUsageState tenantState = (TenantApiUsageState)this.myUsageStates.get(tenantId);
        if (tenantState != null) {
            return tenantState.getApiUsageState();
        }
        ApiUsageState state = (ApiUsageState)this.otherUsageStates.get(tenantId);
        if (state != null) {
            return state;
        }
        if (this.partitionService.resolve(ServiceType.TB_CORE, tenantId, (EntityId)tenantId).isMyPartition()) {
            return this.getOrFetchState(tenantId, (EntityId)tenantId).getApiUsageState();
        }
        state = (ApiUsageState)this.otherUsageStates.get(tenantId);
        if (state == null && (state = this.apiUsageStateService.findTenantApiUsageState(tenantId)) != null) {
            this.otherUsageStates.put(tenantId, state);
        }
        return state;
    }

    public void onApiUsageStateUpdate(TenantId tenantId) {
        this.otherUsageStates.remove(tenantId);
    }

    public void onTenantProfileUpdate(TenantProfileId tenantProfileId) {
        log.info("[{}] On Tenant Profile Update", (Object)tenantProfileId);
        TenantProfile tenantProfile = this.tenantProfileCache.get(tenantProfileId);
        this.updateLock.lock();
        try {
            this.myUsageStates.values().stream().filter(state -> state.getEntityType() == EntityType.TENANT).map(state -> (TenantApiUsageState)state).forEach(state -> {
                if (tenantProfile.getId().equals((Object)state.getTenantProfileId())) {
                    this.updateTenantState(state, tenantProfile);
                }
            });
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTenantUpdate(TenantId tenantId) {
        log.info("[{}] On Tenant Update.", (Object)tenantId);
        TenantProfile tenantProfile = this.tenantProfileCache.get(tenantId);
        this.updateLock.lock();
        try {
            TenantApiUsageState state = (TenantApiUsageState)this.myUsageStates.get(tenantId);
            if (state != null && !state.getTenantProfileId().equals((Object)tenantProfile.getId())) {
                this.updateTenantState(state, tenantProfile);
            }
        }
        finally {
            this.updateLock.unlock();
        }
    }

    private void updateTenantState(TenantApiUsageState state, TenantProfile profile) {
        TenantProfileData oldProfileData = state.getTenantProfileData();
        state.setTenantProfileId(profile.getId());
        state.setTenantProfileData(profile.getProfileData());
        Map result = state.checkStateUpdatedDueToThresholds();
        if (!result.isEmpty()) {
            this.persistAndNotify((BaseApiUsageState)state, result);
        }
        this.updateProfileThresholds(state.getTenantId(), (ApiUsageStateId)state.getApiUsageState().getId(), oldProfileData.getConfiguration(), profile.getProfileData().getConfiguration());
    }

    private void addEntityState(TopicPartitionInfo tpi, BaseApiUsageState state) {
        EntityId entityId = state.getEntityId();
        Set entityIds = (Set)this.partitionedEntities.get(tpi);
        if (entityIds == null) {
            log.debug("[{}] belongs to external partition {}", (Object)entityId, (Object)tpi.getFullTopicName());
            throw new RuntimeException(String.valueOf(entityId.getEntityType()) + " belongs to external partition " + tpi.getFullTopicName() + "!");
        }
        entityIds.add(entityId);
        this.myUsageStates.put(entityId, state);
    }

    private void updateProfileThresholds(TenantId tenantId, ApiUsageStateId id, TenantProfileConfiguration oldData, TenantProfileConfiguration newData) {
        long ts = System.currentTimeMillis();
        ArrayList<BasicTsKvEntry> profileThresholds = new ArrayList<BasicTsKvEntry>();
        for (ApiUsageRecordKey key : ApiUsageRecordKey.values()) {
            long newProfileThreshold = newData.getProfileThreshold(key);
            if (oldData != null && oldData.getProfileThreshold(key) == newProfileThreshold) continue;
            log.info("[{}] Updating profile threshold [{}]:[{}]", new Object[]{tenantId, key, newProfileThreshold});
            profileThresholds.add(new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry(key.getApiLimitKey(), Long.valueOf(newProfileThreshold))));
        }
        if (!profileThresholds.isEmpty()) {
            this.tsWsService.saveTimeseriesInternal(TimeseriesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)id).entries(profileThresholds).build());
        }
    }

    public void onTenantDelete(TenantId tenantId) {
        this.deletedEntities.add(tenantId);
        this.myUsageStates.remove(tenantId);
        this.otherUsageStates.remove(tenantId);
    }

    public void onCustomerDelete(CustomerId customerId) {
        this.deletedEntities.add(customerId);
        this.myUsageStates.remove(customerId);
    }

    protected void cleanupEntityOnPartitionRemoval(EntityId entityId) {
        this.myUsageStates.remove(entityId);
    }

    private void persistAndNotify(BaseApiUsageState state, Map<ApiFeature, ApiUsageStateValue> result) {
        log.info("[{}] Detected update of the API state for {}: {}", new Object[]{state.getEntityId(), state.getEntityType(), result});
        ApiUsageState updatedState = this.apiUsageStateService.update(state.getApiUsageState());
        state.setApiUsageState(updatedState);
        long ts = System.currentTimeMillis();
        ArrayList stateTelemetry = new ArrayList();
        result.forEach((apiFeature, aState) -> stateTelemetry.add(new BasicTsKvEntry(ts, (KvEntry)new StringDataEntry(apiFeature.getApiStateKey(), aState.name()))));
        this.tsWsService.saveTimeseriesInternal(TimeseriesSaveRequest.builder().tenantId(state.getTenantId()).entityId((EntityId)state.getApiUsageState().getId()).entries(stateTelemetry).build());
        if (state.getEntityType() == EntityType.TENANT && !state.getEntityId().equals(TenantId.SYS_TENANT_ID)) {
            String email = this.tenantService.findTenantById(state.getTenantId()).getEmail();
            result.forEach((apiFeature, stateValue) -> {
                ApiUsageRecordState recordState = this.createApiUsageRecordState((TenantApiUsageState)state, apiFeature, stateValue);
                if (recordState == null) {
                    return;
                }
                this.notificationRuleProcessor.process((NotificationRuleTrigger)ApiUsageLimitTrigger.builder().tenantId(state.getTenantId()).state(recordState).status(stateValue).build());
                if (StringUtils.isNotEmpty((String)email)) {
                    this.mailExecutor.submit(() -> {
                        try {
                            this.mailService.sendApiFeatureStateEmail(apiFeature, stateValue, email, recordState);
                        }
                        catch (ThingsboardException e) {
                            log.warn("[{}] Can't send update of the API state to tenant with provided email [{}]", new Object[]{state.getTenantId(), email, e});
                        }
                    });
                }
            });
        }
    }

    private ApiUsageRecordState createApiUsageRecordState(TenantApiUsageState state, ApiFeature apiFeature, ApiUsageStateValue stateValue) {
        StateChecker checker = this.getStateChecker(stateValue);
        for (ApiUsageRecordKey apiUsageRecordKey : ApiUsageRecordKey.getKeys((ApiFeature)apiFeature)) {
            long value;
            long warnThreshold;
            long threshold = state.getProfileThreshold(apiUsageRecordKey);
            if (!checker.check(threshold, warnThreshold = state.getProfileWarnThreshold(apiUsageRecordKey), value = state.get(apiUsageRecordKey))) continue;
            return new ApiUsageRecordState(apiFeature, apiUsageRecordKey, threshold, value);
        }
        return null;
    }

    private StateChecker getStateChecker(ApiUsageStateValue stateValue) {
        if (ApiUsageStateValue.ENABLED.equals((Object)stateValue)) {
            return (t, wt, v) -> true;
        }
        if (ApiUsageStateValue.WARNING.equals((Object)stateValue)) {
            return (t, wt, v) -> v < t && v >= wt;
        }
        return (t, wt, v) -> t > 0L && v >= t;
    }

    public ApiUsageState findApiUsageStateById(TenantId tenantId, ApiUsageStateId id) {
        return this.apiUsageStateService.findApiUsageStateById(tenantId, id);
    }

    public void checkStartOfNextCycle() {
        this.updateLock.lock();
        try {
            long now = System.currentTimeMillis();
            this.myUsageStates.values().forEach(state -> {
                if (state.getNextCycleTs() < now && now - state.getNextCycleTs() < TimeUnit.HOURS.toMillis(1L)) {
                    state.setCycles(state.getNextCycleTs(), SchedulerUtils.getStartOfNextMonth());
                    if (log.isTraceEnabled()) {
                        log.trace("[{}][{}] Updating state cycles (currentCycleTs={},nextCycleTs={})", new Object[]{state.getTenantId(), state.getEntityId(), state.getCurrentCycleTs(), state.getNextCycleTs()});
                    }
                    this.saveNewCounts(state, Arrays.asList(ApiUsageRecordKey.values()));
                    if (state.getEntityType() == EntityType.TENANT && !state.getEntityId().equals(TenantId.SYS_TENANT_ID)) {
                        TenantId tenantId = state.getTenantId();
                        this.updateTenantState((TenantApiUsageState)state, this.tenantProfileCache.get(tenantId));
                    }
                }
            });
        }
        catch (Throwable e) {
            log.error("Failed to check start of next cycle", e);
        }
        finally {
            this.updateLock.unlock();
        }
    }

    private void saveNewCounts(BaseApiUsageState state, List<ApiUsageRecordKey> keys) {
        List counts = keys.stream().map(key -> new BasicTsKvEntry(state.getCurrentCycleTs(), (KvEntry)new LongDataEntry(key.getApiCountKey(), Long.valueOf(0L)))).collect(Collectors.toList());
        this.tsWsService.saveTimeseriesInternal(TimeseriesSaveRequest.builder().tenantId(state.getTenantId()).entityId((EntityId)state.getApiUsageState().getId()).entries(counts).build());
    }

    BaseApiUsageState getOrFetchState(TenantId tenantId, EntityId ownerId) {
        Object state;
        if (ownerId == null || ownerId.isNullUid()) {
            ownerId = tenantId;
        }
        if ((state = (BaseApiUsageState)this.myUsageStates.get(ownerId)) != null) {
            return state;
        }
        ApiUsageState storedState = this.apiUsageStateService.findApiUsageStateByEntityId(ownerId);
        if (storedState == null) {
            try {
                storedState = this.apiUsageStateService.createDefaultApiUsageState(tenantId, ownerId);
            }
            catch (Exception e) {
                storedState = this.apiUsageStateService.findApiUsageStateByEntityId(ownerId);
            }
        }
        state = ownerId.getEntityType() == EntityType.TENANT ? (!ownerId.equals(TenantId.SYS_TENANT_ID) ? new TenantApiUsageState(this.tenantProfileCache.get((TenantId)ownerId), storedState) : new TenantApiUsageState(storedState)) : new CustomerApiUsageState(storedState);
        ArrayList<ApiUsageRecordKey> newCounts = new ArrayList<ApiUsageRecordKey>();
        try {
            List dbValues = (List)this.tsService.findAllLatest(tenantId, (EntityId)storedState.getId()).get();
            block4: for (ApiUsageRecordKey key : ApiUsageRecordKey.values()) {
                boolean cycleEntryFound = false;
                boolean hourlyEntryFound = false;
                for (TsKvEntry tsKvEntry : dbValues) {
                    if (tsKvEntry.getKey().equals(key.getApiCountKey())) {
                        cycleEntryFound = true;
                        boolean oldCount = tsKvEntry.getTs() == state.getCurrentCycleTs();
                        state.set(key, Long.valueOf(oldCount ? (Long)tsKvEntry.getLongValue().get() : 0L));
                        if (!oldCount) {
                            newCounts.add(key);
                        }
                    } else if (tsKvEntry.getKey().equals(key.getApiCountKey() + HOURLY)) {
                        hourlyEntryFound = true;
                        state.setHourly(key, Long.valueOf(tsKvEntry.getTs() == state.getCurrentHourTs() ? (Long)tsKvEntry.getLongValue().get() : 0L));
                    }
                    if (!cycleEntryFound || !hourlyEntryFound) continue;
                    continue block4;
                }
            }
            state.setGaugeReportInterval(this.gaugeReportInterval);
            log.debug("[{}][{}] Initialized state: {}", new Object[]{tenantId, ownerId, state});
            TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenantId, ownerId);
            if (tpi.isMyPartition()) {
                this.addEntityState(tpi, state);
            } else {
                this.otherUsageStates.put(ownerId, state.getApiUsageState());
            }
            this.saveNewCounts(state, newCounts);
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("[{}] Failed to fetch api usage state from db.", (Object)tenantId, (Object)e);
        }
        return state;
    }

    protected void onRepartitionEvent() {
        this.otherUsageStates.entrySet().removeIf(entry -> this.partitionService.resolve(ServiceType.TB_CORE, ((ApiUsageState)entry.getValue()).getTenantId(), (EntityId)entry.getKey()).isMyPartition());
        this.updateLock.lock();
        try {
            this.myUsageStates.values().forEach(BaseApiUsageState::onRepartitionEvent);
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<TopicPartitionInfo, List<ListenableFuture<?>>> onAddedPartitions(Set<TopicPartitionInfo> addedPartitions) {
        HashMap result = new HashMap();
        try {
            log.info("Initializing tenant states.");
            this.updateLock.lock();
            try {
                PageDataIterable tenantIterator = new PageDataIterable(arg_0 -> ((TenantService)this.tenantService).findTenants(arg_0), 1024);
                for (Tenant tenant : tenantIterator) {
                    TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenant.getId(), (EntityId)tenant.getId());
                    if (addedPartitions.contains(tpi)) {
                        if (this.myUsageStates.containsKey(tenant.getId()) || !tpi.isMyPartition()) continue;
                        log.debug("[{}] Initializing tenant state.", (Object)tenant.getId());
                        result.computeIfAbsent(tpi, tmp -> new ArrayList()).add(this.dbExecutor.submit(() -> {
                            try {
                                this.updateTenantState((TenantApiUsageState)this.getOrFetchState(tenant.getId(), (EntityId)tenant.getId()), this.tenantProfileCache.get(tenant.getTenantProfileId()));
                                log.debug("[{}] Initialized tenant state.", (Object)tenant.getId());
                            }
                            catch (Exception e) {
                                log.warn("[{}] Failed to initialize tenant API state", (Object)tenant.getId(), (Object)e);
                            }
                            return null;
                        }));
                        continue;
                    }
                    log.debug("[{}][{}] Tenant doesn't belong to current partition. tpi [{}]", new Object[]{tenant.getName(), tenant.getId(), tpi});
                }
            }
            finally {
                this.updateLock.unlock();
            }
        }
        catch (Exception e) {
            log.warn("Unknown failure", (Throwable)e);
        }
        return result;
    }

    @PreDestroy
    private void destroy() {
        super.stop();
    }

    @ConstructorProperties(value={"partitionService", "tenantService", "tsService", "apiUsageStateService", "tenantProfileCache", "mailService", "notificationRuleProcessor", "dbExecutor", "mailExecutor"})
    @Generated
    public DefaultTbApiUsageStateService(PartitionService partitionService, TenantService tenantService, TimeseriesService tsService, ApiUsageStateService apiUsageStateService, TbTenantProfileCache tenantProfileCache, MailService mailService, NotificationRuleProcessor notificationRuleProcessor, DbCallbackExecutorService dbExecutor, MailExecutorService mailExecutor) {
        this.partitionService = partitionService;
        this.tenantService = tenantService;
        this.tsService = tsService;
        this.apiUsageStateService = apiUsageStateService;
        this.tenantProfileCache = tenantProfileCache;
        this.mailService = mailService;
        this.notificationRuleProcessor = notificationRuleProcessor;
        this.dbExecutor = dbExecutor;
        this.mailExecutor = mailExecutor;
    }
}

