/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.apiusage;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.thingsboard.server.common.data.ApiFeature;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.ApiUsageStateValue;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.tools.SchedulerUtils;
import org.thingsboard.server.service.apiusage.BaseApiUsageState;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BaseApiUsageState {
    private final Map<ApiUsageRecordKey, Long> currentCycleValues = new ConcurrentHashMap();
    private final Map<ApiUsageRecordKey, Long> currentHourValues = new ConcurrentHashMap();
    private final Map<ApiUsageRecordKey, Map<String, Long>> lastGaugesByServiceId = new HashMap();
    private final Map<ApiUsageRecordKey, Long> gaugesReportCycles = new HashMap();
    private ApiUsageState apiUsageState;
    private volatile long currentCycleTs;
    private volatile long nextCycleTs;
    private volatile long currentHourTs;
    private long gaugeReportInterval;

    public BaseApiUsageState(ApiUsageState apiUsageState) {
        this.apiUsageState = apiUsageState;
        this.currentCycleTs = SchedulerUtils.getStartOfCurrentMonth();
        this.nextCycleTs = SchedulerUtils.getStartOfNextMonth();
        this.currentHourTs = SchedulerUtils.getStartOfCurrentHour();
    }

    public StatsCalculationResult calculate(ApiUsageRecordKey key, long value, String serviceId) {
        StatsCalculationResult result;
        long currentValue = this.get(key);
        long currentHourlyValue = this.getHourly(key);
        if (key.isCounter()) {
            result = StatsCalculationResult.builder().newValue(currentValue + value).valueChanged(true).newHourlyValue(currentHourlyValue + value).hourlyValueChanged(true).build();
        } else {
            Long newGaugeValue = this.calculateGauge(key, value, serviceId);
            long newValue = newGaugeValue != null ? newGaugeValue : currentValue;
            long newHourlyValue = newGaugeValue != null ? Math.max(newGaugeValue, currentHourlyValue) : currentHourlyValue;
            result = StatsCalculationResult.builder().newValue(newValue).valueChanged(newValue != currentValue || !this.currentCycleValues.containsKey(key)).newHourlyValue(newHourlyValue).hourlyValueChanged(newHourlyValue != currentHourlyValue || !this.currentHourValues.containsKey(key)).build();
        }
        this.set(key, Long.valueOf(result.getNewValue()));
        this.setHourly(key, Long.valueOf(result.getNewHourlyValue()));
        return result;
    }

    private Long calculateGauge(ApiUsageRecordKey key, long value, String serviceId) {
        Map lastByServiceId = this.lastGaugesByServiceId.computeIfAbsent(key, k -> {
            this.gaugesReportCycles.put(key, System.currentTimeMillis());
            return new HashMap();
        });
        lastByServiceId.put(serviceId, value);
        Long gaugeReportCycle = (Long)this.gaugesReportCycles.get(key);
        if (gaugeReportCycle <= System.currentTimeMillis() - this.gaugeReportInterval) {
            long newValue = lastByServiceId.values().stream().mapToLong(Long::longValue).sum();
            this.lastGaugesByServiceId.remove(key);
            this.gaugesReportCycles.remove(key);
            return newValue;
        }
        return null;
    }

    public void set(ApiUsageRecordKey key, Long value) {
        this.currentCycleValues.put(key, value);
    }

    public long get(ApiUsageRecordKey key) {
        return this.currentCycleValues.getOrDefault(key, 0L);
    }

    public void setHourly(ApiUsageRecordKey key, Long value) {
        this.currentHourValues.put(key, value);
    }

    public long getHourly(ApiUsageRecordKey key) {
        return this.currentHourValues.getOrDefault(key, 0L);
    }

    public void setHour(long currentHourTs) {
        this.currentHourTs = currentHourTs;
        this.currentHourValues.clear();
        this.lastGaugesByServiceId.clear();
        this.gaugesReportCycles.clear();
    }

    public void setCycles(long currentCycleTs, long nextCycleTs) {
        this.currentCycleTs = currentCycleTs;
        this.nextCycleTs = nextCycleTs;
        this.currentCycleValues.clear();
    }

    public void onRepartitionEvent() {
        this.lastGaugesByServiceId.clear();
        this.gaugesReportCycles.clear();
    }

    public ApiUsageStateValue getFeatureValue(ApiFeature feature) {
        switch (1.$SwitchMap$org$thingsboard$server$common$data$ApiFeature[feature.ordinal()]) {
            case 1: {
                return this.apiUsageState.getTransportState();
            }
            case 2: {
                return this.apiUsageState.getReExecState();
            }
            case 3: {
                return this.apiUsageState.getDbStorageState();
            }
            case 4: {
                return this.apiUsageState.getJsExecState();
            }
            case 5: {
                return this.apiUsageState.getTbelExecState();
            }
            case 6: {
                return this.apiUsageState.getEmailExecState();
            }
            case 7: {
                return this.apiUsageState.getSmsExecState();
            }
            case 8: {
                return this.apiUsageState.getAlarmExecState();
            }
        }
        return ApiUsageStateValue.ENABLED;
    }

    public boolean setFeatureValue(ApiFeature feature, ApiUsageStateValue value) {
        ApiUsageStateValue currentValue = this.getFeatureValue(feature);
        switch (1.$SwitchMap$org$thingsboard$server$common$data$ApiFeature[feature.ordinal()]) {
            case 1: {
                this.apiUsageState.setTransportState(value);
                break;
            }
            case 2: {
                this.apiUsageState.setReExecState(value);
                break;
            }
            case 3: {
                this.apiUsageState.setDbStorageState(value);
                break;
            }
            case 4: {
                this.apiUsageState.setJsExecState(value);
                break;
            }
            case 5: {
                this.apiUsageState.setTbelExecState(value);
                break;
            }
            case 6: {
                this.apiUsageState.setEmailExecState(value);
                break;
            }
            case 7: {
                this.apiUsageState.setSmsExecState(value);
                break;
            }
            case 8: {
                this.apiUsageState.setAlarmExecState(value);
            }
        }
        return !currentValue.equals((Object)value);
    }

    public abstract EntityType getEntityType();

    public TenantId getTenantId() {
        return this.getApiUsageState().getTenantId();
    }

    public EntityId getEntityId() {
        return this.getApiUsageState().getEntityId();
    }

    public String toString() {
        return "BaseApiUsageState{apiUsageState=" + String.valueOf(this.apiUsageState) + ", currentCycleTs=" + this.currentCycleTs + ", nextCycleTs=" + this.nextCycleTs + ", currentHourTs=" + this.currentHourTs + "}";
    }

    @Generated
    public ApiUsageState getApiUsageState() {
        return this.apiUsageState;
    }

    @Generated
    public void setApiUsageState(ApiUsageState apiUsageState) {
        this.apiUsageState = apiUsageState;
    }

    @Generated
    public long getCurrentCycleTs() {
        return this.currentCycleTs;
    }

    @Generated
    public long getNextCycleTs() {
        return this.nextCycleTs;
    }

    @Generated
    public long getCurrentHourTs() {
        return this.currentHourTs;
    }

    @Generated
    public void setGaugeReportInterval(long gaugeReportInterval) {
        this.gaugeReportInterval = gaugeReportInterval;
    }
}

