/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.exception;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.msg.tools.MaxPayloadSizeExceededException;
import org.thingsboard.server.common.msg.tools.TbRateLimitsException;
import org.thingsboard.server.exception.ThingsboardCredentialsExpiredResponse;
import org.thingsboard.server.exception.ThingsboardCredentialsViolationResponse;
import org.thingsboard.server.exception.ThingsboardErrorResponse;
import org.thingsboard.server.service.security.exception.AuthMethodNotSupportedException;
import org.thingsboard.server.service.security.exception.JwtExpiredTokenException;
import org.thingsboard.server.service.security.exception.UserPasswordExpiredException;
import org.thingsboard.server.service.security.exception.UserPasswordNotValidException;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RestControllerAdvice
public class ThingsboardErrorResponseHandler
extends ResponseEntityExceptionHandler
implements AccessDeniedHandler,
ErrorController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThingsboardErrorResponseHandler.class);
    private static final Map<HttpStatus, ThingsboardErrorCode> statusToErrorCodeMap = new HashMap();
    private static final Map<ThingsboardErrorCode, HttpStatus> errorCodeToStatusMap;

    private static ThingsboardErrorCode statusToErrorCode(HttpStatus status) {
        return statusToErrorCodeMap.getOrDefault(status, ThingsboardErrorCode.GENERAL);
    }

    private static HttpStatus errorCodeToStatus(ThingsboardErrorCode errorCode) {
        return errorCodeToStatusMap.getOrDefault(errorCode, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @RequestMapping(value={"/error"})
    public ResponseEntity<Object> handleError(HttpServletRequest request) {
        HttpStatus httpStatus = Optional.ofNullable(request.getAttribute("jakarta.servlet.error.status_code")).map(status -> HttpStatus.resolve((int)Integer.parseInt(status.toString()))).orElse(HttpStatus.INTERNAL_SERVER_ERROR);
        String errorMessage = Optional.ofNullable(request.getAttribute("jakarta.servlet.error.exception")).map(e -> ExceptionUtils.getMessage((Throwable)((Throwable)e))).orElse(httpStatus.getReasonPhrase());
        return new ResponseEntity((Object)ThingsboardErrorResponse.of((String)errorMessage, (ThingsboardErrorCode)ThingsboardErrorResponseHandler.statusToErrorCode((HttpStatus)httpStatus), (HttpStatus)httpStatus), (HttpStatusCode)httpStatus);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (!response.isCommitted()) {
            response.setContentType("application/json");
            response.setStatus(HttpStatus.FORBIDDEN.value());
            JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardErrorResponse.of((String)"You don't have permission to perform this operation!", (ThingsboardErrorCode)ThingsboardErrorCode.PERMISSION_DENIED, (HttpStatus)HttpStatus.FORBIDDEN));
        }
    }

    @ExceptionHandler(value={Exception.class})
    public void handle(Exception exception, HttpServletResponse response) {
        log.debug("Processing exception {}", (Object)exception.getMessage(), (Object)exception);
        if (!response.isCommitted()) {
            try {
                response.setContentType("application/json");
                if (exception instanceof ThingsboardException) {
                    ThingsboardException thingsboardException = (ThingsboardException)((Object)exception);
                    if (thingsboardException.getErrorCode() == ThingsboardErrorCode.SUBSCRIPTION_VIOLATION) {
                        this.handleSubscriptionException((ThingsboardException)((Object)exception), response);
                    } else if (thingsboardException.getErrorCode() == ThingsboardErrorCode.DATABASE) {
                        this.handleDatabaseException(thingsboardException.getCause(), response);
                    } else {
                        this.handleThingsboardException((ThingsboardException)((Object)exception), response);
                    }
                } else if (exception instanceof TbRateLimitsException) {
                    this.handleRateLimitException(response, (TbRateLimitsException)((Object)exception));
                } else if (exception instanceof AccessDeniedException) {
                    this.handleAccessDeniedException(response);
                } else if (exception instanceof AuthenticationException) {
                    this.handleAuthenticationException((AuthenticationException)((Object)exception), response);
                } else if (exception instanceof MaxPayloadSizeExceededException) {
                    this.handleMaxPayloadSizeExceededException(response, (MaxPayloadSizeExceededException)exception);
                } else if (exception instanceof DataAccessException) {
                    DataAccessException e = (DataAccessException)exception;
                    this.handleDatabaseException((Throwable)e, response);
                } else {
                    response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                    JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardErrorResponse.of((String)exception.getMessage(), (ThingsboardErrorCode)ThingsboardErrorCode.GENERAL, (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
            catch (IOException e) {
                log.error("Can't handle exception", (Throwable)e);
            }
        }
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body, HttpHeaders headers, HttpStatusCode statusCode, WebRequest request) {
        if (HttpStatus.INTERNAL_SERVER_ERROR.equals((Object)statusCode)) {
            request.setAttribute("jakarta.servlet.error.exception", (Object)ex, 0);
        }
        ThingsboardErrorCode errorCode = ThingsboardErrorResponseHandler.statusToErrorCode((HttpStatus)((HttpStatus)statusCode));
        return new ResponseEntity((Object)ThingsboardErrorResponse.of((String)ex.getMessage(), (ThingsboardErrorCode)errorCode, (HttpStatus)((HttpStatus)statusCode)), (MultiValueMap)headers, statusCode);
    }

    private void handleThingsboardException(ThingsboardException thingsboardException, HttpServletResponse response) throws IOException {
        ThingsboardErrorCode errorCode = thingsboardException.getErrorCode();
        HttpStatus status = ThingsboardErrorResponseHandler.errorCodeToStatus((ThingsboardErrorCode)errorCode);
        response.setStatus(status.value());
        JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardErrorResponse.of((String)thingsboardException.getMessage(), (ThingsboardErrorCode)errorCode, (HttpStatus)status));
    }

    private void handleRateLimitException(HttpServletResponse response, TbRateLimitsException exception) throws IOException {
        response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
        String message = "Too many requests for current " + exception.getEntityType().name().toLowerCase() + "!";
        JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardErrorResponse.of((String)message, (ThingsboardErrorCode)ThingsboardErrorCode.TOO_MANY_REQUESTS, (HttpStatus)HttpStatus.TOO_MANY_REQUESTS));
    }

    private void handleMaxPayloadSizeExceededException(HttpServletResponse response, MaxPayloadSizeExceededException exception) throws IOException {
        response.setStatus(HttpStatus.PAYLOAD_TOO_LARGE.value());
        JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardErrorResponse.of((String)exception.getMessage(), (ThingsboardErrorCode)ThingsboardErrorCode.BAD_REQUEST_PARAMS, (HttpStatus)HttpStatus.PAYLOAD_TOO_LARGE));
    }

    private void handleSubscriptionException(ThingsboardException subscriptionException, HttpServletResponse response) throws IOException {
        response.setStatus(HttpStatus.FORBIDDEN.value());
        JacksonUtil.writeValue((Writer)response.getWriter(), (Object)JacksonUtil.fromBytes((byte[])((HttpClientErrorException)subscriptionException.getCause()).getResponseBodyAsByteArray(), Object.class));
    }

    private void handleDatabaseException(Throwable databaseException, HttpServletResponse response) throws IOException {
        ThingsboardErrorResponse errorResponse;
        if (databaseException instanceof ConstraintViolationException) {
            errorResponse = ThingsboardErrorResponse.of((String)ExceptionUtils.getRootCause((Throwable)databaseException).getMessage(), (ThingsboardErrorCode)ThingsboardErrorCode.BAD_REQUEST_PARAMS, (HttpStatus)HttpStatus.BAD_REQUEST);
        } else {
            log.warn("Database error: {} - {}", (Object)databaseException.getClass().getSimpleName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)databaseException));
            errorResponse = ThingsboardErrorResponse.of((String)"Database error", (ThingsboardErrorCode)ThingsboardErrorCode.DATABASE, (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        this.writeResponse(errorResponse, response);
    }

    private void handleAccessDeniedException(HttpServletResponse response) throws IOException {
        response.setStatus(HttpStatus.FORBIDDEN.value());
        JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardErrorResponse.of((String)"You don't have permission to perform this operation!", (ThingsboardErrorCode)ThingsboardErrorCode.PERMISSION_DENIED, (HttpStatus)HttpStatus.FORBIDDEN));
    }

    private void handleAuthenticationException(AuthenticationException authenticationException, HttpServletResponse response) throws IOException {
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        if (authenticationException instanceof BadCredentialsException || authenticationException instanceof UsernameNotFoundException) {
            JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardErrorResponse.of((String)"Invalid username or password", (ThingsboardErrorCode)ThingsboardErrorCode.AUTHENTICATION, (HttpStatus)HttpStatus.UNAUTHORIZED));
        } else if (authenticationException instanceof DisabledException) {
            JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardErrorResponse.of((String)"User account is not active", (ThingsboardErrorCode)ThingsboardErrorCode.AUTHENTICATION, (HttpStatus)HttpStatus.UNAUTHORIZED));
        } else if (authenticationException instanceof LockedException) {
            JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardErrorResponse.of((String)"User account is locked due to security policy", (ThingsboardErrorCode)ThingsboardErrorCode.AUTHENTICATION, (HttpStatus)HttpStatus.UNAUTHORIZED));
        } else if (authenticationException instanceof JwtExpiredTokenException) {
            JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardErrorResponse.of((String)"Token has expired", (ThingsboardErrorCode)ThingsboardErrorCode.JWT_TOKEN_EXPIRED, (HttpStatus)HttpStatus.UNAUTHORIZED));
        } else if (authenticationException instanceof AuthMethodNotSupportedException) {
            JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardErrorResponse.of((String)authenticationException.getMessage(), (ThingsboardErrorCode)ThingsboardErrorCode.AUTHENTICATION, (HttpStatus)HttpStatus.UNAUTHORIZED));
        } else if (authenticationException instanceof UserPasswordExpiredException) {
            UserPasswordExpiredException expiredException = (UserPasswordExpiredException)authenticationException;
            String resetToken = expiredException.getResetToken();
            JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardCredentialsExpiredResponse.of((String)expiredException.getMessage(), (String)resetToken));
        } else if (authenticationException instanceof UserPasswordNotValidException) {
            UserPasswordNotValidException expiredException = (UserPasswordNotValidException)authenticationException;
            JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardCredentialsViolationResponse.of((String)expiredException.getMessage()));
        } else {
            JacksonUtil.writeValue((Writer)response.getWriter(), (Object)ThingsboardErrorResponse.of((String)"Authentication failed", (ThingsboardErrorCode)ThingsboardErrorCode.AUTHENTICATION, (HttpStatus)HttpStatus.UNAUTHORIZED));
        }
    }

    private void writeResponse(ThingsboardErrorResponse errorResponse, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setStatus(errorResponse.getStatus().intValue());
        JacksonUtil.writeValue((Writer)response.getWriter(), (Object)errorResponse);
    }

    static {
        statusToErrorCodeMap.put(HttpStatus.BAD_REQUEST, ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        statusToErrorCodeMap.put(HttpStatus.UNAUTHORIZED, ThingsboardErrorCode.AUTHENTICATION);
        statusToErrorCodeMap.put(HttpStatus.FORBIDDEN, ThingsboardErrorCode.PERMISSION_DENIED);
        statusToErrorCodeMap.put(HttpStatus.NOT_FOUND, ThingsboardErrorCode.ITEM_NOT_FOUND);
        statusToErrorCodeMap.put(HttpStatus.METHOD_NOT_ALLOWED, ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        statusToErrorCodeMap.put(HttpStatus.NOT_ACCEPTABLE, ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        statusToErrorCodeMap.put(HttpStatus.UNSUPPORTED_MEDIA_TYPE, ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        statusToErrorCodeMap.put(HttpStatus.TOO_MANY_REQUESTS, ThingsboardErrorCode.TOO_MANY_REQUESTS);
        statusToErrorCodeMap.put(HttpStatus.INTERNAL_SERVER_ERROR, ThingsboardErrorCode.GENERAL);
        statusToErrorCodeMap.put(HttpStatus.SERVICE_UNAVAILABLE, ThingsboardErrorCode.GENERAL);
        errorCodeToStatusMap = new HashMap();
        errorCodeToStatusMap.put(ThingsboardErrorCode.GENERAL, HttpStatus.INTERNAL_SERVER_ERROR);
        errorCodeToStatusMap.put(ThingsboardErrorCode.AUTHENTICATION, HttpStatus.UNAUTHORIZED);
        errorCodeToStatusMap.put(ThingsboardErrorCode.JWT_TOKEN_EXPIRED, HttpStatus.UNAUTHORIZED);
        errorCodeToStatusMap.put(ThingsboardErrorCode.CREDENTIALS_EXPIRED, HttpStatus.UNAUTHORIZED);
        errorCodeToStatusMap.put(ThingsboardErrorCode.PERMISSION_DENIED, HttpStatus.FORBIDDEN);
        errorCodeToStatusMap.put(ThingsboardErrorCode.INVALID_ARGUMENTS, HttpStatus.BAD_REQUEST);
        errorCodeToStatusMap.put(ThingsboardErrorCode.BAD_REQUEST_PARAMS, HttpStatus.BAD_REQUEST);
        errorCodeToStatusMap.put(ThingsboardErrorCode.ITEM_NOT_FOUND, HttpStatus.NOT_FOUND);
        errorCodeToStatusMap.put(ThingsboardErrorCode.TOO_MANY_REQUESTS, HttpStatus.TOO_MANY_REQUESTS);
        errorCodeToStatusMap.put(ThingsboardErrorCode.TOO_MANY_UPDATES, HttpStatus.TOO_MANY_REQUESTS);
        errorCodeToStatusMap.put(ThingsboardErrorCode.SUBSCRIPTION_VIOLATION, HttpStatus.FORBIDDEN);
        errorCodeToStatusMap.put(ThingsboardErrorCode.VERSION_CONFLICT, HttpStatus.CONFLICT);
    }
}

