/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.script.api.js.JsInvokeService;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.tenant.DebugTbRateLimits;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageDataIterableByTenant;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.rule.DefaultRuleChainCreateRequest;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainData;
import org.thingsboard.server.common.data.rule.RuleChainImportResult;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.rule.RuleChainOutputLabelsUsage;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.script.ScriptLanguage;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.rule.TbRuleChainService;
import org.thingsboard.server.service.script.RuleNodeJsScriptEngine;
import org.thingsboard.server.service.script.RuleNodeTbelScriptEngine;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class RuleChainController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleChainController.class);
    public static final String RULE_CHAIN_ID = "ruleChainId";
    public static final String RULE_NODE_ID = "ruleNodeId";
    private static final int DEFAULT_PAGE_SIZE = 1000;
    public static final int TIMEOUT = 20;
    private static final String RULE_CHAIN_DESCRIPTION = "The rule chain object is lightweight and contains general information about the rule chain. List of rule nodes and their connection is stored in a separate 'metadata' object.";
    private static final String RULE_CHAIN_METADATA_DESCRIPTION = "The metadata object contains information about the rule nodes and their connections.";
    private static final String TEST_SCRIPT_FUNCTION = "Execute the Script function and return the result. The format of request: \n\n```json\n{\n  \"script\": \"Your Function as String\",\n  \"scriptType\": \"One of: update, generate, filter, switch, json, string\",\n  \"argNames\": [\"msg\", \"metadata\", \"type\"],\n  \"msg\": \"{\\\"temperature\\\": 42}\", \n  \"metadata\": {\n    \"deviceName\": \"Device A\",\n    \"deviceType\": \"Thermometer\"\n  },\n  \"msgType\": \"POST_TELEMETRY_REQUEST\"\n}\n```\n\n Expected result JSON contains \"output\" and \"error\".";
    @Autowired
    protected TbRuleChainService tbRuleChainService;
    @Autowired
    private EventService eventService;
    @Autowired
    private JsInvokeService jsInvokeService;
    @Autowired(required=false)
    private TbelInvokeService tbelInvokeService;
    @Autowired(required=false)
    private ActorSystemContext actorContext;
    @Value(value="${actors.rule.chain.debug_mode_rate_limits_per_tenant.enabled}")
    private boolean debugPerTenantEnabled;
    @Value(value="${tbel.enabled:true}")
    private boolean tbelEnabled;

    @ApiOperation(value="Get Rule Chain (getRuleChainById)", notes="Fetch the Rule Chain object based on the provided Rule Chain Id. The rule chain object is lightweight and contains general information about the rule chain. List of rule nodes and their connection is stored in a separate 'metadata' object.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/ruleChain/{ruleChainId}"})
    public RuleChain getRuleChainById(@Parameter(description="A string value representing the rule chain id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="ruleChainId") String strRuleChainId) throws ThingsboardException {
        this.checkParameter(RULE_CHAIN_ID, strRuleChainId);
        RuleChainId ruleChainId = new RuleChainId(this.toUUID(strRuleChainId));
        return this.checkRuleChain(ruleChainId, Operation.READ);
    }

    @ApiOperation(value="Get Rule Chain output labels (getRuleChainOutputLabels)", notes="Fetch the unique labels for the \"output\" Rule Nodes that belong to the Rule Chain based on the provided Rule Chain Id. The rule chain object is lightweight and contains general information about the rule chain. List of rule nodes and their connection is stored in a separate 'metadata' object.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/ruleChain/{ruleChainId}/output/labels"})
    public Set<String> getRuleChainOutputLabels(@Parameter(description="A string value representing the rule chain id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="ruleChainId") String strRuleChainId) throws ThingsboardException {
        this.checkParameter(RULE_CHAIN_ID, strRuleChainId);
        RuleChainId ruleChainId = new RuleChainId(this.toUUID(strRuleChainId));
        this.checkRuleChain(ruleChainId, Operation.READ);
        return this.tbRuleChainService.getRuleChainOutputLabels(this.getTenantId(), ruleChainId);
    }

    @ApiOperation(value="Get output labels usage (getRuleChainOutputLabelsUsage)", notes="Fetch the list of rule chains and the relation types (labels) they use to process output of the current rule chain based on the provided Rule Chain Id. The rule chain object is lightweight and contains general information about the rule chain. List of rule nodes and their connection is stored in a separate 'metadata' object.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/ruleChain/{ruleChainId}/output/labels/usage"})
    public List<RuleChainOutputLabelsUsage> getRuleChainOutputLabelsUsage(@Parameter(description="A string value representing the rule chain id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="ruleChainId") String strRuleChainId) throws ThingsboardException {
        this.checkParameter(RULE_CHAIN_ID, strRuleChainId);
        RuleChainId ruleChainId = new RuleChainId(this.toUUID(strRuleChainId));
        this.checkRuleChain(ruleChainId, Operation.READ);
        return this.tbRuleChainService.getOutputLabelUsage(this.getCurrentUser().getTenantId(), ruleChainId);
    }

    @ApiOperation(value="Get Rule Chain (getRuleChainById)", notes="Fetch the Rule Chain Metadata object based on the provided Rule Chain Id. The metadata object contains information about the rule nodes and their connections.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/ruleChain/{ruleChainId}/metadata"})
    public RuleChainMetaData getRuleChainMetaData(@Parameter(description="A string value representing the rule chain id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="ruleChainId") String strRuleChainId) throws ThingsboardException {
        this.checkParameter(RULE_CHAIN_ID, strRuleChainId);
        RuleChainId ruleChainId = new RuleChainId(this.toUUID(strRuleChainId));
        this.checkRuleChain(ruleChainId, Operation.READ);
        return this.ruleChainService.loadRuleChainMetaData(this.getTenantId(), ruleChainId);
    }

    @ApiOperation(value="Create Or Update Rule Chain (saveRuleChain)", notes="Create or update the Rule Chain. When creating Rule Chain, platform generates Rule Chain Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Rule Chain Id will be present in the response. Specify existing Rule Chain id to update the rule chain. Referencing non-existing rule chain Id will cause 'Not Found' error.\n\nThe rule chain object is lightweight and contains general information about the rule chain. List of rule nodes and their connection is stored in a separate 'metadata' object.Remove 'id', 'tenantId' from the request body example (below) to create new Rule Chain entity.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/ruleChain"})
    public RuleChain saveRuleChain(@Parameter(description="A JSON value representing the rule chain.") @org.springframework.web.bind.annotation.RequestBody RuleChain ruleChain) throws Exception {
        ruleChain.setTenantId(this.getCurrentUser().getTenantId());
        this.checkEntity((EntityId)ruleChain.getId(), (HasTenantId)ruleChain, Resource.RULE_CHAIN);
        return (RuleChain)this.tbRuleChainService.save((Object)ruleChain, this.getCurrentUser());
    }

    @ApiOperation(value="Create Default Rule Chain", notes="Create rule chain from template, based on the specified name in the request. Creates the rule chain based on the template that is used to create root rule chain. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/ruleChain/device/default"})
    public RuleChain saveRuleChain(@Parameter(description="A JSON value representing the request.") @org.springframework.web.bind.annotation.RequestBody DefaultRuleChainCreateRequest request) throws Exception {
        this.checkNotNull((Object)request);
        this.checkParameter(request.getName(), "name");
        return this.tbRuleChainService.saveDefaultByName(this.getTenantId(), request, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Set Root Rule Chain (setRootRuleChain)", notes="Makes the rule chain to be root rule chain. Updates previous root rule chain as well. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/ruleChain/{ruleChainId}/root"})
    public RuleChain setRootRuleChain(@Parameter(description="A string value representing the rule chain id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="ruleChainId") String strRuleChainId) throws ThingsboardException {
        this.checkParameter(RULE_CHAIN_ID, strRuleChainId);
        RuleChainId ruleChainId = new RuleChainId(this.toUUID(strRuleChainId));
        RuleChain ruleChain = this.checkRuleChain(ruleChainId, Operation.WRITE);
        return this.tbRuleChainService.setRootRuleChain(this.getTenantId(), ruleChain, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Update Rule Chain Metadata", notes="Updates the rule chain metadata. The metadata object contains information about the rule nodes and their connections.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/ruleChain/metadata"})
    public RuleChainMetaData saveRuleChainMetaData(@Parameter(description="A JSON value representing the rule chain metadata.") @org.springframework.web.bind.annotation.RequestBody RuleChainMetaData ruleChainMetaData, @Parameter(description="Update related rule nodes.") @RequestParam(value="updateRelated", required=false, defaultValue="true") boolean updateRelated) throws Exception {
        ConcurrentMap debugPerTenantLimits;
        DebugTbRateLimits debugTbRateLimits;
        TenantId tenantId = this.getTenantId();
        if (this.debugPerTenantEnabled && (debugTbRateLimits = (DebugTbRateLimits)(debugPerTenantLimits = this.actorContext.getDebugPerTenantLimits()).getOrDefault(tenantId, null)) != null) {
            debugPerTenantLimits.remove(tenantId, debugTbRateLimits);
        }
        RuleChain ruleChain = this.checkRuleChain(ruleChainMetaData.getRuleChainId(), Operation.WRITE);
        return this.tbRuleChainService.saveRuleChainMetaData(tenantId, ruleChain, ruleChainMetaData, updateRelated, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Rule Chains (getRuleChains)", notes="Returns a page of Rule Chains owned by tenant. The rule chain object is lightweight and contains general information about the rule chain. List of rule nodes and their connection is stored in a separate 'metadata' object.You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/ruleChains"}, params={"pageSize", "page"})
    public PageData<RuleChain> getRuleChains(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Rule chain type (CORE or EDGE)", schema=@Schema(allowableValues={"CORE", "EDGE"})) @RequestParam(value="type", required=false) String typeStr, @Parameter(description="The case insensitive 'substring' filter based on the rule chain name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "root"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        RuleChainType type = RuleChainType.CORE;
        if (StringUtils.isNotBlank((String)typeStr)) {
            type = RuleChainType.valueOf((String)typeStr);
        }
        return (PageData)this.checkNotNull((Object)this.ruleChainService.findTenantRuleChainsByType(tenantId, type, pageLink));
    }

    @ApiOperation(value="Delete rule chain (deleteRuleChain)", notes="Deletes the rule chain. Referencing non-existing rule chain Id will cause an error. Referencing rule chain that is used in the device profiles will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/ruleChain/{ruleChainId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteRuleChain(@Parameter(description="A string value representing the rule chain id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="ruleChainId") String strRuleChainId) throws ThingsboardException {
        this.checkParameter(RULE_CHAIN_ID, strRuleChainId);
        RuleChainId ruleChainId = new RuleChainId(this.toUUID(strRuleChainId));
        RuleChain ruleChain = this.checkRuleChain(ruleChainId, Operation.DELETE);
        this.tbRuleChainService.delete((Object)ruleChain, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get latest input message (getLatestRuleNodeDebugInput)", notes="Gets the input message from the debug events for specified Rule Chain Id. Referencing non-existing rule chain Id will cause an error. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/ruleNode/{ruleNodeId}/debugIn"})
    public JsonNode getLatestRuleNodeDebugInput(@Parameter(description="A string value representing the rule node id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="ruleNodeId") String strRuleNodeId) throws ThingsboardException {
        this.checkParameter(RULE_NODE_ID, strRuleNodeId);
        RuleNodeId ruleNodeId = new RuleNodeId(this.toUUID(strRuleNodeId));
        this.checkRuleNode(ruleNodeId, Operation.READ);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return Optional.ofNullable(this.eventService.findLatestDebugRuleNodeInEvent(tenantId, (EntityId)ruleNodeId)).map(EventInfo::getBody).orElse(null);
    }

    @ApiOperation(value="Is TBEL script executor enabled", notes="Returns 'True' if the TBEL script execution is enabled\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/ruleChain/tbelEnabled"})
    public Boolean isTbelEnabled() {
        return this.tbelEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Test Script function", notes="Execute the Script function and return the result. The format of request: \n\n```json\n{\n  \"script\": \"Your Function as String\",\n  \"scriptType\": \"One of: update, generate, filter, switch, json, string\",\n  \"argNames\": [\"msg\", \"metadata\", \"type\"],\n  \"msg\": \"{\\\"temperature\\\": 42}\", \n  \"metadata\": {\n    \"deviceName\": \"Device A\",\n    \"deviceType\": \"Thermometer\"\n  },\n  \"msgType\": \"POST_TELEMETRY_REQUEST\"\n}\n```\n\n Expected result JSON contains \"output\" and \"error\".\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/ruleChain/testScript"})
    public JsonNode testScript(@Parameter(description="Script language: JS or TBEL") @RequestParam(required=false) ScriptLanguage scriptLang, @RequestBody(description="Test JS request. See API call description above.") @org.springframework.web.bind.annotation.RequestBody JsonNode inputParams) {
        String script = inputParams.get("script").asText();
        String scriptType = inputParams.get("scriptType").asText();
        JsonNode argNamesJson = inputParams.get("argNames");
        String[] argNames = (String[])JacksonUtil.treeToValue((JsonNode)argNamesJson, String[].class);
        String data = inputParams.get("msg").asText();
        JsonNode metadataJson = inputParams.get("metadata");
        Map metadata = (Map)JacksonUtil.convertValue((Object)metadataJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        String msgType = inputParams.get("msgType").asText();
        String output = "";
        String errorText = "";
        RuleNodeJsScriptEngine engine = null;
        try {
            if (scriptLang == null) {
                scriptLang = ScriptLanguage.JS;
            }
            if (ScriptLanguage.JS.equals((Object)scriptLang)) {
                engine = new RuleNodeJsScriptEngine(this.getTenantId(), this.jsInvokeService, script, argNames);
            } else {
                if (this.tbelInvokeService == null) {
                    throw new IllegalArgumentException("TBEL script engine is disabled!");
                }
                engine = new RuleNodeTbelScriptEngine(this.getTenantId(), this.tbelInvokeService, script, argNames);
            }
            TbMsg inMsg = TbMsg.newMsg().type(msgType).copyMetaData(new TbMsgMetaData(metadata)).dataType(TbMsgDataType.JSON).data(data).build();
            output = switch (scriptType) {
                case "update" -> this.msgToOutput((List)engine.executeUpdateAsync(inMsg).get(20L, TimeUnit.SECONDS));
                case "generate" -> this.msgToOutput((TbMsg)engine.executeGenerateAsync(inMsg).get(20L, TimeUnit.SECONDS));
                case "filter" -> Boolean.toString((Boolean)engine.executeFilterAsync(inMsg).get(20L, TimeUnit.SECONDS));
                case "switch" -> JacksonUtil.toString((Object)engine.executeSwitchAsync(inMsg).get(20L, TimeUnit.SECONDS));
                case "json" -> JacksonUtil.toString((Object)engine.executeJsonAsync(inMsg).get(20L, TimeUnit.SECONDS));
                case "string" -> (String)engine.executeToStringAsync(inMsg).get(20L, TimeUnit.SECONDS);
                default -> throw new IllegalArgumentException("Unsupported script type: " + scriptType);
            };
        }
        catch (Exception e) {
            log.error("Error evaluating JS function", (Throwable)e);
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            errorText = (String)ObjectUtils.firstNonNull((Object[])new String[]{rootCause.getMessage(), e.getMessage(), e.getClass().getSimpleName()});
        }
        finally {
            if (engine != null) {
                engine.destroy();
            }
        }
        return JacksonUtil.newObjectNode().put("output", output).put("error", errorText);
    }

    @ApiOperation(value="Export Rule Chains", notes="Exports all tenant rule chains as one JSON.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/ruleChains/export"}, params={"limit"})
    public RuleChainData exportRuleChains(@Parameter(description="A limit of rule chains to export.", required=true) @RequestParam(value="limit") int limit) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = new PageLink(limit);
        return (RuleChainData)this.checkNotNull((Object)this.ruleChainService.exportTenantRuleChains(tenantId, pageLink));
    }

    @ApiOperation(value="Import Rule Chains", notes="Imports all tenant rule chains as one JSON.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/ruleChains/import"})
    public List<RuleChainImportResult> importRuleChains(@Parameter(description="A JSON value representing the rule chains.") @org.springframework.web.bind.annotation.RequestBody RuleChainData ruleChainData, @Parameter(description="Enables overwrite for existing rule chains with the same name.") @RequestParam(required=false, defaultValue="false") boolean overwrite) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return this.ruleChainService.importTenantRuleChains(tenantId, ruleChainData, overwrite, arg_0 -> ((TbRuleChainService)this.tbRuleChainService).updateRuleNodeConfiguration(arg_0));
    }

    private String msgToOutput(TbMsg msg) {
        JsonNode resultNode = this.convertMsgToOut(msg);
        return JacksonUtil.toString((Object)resultNode);
    }

    private String msgToOutput(List<TbMsg> msgs) {
        ArrayNode resultNode;
        if (msgs.size() > 1) {
            resultNode = JacksonUtil.newArrayNode();
            for (TbMsg msg : msgs) {
                JsonNode convertedData = this.convertMsgToOut(msg);
                resultNode.add(convertedData);
            }
        } else {
            resultNode = this.convertMsgToOut(msgs.get(0));
        }
        return JacksonUtil.toString((Object)resultNode);
    }

    private JsonNode convertMsgToOut(TbMsg msg) {
        ObjectNode msgData = JacksonUtil.newObjectNode();
        if (!StringUtils.isEmpty((String)msg.getData())) {
            msgData.set("msg", JacksonUtil.toJsonNode((String)msg.getData()));
        }
        Map metadata = msg.getMetaData().getData();
        msgData.set("metadata", JacksonUtil.valueToTree((Object)metadata));
        msgData.put("msgType", msg.getType());
        return msgData;
    }

    @ApiOperation(value="Assign rule chain to edge (assignRuleChainToEdge)", notes="Creates assignment of an existing rule chain to an instance of The Edge. Assignment works in async way - first, notification event pushed to edge service queue on platform. Second, remote edge service will receive a copy of assignment rule chain (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once rule chain will be delivered to edge service, it's going to start processing messages locally. \n\nOnly rule chain with type 'EDGE' can be assigned to edge.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/edge/{edgeId}/ruleChain/{ruleChainId}"})
    public RuleChain assignRuleChainToEdge(@PathVariable(value="edgeId") String strEdgeId, @PathVariable(value="ruleChainId") String strRuleChainId) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        this.checkParameter(RULE_CHAIN_ID, strRuleChainId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.WRITE);
        RuleChainId ruleChainId = new RuleChainId(this.toUUID(strRuleChainId));
        RuleChain ruleChain = this.checkRuleChain(ruleChainId, Operation.READ);
        return this.tbRuleChainService.assignRuleChainToEdge(this.getTenantId(), ruleChain, edge, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Unassign rule chain from edge (unassignRuleChainFromEdge)", notes="Clears assignment of the rule chain to the edge. Unassignment works in async way - first, 'unassign' notification event pushed to edge queue on platform. Second, remote edge service will receive an 'unassign' command to remove rule chain (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once 'unassign' command will be delivered to edge service, it's going to remove rule chain locally.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/edge/{edgeId}/ruleChain/{ruleChainId}"})
    public RuleChain unassignRuleChainFromEdge(@PathVariable(value="edgeId") String strEdgeId, @PathVariable(value="ruleChainId") String strRuleChainId) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        this.checkParameter(RULE_CHAIN_ID, strRuleChainId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.WRITE);
        RuleChainId ruleChainId = new RuleChainId(this.toUUID(strRuleChainId));
        RuleChain ruleChain = this.checkRuleChain(ruleChainId, Operation.READ);
        return this.tbRuleChainService.unassignRuleChainFromEdge(this.getTenantId(), ruleChain, edge, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Edge Rule Chains (getEdgeRuleChains)", notes="Returns a page of Rule Chains assigned to the specified edge. The rule chain object is lightweight and contains general information about the rule chain. List of rule nodes and their connection is stored in a separate 'metadata' object.You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/edge/{edgeId}/ruleChains"}, params={"pageSize", "page"})
    public PageData<RuleChain> getEdgeRuleChains(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the rule chain name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "root"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        this.checkEdgeId(edgeId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.ruleChainService.findRuleChainsByTenantIdAndEdgeId(tenantId, edgeId, pageLink));
    }

    @ApiOperation(value="Set Edge Template Root Rule Chain (setEdgeTemplateRootRuleChain)", notes="Makes the rule chain to be root rule chain for any new edge that will be created. Does not update root rule chain for already created edges. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/ruleChain/{ruleChainId}/edgeTemplateRoot"})
    public RuleChain setEdgeTemplateRootRuleChain(@Parameter(description="A string value representing the rule chain id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="ruleChainId") String strRuleChainId) throws ThingsboardException {
        this.checkParameter(RULE_CHAIN_ID, strRuleChainId);
        RuleChainId ruleChainId = new RuleChainId(this.toUUID(strRuleChainId));
        RuleChain ruleChain = this.checkRuleChain(ruleChainId, Operation.WRITE);
        return this.tbRuleChainService.setEdgeTemplateRootRuleChain(this.getTenantId(), ruleChain, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Set Auto Assign To Edge Rule Chain (setAutoAssignToEdgeRuleChain)", notes="Makes the rule chain to be automatically assigned for any new edge that will be created. Does not assign this rule chain for already created edges. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/ruleChain/{ruleChainId}/autoAssignToEdge"})
    public RuleChain setAutoAssignToEdgeRuleChain(@Parameter(description="A string value representing the rule chain id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="ruleChainId") String strRuleChainId) throws ThingsboardException {
        this.checkParameter(RULE_CHAIN_ID, strRuleChainId);
        RuleChainId ruleChainId = new RuleChainId(this.toUUID(strRuleChainId));
        RuleChain ruleChain = this.checkRuleChain(ruleChainId, Operation.WRITE);
        return this.tbRuleChainService.setAutoAssignToEdgeRuleChain(this.getTenantId(), ruleChain, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Unset Auto Assign To Edge Rule Chain (unsetAutoAssignToEdgeRuleChain)", notes="Removes the rule chain from the list of rule chains that are going to be automatically assigned for any new edge that will be created. Does not unassign this rule chain for already assigned edges. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/ruleChain/{ruleChainId}/autoAssignToEdge"})
    public RuleChain unsetAutoAssignToEdgeRuleChain(@Parameter(description="A string value representing the rule chain id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="ruleChainId") String strRuleChainId) throws ThingsboardException {
        this.checkParameter(RULE_CHAIN_ID, strRuleChainId);
        RuleChainId ruleChainId = new RuleChainId(this.toUUID(strRuleChainId));
        RuleChain ruleChain = this.checkRuleChain(ruleChainId, Operation.WRITE);
        return this.tbRuleChainService.unsetAutoAssignToEdgeRuleChain(this.getTenantId(), ruleChain, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Auto Assign To Edge Rule Chains (getAutoAssignToEdgeRuleChains)", notes="Returns a list of Rule Chains that will be assigned to a newly created edge. The rule chain object is lightweight and contains general information about the rule chain. List of rule nodes and their connection is stored in a separate 'metadata' object.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/ruleChain/autoAssignToEdgeRuleChains"})
    public List<RuleChain> getAutoAssignToEdgeRuleChains() throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        ArrayList<RuleChain> result = new ArrayList<RuleChain>();
        PageDataIterableByTenant autoAssignRuleChainsIterator = new PageDataIterableByTenant((arg_0, arg_1) -> ((RuleChainService)this.ruleChainService).findAutoAssignToEdgeRuleChainsByTenantId(arg_0, arg_1), tenantId, 1000);
        for (RuleChain ruleChain : autoAssignRuleChainsIterator) {
            result.add(ruleChain);
        }
        return (List)this.checkNotNull(result);
    }
}

