/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.SaveOtaPackageInfoRequest;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.ota.ChecksumAlgorithm;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.ota.TbOtaPackageService;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class OtaPackageController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OtaPackageController.class);
    private final TbOtaPackageService tbOtaPackageService;
    public static final String OTA_PACKAGE_ID = "otaPackageId";
    public static final String CHECKSUM_ALGORITHM = "checksumAlgorithm";

    @ApiOperation(value="Download OTA Package (downloadOtaPackage)", notes="Download OTA Package based on the provided OTA Package Id.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority( 'TENANT_ADMIN')")
    @GetMapping(value={"/otaPackage/{otaPackageId}/download"})
    public ResponseEntity<org.springframework.core.io.Resource> downloadOtaPackage(@Parameter(description="A string value representing the ota package id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="otaPackageId") String strOtaPackageId) throws ThingsboardException {
        this.checkParameter(OTA_PACKAGE_ID, strOtaPackageId);
        OtaPackageId otaPackageId = new OtaPackageId(this.toUUID(strOtaPackageId));
        OtaPackage otaPackage = this.checkOtaPackageId(otaPackageId, Operation.READ);
        if (otaPackage.hasUrl()) {
            return ResponseEntity.badRequest().build();
        }
        ByteArrayResource resource = new ByteArrayResource(otaPackage.getData().array());
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=" + otaPackage.getFileName()})).header("x-filename", new String[]{otaPackage.getFileName()})).contentLength(resource.contentLength()).contentType(this.parseMediaType(otaPackage.getContentType())).body((Object)resource);
    }

    @ApiOperation(value="Get OTA Package Info (getOtaPackageInfoById)", notes="Fetch the OTA Package Info object based on the provided OTA Package Id. OTA Package Info is a lightweight object that includes main information about the OTA Package excluding the heavyweight data. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/otaPackage/info/{otaPackageId}"})
    public OtaPackageInfo getOtaPackageInfoById(@Parameter(description="A string value representing the ota package id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="otaPackageId") String strOtaPackageId) throws ThingsboardException {
        this.checkParameter(OTA_PACKAGE_ID, strOtaPackageId);
        OtaPackageId otaPackageId = new OtaPackageId(this.toUUID(strOtaPackageId));
        return (OtaPackageInfo)this.checkNotNull((Object)this.otaPackageService.findOtaPackageInfoById(this.getTenantId(), otaPackageId));
    }

    @ApiOperation(value="Get OTA Package (getOtaPackageById)", notes="Fetch the OTA Package object based on the provided OTA Package Id. The server checks that the OTA Package is owned by the same tenant. OTA Package is a heavyweight object that includes main information about the OTA Package and also data. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/otaPackage/{otaPackageId}"})
    public OtaPackage getOtaPackageById(@Parameter(description="A string value representing the ota package id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="otaPackageId") String strOtaPackageId) throws ThingsboardException {
        this.checkParameter(OTA_PACKAGE_ID, strOtaPackageId);
        OtaPackageId otaPackageId = new OtaPackageId(this.toUUID(strOtaPackageId));
        return this.checkOtaPackageId(otaPackageId, Operation.READ);
    }

    @ApiOperation(value="Create Or Update OTA Package Info (saveOtaPackageInfo)", notes="Create or update the OTA Package Info. When creating OTA Package Info, platform generates OTA Package id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created OTA Package id will be present in the response. Specify existing OTA Package id to update the OTA Package Info. Referencing non-existing OTA Package Id will cause 'Not Found' error. \n\nOTA Package combination of the title with the version is unique in the scope of tenant. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/otaPackage"})
    public OtaPackageInfo saveOtaPackageInfo(@Parameter(description="A JSON value representing the OTA Package.") @RequestBody SaveOtaPackageInfoRequest otaPackageInfo) throws Exception {
        otaPackageInfo.setTenantId(this.getTenantId());
        this.checkEntity((EntityId)otaPackageInfo.getId(), (HasTenantId)otaPackageInfo, Resource.OTA_PACKAGE);
        return this.tbOtaPackageService.save(otaPackageInfo, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Save OTA Package data (saveOtaPackageData)", notes="Update the OTA Package. Adds the date to the existing OTA Package Info\n\nAvailable for users with 'TENANT_ADMIN' authority.", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="multipart/form-data")}))
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/otaPackage/{otaPackageId}"}, consumes={"multipart/form-data"})
    public OtaPackageInfo saveOtaPackageData(@Parameter(description="A string value representing the ota package id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="otaPackageId") String strOtaPackageId, @Parameter(description="OTA Package checksum. For example, '0xd87f7e0c'") @RequestParam(required=false) String checksum, @Parameter(description="OTA Package checksum algorithm.", schema=@Schema(allowableValues={"MD5", "SHA256", "SHA384", "SHA512", "CRC32", "MURMUR3_32", "MURMUR3_128"})) @RequestParam(value="checksumAlgorithm") String checksumAlgorithmStr, @Parameter(description="OTA Package data.") @RequestPart MultipartFile file) throws Exception {
        this.checkParameter(OTA_PACKAGE_ID, strOtaPackageId);
        this.checkParameter(CHECKSUM_ALGORITHM, checksumAlgorithmStr);
        OtaPackageId otaPackageId = new OtaPackageId(this.toUUID(strOtaPackageId));
        OtaPackageInfo otaPackageInfo = this.checkOtaPackageInfoId(otaPackageId, Operation.READ);
        ChecksumAlgorithm checksumAlgorithm = ChecksumAlgorithm.valueOf((String)checksumAlgorithmStr.toUpperCase());
        byte[] data = file.getBytes();
        return this.tbOtaPackageService.saveOtaPackageData(otaPackageInfo, checksum, checksumAlgorithm, data, file.getOriginalFilename(), file.getContentType(), (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get OTA Package Infos (getOtaPackages)", notes="Returns a page of OTA Package Info objects owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. OTA Package Info is a lightweight object that includes main information about the OTA Package excluding the heavyweight data. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/otaPackages"})
    public PageData<OtaPackageInfo> getOtaPackages(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the ota package title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "type", "title", "version", "tag", "url", "fileName", "dataSize", "checksum"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.otaPackageService.findTenantOtaPackagesByTenantId(this.getTenantId(), pageLink));
    }

    @ApiOperation(value="Get OTA Package Infos (getOtaPackages)", notes="Returns a page of OTA Package Info objects owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. OTA Package Info is a lightweight object that includes main information about the OTA Package excluding the heavyweight data. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/otaPackages/{deviceProfileId}/{type}"})
    public PageData<OtaPackageInfo> getOtaPackages(@Parameter(description="A string value representing the device profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceProfileId") String strDeviceProfileId, @Parameter(description="OTA Package type.", schema=@Schema(allowableValues={"FIRMWARE", "SOFTWARE"})) @PathVariable(value="type") String strType, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the ota package title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "type", "title", "version", "tag", "url", "fileName", "dataSize", "checksum"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("deviceProfileId", strDeviceProfileId);
        this.checkParameter("type", strType);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.otaPackageService.findTenantOtaPackagesByTenantIdAndDeviceProfileIdAndTypeAndHasData(this.getTenantId(), new DeviceProfileId(this.toUUID(strDeviceProfileId)), OtaPackageType.valueOf((String)strType), pageLink));
    }

    @ApiOperation(value="Delete OTA Package (deleteOtaPackage)", notes="Deletes the OTA Package. Referencing non-existing OTA Package Id will cause an error. Can't delete the OTA Package if it is referenced by existing devices or device profile.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/otaPackage/{otaPackageId}"})
    public void deleteOtaPackage(@Parameter(description="A string value representing the ota package id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="otaPackageId") String strOtaPackageId) throws ThingsboardException {
        this.checkParameter(OTA_PACKAGE_ID, strOtaPackageId);
        OtaPackageId otaPackageId = new OtaPackageId(this.toUUID(strOtaPackageId));
        OtaPackageInfo otaPackageInfo = this.checkOtaPackageInfoId(otaPackageId, Operation.DELETE);
        this.tbOtaPackageService.delete(otaPackageInfo, (User)this.getCurrentUser());
    }

    @ConstructorProperties(value={"tbOtaPackageService"})
    @Generated
    public OtaPackageController(TbOtaPackageService tbOtaPackageService) {
        this.tbOtaPackageService = tbOtaPackageService;
    }
}

