/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HomeDashboardInfo;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.Views;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.MobileAppId;
import org.thingsboard.server.common.data.mobile.LoginMobileInfo;
import org.thingsboard.server.common.data.mobile.UserMobileInfo;
import org.thingsboard.server.common.data.mobile.app.MobileApp;
import org.thingsboard.server.common.data.mobile.app.MobileAppVersionInfo;
import org.thingsboard.server.common.data.mobile.app.StoreInfo;
import org.thingsboard.server.common.data.mobile.bundle.MobileAppBundle;
import org.thingsboard.server.common.data.mobile.layout.MobilePage;
import org.thingsboard.server.common.data.oauth2.PlatformType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.mobile.MobileAppService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.mobile.TbMobileAppService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class MobileAppController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileAppController.class);
    private final TbMobileAppService tbMobileAppService;

    @ApiOperation(value="Get mobile app login info (getLoginMobileInfo)")
    @GetMapping(value={"/noauth/mobile"})
    public LoginMobileInfo getLoginMobileInfo(@Parameter(description="Mobile application package name") @RequestParam String pkgName, @Parameter(description="Platform type", schema=@Schema(allowableValues={"ANDROID", "IOS"})) @RequestParam PlatformType platform) {
        List oauth2Clients = this.oAuth2ClientService.findOAuth2ClientLoginInfosByMobilePkgNameAndPlatformType(pkgName, platform);
        MobileApp mobileApp = this.mobileAppService.findMobileAppByPkgNameAndPlatformType(pkgName, platform);
        StoreInfo storeInfo = Optional.ofNullable(mobileApp).map(MobileApp::getStoreInfo).orElse(null);
        MobileAppVersionInfo versionInfo = Optional.ofNullable(mobileApp).map(MobileApp::getVersionInfo).orElse(null);
        return new LoginMobileInfo(oauth2Clients, storeInfo, versionInfo);
    }

    @ApiOperation(value="Get user mobile app basic info (getUserMobileInfo)", notes="\n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN','TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/mobile"})
    public UserMobileInfo getUserMobileInfo(@Parameter(description="Mobile application package name") @RequestParam String pkgName, @Parameter(description="Platform type", schema=@Schema(allowableValues={"ANDROID", "IOS"})) @RequestParam PlatformType platform) throws ThingsboardException, JsonProcessingException {
        SecurityUser securityUser = this.getCurrentUser();
        User user = this.userService.findUserById(securityUser.getTenantId(), securityUser.getId());
        HomeDashboardInfo homeDashboardInfo = securityUser.isSystemAdmin() ? null : this.getHomeDashboardInfo(securityUser, user.getAdditionalInfo());
        MobileAppBundle mobileAppBundle = this.mobileAppBundleService.findMobileAppBundleByPkgNameAndPlatform(securityUser.getTenantId(), pkgName, platform);
        MobileApp mobileApp = this.mobileAppService.findMobileAppByPkgNameAndPlatformType(pkgName, platform);
        StoreInfo storeInfo = Optional.ofNullable(mobileApp).map(MobileApp::getStoreInfo).orElse(null);
        MobileAppVersionInfo versionInfo = Optional.ofNullable(mobileApp).map(MobileApp::getVersionInfo).orElse(null);
        return new UserMobileInfo(user, storeInfo, versionInfo, homeDashboardInfo, this.getVisiblePages(mobileAppBundle));
    }

    @ApiOperation(value="Save Or update Mobile app (saveMobileApp)", notes="Create or update the Mobile app. When creating mobile app, platform generates Mobile App Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Mobile App Id will be present in the response. Specify existing Mobile App Id to update the mobile app. Referencing non-existing Mobile App Id will cause 'Not Found' error.\n\nThe pair of mobile app package name and platform type is unique for entire platform setup.\n\n\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/mobile/app"})
    public MobileApp saveMobileApp(@Parameter(description="A JSON value representing the Mobile Application.", required=true) @RequestBody @Valid MobileApp mobileApp) throws Exception {
        mobileApp.setTenantId(this.getTenantId());
        this.checkEntity((EntityId)((MobileAppId)mobileApp.getId()), (HasTenantId)mobileApp, Resource.MOBILE_APP);
        return this.tbMobileAppService.save(mobileApp, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get mobile app infos (getTenantMobileAppInfos)", notes="\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/mobile/app"})
    public PageData<MobileApp> getTenantMobileApps(@Parameter(description="Platform type: ANDROID or IOS") @RequestParam(required=false) PlatformType platformType, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filter based on app's name") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.mobileAppService.findMobileAppsByTenantId(this.getTenantId(), platformType, pageLink);
    }

    @ApiOperation(value="Get mobile info by id (getMobileAppInfoById)", notes="\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/mobile/app/{id}"})
    public MobileApp getMobileAppById(@PathVariable UUID id) throws ThingsboardException {
        MobileAppId mobileAppId = new MobileAppId(id);
        return (MobileApp)this.checkEntityId((EntityId)mobileAppId, (arg_0, arg_1) -> ((MobileAppService)this.mobileAppService).findMobileAppById(arg_0, arg_1), Operation.READ);
    }

    @ApiOperation(value="Delete Mobile App by ID (deleteMobileApp)", notes="Deletes Mobile App by ID. Referencing non-existing mobile app Id will cause an error.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @DeleteMapping(value={"/mobile/app/{id}"})
    public void deleteMobileApp(@PathVariable UUID id) throws Exception {
        MobileAppId mobileAppId = new MobileAppId(id);
        MobileApp mobileApp = this.checkMobileAppId(mobileAppId, Operation.DELETE);
        this.tbMobileAppService.delete(mobileApp, (User)this.getCurrentUser());
    }

    private JsonNode getVisiblePages(MobileAppBundle mobileAppBundle) throws JsonProcessingException {
        if (mobileAppBundle != null && mobileAppBundle.getLayoutConfig() != null) {
            List mobilePages = mobileAppBundle.getLayoutConfig().getPages().stream().filter(MobilePage::isVisible).collect(Collectors.toList());
            return JacksonUtil.toJsonNode((String)JacksonUtil.writeValueAsViewIgnoringNullFields(mobilePages, Views.Public.class));
        }
        return null;
    }

    @ConstructorProperties(value={"tbMobileAppService"})
    @Generated
    public MobileAppController(TbMobileAppService tbMobileAppService) {
        this.tbMobileAppService = tbMobileAppService;
    }
}

