/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.MobileAppBundleId;
import org.thingsboard.server.common.data.mobile.bundle.MobileAppBundle;
import org.thingsboard.server.common.data.mobile.bundle.MobileAppBundleInfo;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.mobile.MobileAppBundleService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.mobile.TbMobileAppBundleService;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class MobileAppBundleController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileAppBundleController.class);
    private final TbMobileAppBundleService tbMobileAppBundleService;

    @ApiOperation(value="Save Or update Mobile app bundle (saveMobileAppBundle)", notes="Create or update the Mobile app bundle that represents tha pair of ANDROID and IOS app and mobile settings like oauth2 clients, self-registration and layout configuration.When creating mobile app bundle, platform generates Mobile App Bundle Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Mobile App Bundle Id will be present in the response. Referencing non-existing Mobile App Bundle Id will cause 'Not Found' error.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/mobile/bundle"})
    public MobileAppBundle saveMobileAppBundle(@Parameter(description="A JSON value representing the Mobile Application Bundle.", required=true) @RequestBody @Valid MobileAppBundle mobileAppBundle, @Parameter(description="A list of oauth2 client ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(name="oauth2ClientIds", required=false) UUID[] ids) throws Exception {
        mobileAppBundle.setTenantId(this.getTenantId());
        this.checkEntity((EntityId)((MobileAppBundleId)mobileAppBundle.getId()), (HasTenantId)mobileAppBundle, Resource.MOBILE_APP_BUNDLE);
        return this.tbMobileAppBundleService.save(mobileAppBundle, this.getOAuth2ClientIds(ids), (User)this.getCurrentUser());
    }

    @ApiOperation(value="Update oauth2 clients (updateOauth2Clients)", notes="Update oauth2 clients of the specified mobile app bundle.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PutMapping(value={"/mobile/bundle/{id}/oauth2Clients"})
    public void updateOauth2Clients(@PathVariable UUID id, @RequestBody UUID[] clientIds) throws ThingsboardException {
        MobileAppBundleId mobileAppBundleId = new MobileAppBundleId(id);
        MobileAppBundle mobileAppBundle = this.checkMobileAppBundleId(mobileAppBundleId, Operation.WRITE);
        List oAuth2ClientIds = this.getOAuth2ClientIds(clientIds);
        this.tbMobileAppBundleService.updateOauth2Clients(mobileAppBundle, oAuth2ClientIds, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get mobile app bundle infos (getTenantMobileAppBundleInfos)", notes="\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/mobile/bundle/infos"})
    public PageData<MobileAppBundleInfo> getTenantMobileAppBundleInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filter based on app's name") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.mobileAppBundleService.findMobileAppBundleInfosByTenantId(this.getTenantId(), pageLink);
    }

    @ApiOperation(value="Get mobile app bundle info by id (getMobileAppBundleInfoById)", notes="\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/mobile/bundle/info/{id}"})
    public MobileAppBundleInfo getMobileAppBundleInfoById(@PathVariable UUID id) throws ThingsboardException {
        MobileAppBundleId mobileAppBundleId = new MobileAppBundleId(id);
        return (MobileAppBundleInfo)this.checkEntityId((EntityId)mobileAppBundleId, (arg_0, arg_1) -> ((MobileAppBundleService)this.mobileAppBundleService).findMobileAppBundleInfoById(arg_0, arg_1), Operation.READ);
    }

    @ApiOperation(value="Delete Mobile App Bundle by ID (deleteMobileAppBundle)", notes="Deletes Mobile App Bundle by ID. Referencing non-existing mobile app bundle Id will cause an error.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @DeleteMapping(value={"/mobile/bundle/{id}"})
    public void deleteMobileAppBundle(@PathVariable UUID id) throws Exception {
        MobileAppBundleId mobileAppBundleId = new MobileAppBundleId(id);
        MobileAppBundle mobileAppBundle = this.checkMobileAppBundleId(mobileAppBundleId, Operation.DELETE);
        this.tbMobileAppBundleService.delete(mobileAppBundle, (User)this.getCurrentUser());
    }

    @ConstructorProperties(value={"tbMobileAppBundleService"})
    @Generated
    public MobileAppBundleController(TbMobileAppBundleService tbMobileAppBundleService) {
        this.tbMobileAppBundleService = tbMobileAppBundleService;
    }
}

