/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.rule.engine.api.JobManager;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.JobId;
import org.thingsboard.server.common.data.job.Job;
import org.thingsboard.server.common.data.job.JobFilter;
import org.thingsboard.server.common.data.job.JobStatus;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.permission.Operation;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class JobController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobController.class);
    private final JobManager jobManager;

    @GetMapping(value={"/job/{id}"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public Job getJobById(@PathVariable UUID id) throws ThingsboardException {
        JobId jobId = new JobId(id);
        return this.checkJobId(jobId, Operation.READ);
    }

    @GetMapping(value={"/jobs"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public PageData<Job> getJobs(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filter based on job's description") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder, @RequestParam(required=false) List<JobType> types, @RequestParam(required=false) List<JobStatus> statuses, @RequestParam(required=false) List<UUID> entities, @RequestParam(required=false) Long startTime, @RequestParam(required=false) Long endTime) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        JobFilter filter = JobFilter.builder().types(types).statuses(statuses).entities(entities).startTime(startTime).endTime(endTime).build();
        return this.jobService.findJobsByFilter(this.getTenantId(), filter, pageLink);
    }

    @PostMapping(value={"/job/{id}/cancel"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public void cancelJob(@PathVariable UUID id) throws ThingsboardException {
        JobId jobId = new JobId(id);
        this.checkJobId(jobId, Operation.WRITE);
        this.jobManager.cancelJob(this.getTenantId(), jobId);
    }

    @PostMapping(value={"/job/{id}/reprocess"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public void reprocessJob(@PathVariable UUID id) throws ThingsboardException {
        JobId jobId = new JobId(id);
        this.checkJobId(jobId, Operation.WRITE);
        this.jobManager.reprocessJob(this.getTenantId(), jobId);
    }

    @DeleteMapping(value={"/job/{id}"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public void deleteJob(@PathVariable UUID id) throws ThingsboardException {
        JobId jobId = new JobId(id);
        this.checkJobId(jobId, Operation.DELETE);
        this.jobService.deleteJob(this.getTenantId(), jobId);
    }

    @ConstructorProperties(value={"jobManager"})
    @Generated
    public JobController(JobManager jobManager) {
        this.jobManager = jobManager;
    }
}

