/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.google.common.util.concurrent.ListenableFuture;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.EntityViewInfo;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.entityview.EntityViewSearchQuery;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.entityview.TbEntityViewService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class EntityViewController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityViewController.class);
    public final TbEntityViewService tbEntityViewService;
    public static final String ENTITY_VIEW_ID = "entityViewId";

    @ApiOperation(value="Get entity view (getEntityViewById)", notes="Fetch the EntityView object based on the provided entity view id. Entity Views limit the degree of exposure of the Device or Asset telemetry and attributes to the Customers. Every Entity View references exactly one entity (device or asset) and defines telemetry and attribute keys that will be visible to the assigned Customer. As a Tenant Administrator you are able to create multiple EVs per Device or Asset and assign them to different Customers. See the 'Model' tab for more details.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/entityView/{entityViewId}"}, method={RequestMethod.GET})
    @ResponseBody
    public EntityView getEntityViewById(@Parameter(description="A string value representing the entity view id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityViewId") String strEntityViewId) throws ThingsboardException {
        this.checkParameter(ENTITY_VIEW_ID, strEntityViewId);
        return this.checkEntityViewId(new EntityViewId(this.toUUID(strEntityViewId)), Operation.READ);
    }

    @ApiOperation(value="Get Entity View info (getEntityViewInfoById)", notes="Fetch the Entity View info object based on the provided Entity View Id. Entity Views Info extends the Entity View with customer title and 'is public' flag. Entity Views limit the degree of exposure of the Device or Asset telemetry and attributes to the Customers. Every Entity View references exactly one entity (device or asset) and defines telemetry and attribute keys that will be visible to the assigned Customer. As a Tenant Administrator you are able to create multiple EVs per Device or Asset and assign them to different Customers. See the 'Model' tab for more details.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/entityView/info/{entityViewId}"}, method={RequestMethod.GET})
    @ResponseBody
    public EntityViewInfo getEntityViewInfoById(@Parameter(description="A string value representing the entity view id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityViewId") String strEntityViewId) throws ThingsboardException {
        this.checkParameter(ENTITY_VIEW_ID, strEntityViewId);
        EntityViewId entityViewId = new EntityViewId(this.toUUID(strEntityViewId));
        return this.checkEntityViewInfoId(entityViewId, Operation.READ);
    }

    @ApiOperation(value="Save or update entity view (saveEntityView)", notes="Entity Views limit the degree of exposure of the Device or Asset telemetry and attributes to the Customers. Every Entity View references exactly one entity (device or asset) and defines telemetry and attribute keys that will be visible to the assigned Customer. As a Tenant Administrator you are able to create multiple EVs per Device or Asset and assign them to different Customers. See the 'Model' tab for more details.Remove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new Entity View entity.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/entityView"}, method={RequestMethod.POST})
    @ResponseBody
    public EntityView saveEntityView(@Parameter(description="A JSON object representing the entity view.") @RequestBody EntityView entityView) throws Exception {
        entityView.setTenantId(this.getCurrentUser().getTenantId());
        EntityView existingEntityView = null;
        if (entityView.getId() == null) {
            this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ENTITY_VIEW, Operation.CREATE, null, (HasTenantId)entityView);
        } else {
            existingEntityView = this.checkEntityViewId(entityView.getId(), Operation.WRITE);
        }
        return this.tbEntityViewService.save(entityView, existingEntityView, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Delete entity view (deleteEntityView)", notes="Delete the EntityView object based on the provided entity view id. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/entityView/{entityViewId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteEntityView(@Parameter(description="A string value representing the entity view id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityViewId") String strEntityViewId) throws ThingsboardException {
        this.checkParameter(ENTITY_VIEW_ID, strEntityViewId);
        EntityViewId entityViewId = new EntityViewId(this.toUUID(strEntityViewId));
        EntityView entityView = this.checkEntityViewId(entityViewId, Operation.DELETE);
        this.tbEntityViewService.delete(entityView, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Entity View by name (getTenantEntityView)", notes="Fetch the Entity View object based on the tenant id and entity view name. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/entityViews"}, params={"entityViewName"}, method={RequestMethod.GET})
    @ResponseBody
    public EntityView getTenantEntityView(@Parameter(description="Entity View name") @RequestParam String entityViewName) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (EntityView)this.checkNotNull((Object)this.entityViewService.findEntityViewByTenantIdAndName(tenantId, entityViewName));
    }

    @ApiOperation(value="Assign Entity View to customer (assignEntityViewToCustomer)", notes="Creates assignment of the Entity View to customer. Customer will be able to query Entity View afterwards.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customer/{customerId}/entityView/{entityViewId}"}, method={RequestMethod.POST})
    @ResponseBody
    public EntityView assignEntityViewToCustomer(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId, @Parameter(description="A string value representing the entity view id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityViewId") String strEntityViewId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        this.checkParameter(ENTITY_VIEW_ID, strEntityViewId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        Customer customer = this.checkCustomerId(customerId, Operation.READ);
        EntityViewId entityViewId = new EntityViewId(this.toUUID(strEntityViewId));
        this.checkEntityViewId(entityViewId, Operation.ASSIGN_TO_CUSTOMER);
        return this.tbEntityViewService.assignEntityViewToCustomer(this.getTenantId(), entityViewId, customer, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Unassign Entity View from customer (unassignEntityViewFromCustomer)", notes="Clears assignment of the Entity View to customer. Customer will not be able to query Entity View afterwards.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customer/entityView/{entityViewId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public EntityView unassignEntityViewFromCustomer(@Parameter(description="A string value representing the entity view id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityViewId") String strEntityViewId) throws ThingsboardException {
        this.checkParameter(ENTITY_VIEW_ID, strEntityViewId);
        EntityViewId entityViewId = new EntityViewId(this.toUUID(strEntityViewId));
        EntityView entityView = this.checkEntityViewId(entityViewId, Operation.UNASSIGN_FROM_CUSTOMER);
        if (entityView.getCustomerId() == null || entityView.getCustomerId().getId().equals(ModelConstants.NULL_UUID)) {
            throw new IncorrectParameterException("Entity View isn't assigned to any customer!");
        }
        Customer customer = this.checkCustomerId(entityView.getCustomerId(), Operation.READ);
        return this.tbEntityViewService.unassignEntityViewFromCustomer(this.getTenantId(), entityViewId, customer, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Customer Entity Views (getCustomerEntityViews)", notes="Returns a page of Entity View objects assigned to customer. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/entityViews"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<EntityView> getCustomerEntityViews(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="\n\n## Entity View Filter\n\nAllows to filter entity views based on their type and the **'starts with'** expression over their name. For example, this entity filter selects all 'Concrete Mixer' entity views which name starts with 'CAT':\n\n```json\n{\n  \"type\": \"entityViewType\",\n  \"entityViewType\": \"Concrete Mixer\",\n  \"entityViewNameFilter\": \"CAT\"\n}\n```") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the entity view name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewsByTenantIdAndCustomerIdAndType(tenantId, customerId, pageLink, type));
        }
        return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewsByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Customer Entity View info (getCustomerEntityViewInfos)", notes="Returns a page of Entity View info objects assigned to customer. Entity Views limit the degree of exposure of the Device or Asset telemetry and attributes to the Customers. Every Entity View references exactly one entity (device or asset) and defines telemetry and attribute keys that will be visible to the assigned Customer. As a Tenant Administrator you are able to create multiple EVs per Device or Asset and assign them to different Customers. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/entityViewInfos"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<EntityViewInfo> getCustomerEntityViewInfos(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="\n\n## Entity View Filter\n\nAllows to filter entity views based on their type and the **'starts with'** expression over their name. For example, this entity filter selects all 'Concrete Mixer' entity views which name starts with 'CAT':\n\n```json\n{\n  \"type\": \"entityViewType\",\n  \"entityViewType\": \"Concrete Mixer\",\n  \"entityViewNameFilter\": \"CAT\"\n}\n```") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the entity view name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantIdAndCustomerIdAndType(tenantId, customerId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Tenant Entity Views (getTenantEntityViews)", notes="Returns a page of entity views owned by tenant. Entity Views limit the degree of exposure of the Device or Asset telemetry and attributes to the Customers. Every Entity View references exactly one entity (device or asset) and defines telemetry and attribute keys that will be visible to the assigned Customer. As a Tenant Administrator you are able to create multiple EVs per Device or Asset and assign them to different Customers. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/entityViews"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<EntityView> getTenantEntityViews(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="\n\n## Entity View Filter\n\nAllows to filter entity views based on their type and the **'starts with'** expression over their name. For example, this entity filter selects all 'Concrete Mixer' entity views which name starts with 'CAT':\n\n```json\n{\n  \"type\": \"entityViewType\",\n  \"entityViewType\": \"Concrete Mixer\",\n  \"entityViewNameFilter\": \"CAT\"\n}\n```") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the entity view name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewByTenantIdAndType(tenantId, pageLink, type));
        }
        return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Tenant Entity Views (getTenantEntityViews)", notes="Returns a page of entity views info owned by tenant. Entity Views limit the degree of exposure of the Device or Asset telemetry and attributes to the Customers. Every Entity View references exactly one entity (device or asset) and defines telemetry and attribute keys that will be visible to the assigned Customer. As a Tenant Administrator you are able to create multiple EVs per Device or Asset and assign them to different Customers. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/entityViewInfos"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<EntityViewInfo> getTenantEntityViewInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="\n\n## Entity View Filter\n\nAllows to filter entity views based on their type and the **'starts with'** expression over their name. For example, this entity filter selects all 'Concrete Mixer' entity views which name starts with 'CAT':\n\n```json\n{\n  \"type\": \"entityViewType\",\n  \"entityViewType\": \"Concrete Mixer\",\n  \"entityViewNameFilter\": \"CAT\"\n}\n```") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the entity view name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantIdAndType(tenantId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.entityViewService.findEntityViewInfosByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Find related entity views (findByQuery)", notes="Returns all entity views that are related to the specific entity. The entity id, relation type, entity view types, depth of the search, and other query parameters defined using complex 'EntityViewSearchQuery' object. See 'Model' tab of the Parameters for more info.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/entityViews"}, method={RequestMethod.POST})
    @ResponseBody
    public List<EntityView> findByQuery(@Parameter(description="The entity view search query JSON") @RequestBody EntityViewSearchQuery query) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkNotNull((Object)query);
        this.checkNotNull((Object)query.getParameters());
        this.checkNotNull((Object)query.getEntityViewTypes());
        this.checkEntityId(query.getParameters().getEntityId(), Operation.READ);
        List<EntityView> entityViews = (List<EntityView>)this.checkNotNull((Object)((List)this.entityViewService.findEntityViewsByQuery(this.getTenantId(), query).get()));
        entityViews = entityViews.stream().filter(entityView -> {
            try {
                this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ENTITY_VIEW, Operation.READ, (EntityId)entityView.getId(), (HasTenantId)entityView);
                return true;
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).collect(Collectors.toList());
        return entityViews;
    }

    @ApiOperation(value="Get Entity View Types (getEntityViewTypes)", notes="Returns a set of unique entity view types based on entity views that are either owned by the tenant or assigned to the customer which user is performing the request.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/entityView/types"}, method={RequestMethod.GET})
    @ResponseBody
    public List<EntitySubtype> getEntityViewTypes() throws ThingsboardException, ExecutionException, InterruptedException {
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ListenableFuture entityViewTypes = this.entityViewService.findEntityViewTypesByTenantId(tenantId);
        return (List)this.checkNotNull((Object)((List)entityViewTypes.get()));
    }

    @ApiOperation(value="Make entity view publicly available (assignEntityViewToPublicCustomer)", notes="Entity View will be available for non-authorized (not logged-in) users. This is useful to create dashboards that you plan to share/embed on a publicly available website. However, users that are logged-in and belong to different tenant will not be able to access the entity view.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customer/public/entityView/{entityViewId}"}, method={RequestMethod.POST})
    @ResponseBody
    public EntityView assignEntityViewToPublicCustomer(@Parameter(description="A string value representing the entity view id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="entityViewId") String strEntityViewId) throws ThingsboardException {
        this.checkParameter(ENTITY_VIEW_ID, strEntityViewId);
        EntityViewId entityViewId = new EntityViewId(this.toUUID(strEntityViewId));
        this.checkEntityViewId(entityViewId, Operation.ASSIGN_TO_CUSTOMER);
        return this.tbEntityViewService.assignEntityViewToPublicCustomer(this.getTenantId(), entityViewId, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Assign entity view to edge (assignEntityViewToEdge)", notes="Creates assignment of an existing entity view to an instance of The Edge. Assignment works in async way - first, notification event pushed to edge service queue on platform. Second, remote edge service will receive a copy of assignment entity view (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once entity view will be delivered to edge service, it's going to be available for usage on remote edge instance.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/edge/{edgeId}/entityView/{entityViewId}"}, method={RequestMethod.POST})
    @ResponseBody
    public EntityView assignEntityViewToEdge(@PathVariable(value="edgeId") String strEdgeId, @PathVariable(value="entityViewId") String strEntityViewId) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        this.checkParameter(ENTITY_VIEW_ID, strEntityViewId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.READ);
        EntityViewId entityViewId = new EntityViewId(this.toUUID(strEntityViewId));
        this.checkEntityViewId(entityViewId, Operation.READ);
        return this.tbEntityViewService.assignEntityViewToEdge(this.getTenantId(), this.getCurrentUser().getCustomerId(), entityViewId, edge, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Unassign entity view from edge (unassignEntityViewFromEdge)", notes="Clears assignment of the entity view to the edge. Unassignment works in async way - first, 'unassign' notification event pushed to edge queue on platform. Second, remote edge service will receive an 'unassign' command to remove entity view (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once 'unassign' command will be delivered to edge service, it's going to remove entity view locally.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/edge/{edgeId}/entityView/{entityViewId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public EntityView unassignEntityViewFromEdge(@PathVariable(value="edgeId") String strEdgeId, @PathVariable(value="entityViewId") String strEntityViewId) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        this.checkParameter(ENTITY_VIEW_ID, strEntityViewId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.READ);
        EntityViewId entityViewId = new EntityViewId(this.toUUID(strEntityViewId));
        EntityView entityView = this.checkEntityViewId(entityViewId, Operation.READ);
        return this.tbEntityViewService.unassignEntityViewFromEdge(this.getTenantId(), entityView.getCustomerId(), entityView, edge, (User)this.getCurrentUser());
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/edge/{edgeId}/entityViews"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<EntityView> getEdgeEntityViews(@PathVariable(value="edgeId") String strEdgeId, @RequestParam int pageSize, @RequestParam int page, @RequestParam(required=false) String type, @RequestParam(required=false) String textSearch, @RequestParam(required=false) String sortProperty, @RequestParam(required=false) String sortOrder, @RequestParam(required=false) Long startTime, @RequestParam(required=false) Long endTime) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        this.checkEdgeId(edgeId, Operation.READ);
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
        PageData nonFilteredResult = type != null && type.trim().length() > 0 ? this.entityViewService.findEntityViewsByTenantIdAndEdgeIdAndType(tenantId, edgeId, type, (PageLink)pageLink) : this.entityViewService.findEntityViewsByTenantIdAndEdgeId(tenantId, edgeId, (PageLink)pageLink);
        List filteredEntityViews = nonFilteredResult.getData().stream().filter(entityView -> {
            try {
                this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ENTITY_VIEW, Operation.READ, (EntityId)entityView.getId(), (HasTenantId)entityView);
                return true;
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).collect(Collectors.toList());
        PageData filteredResult = new PageData(filteredEntityViews, nonFilteredResult.getTotalPages(), nonFilteredResult.getTotalElements(), nonFilteredResult.hasNext());
        return (PageData)this.checkNotNull((Object)filteredResult);
    }

    @ConstructorProperties(value={"tbEntityViewService"})
    @Generated
    public EntityViewController(TbEntityViewService tbEntityViewService) {
        this.tbEntityViewService = tbEntityViewService;
    }
}

