/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.edge.EdgeEventService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.permission.Operation;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class EdgeEventController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdgeEventController.class);
    @Autowired
    private EdgeEventService edgeEventService;
    public static final String EDGE_ID = "edgeId";

    @ApiOperation(value="Get Edge Events (getEdgeEvents)", notes="Returns a page of edge events for the requested edge. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. ")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/edge/{edgeId}/events"})
    public PageData<EdgeEvent> getEdgeEvents(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the edge event type name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="Timestamp. Edge events with creation time before it won't be queried") @RequestParam(required=false) Long startTime, @Parameter(description="Timestamp. Edge events with creation time after it won't be queried") @RequestParam(required=false) Long endTime) throws ThingsboardException {
        this.checkParameter(EDGE_ID, strEdgeId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        this.checkEdgeId(edgeId, Operation.READ);
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
        return (PageData)this.checkNotNull((Object)this.edgeEventService.findEdgeEvents(tenantId, edgeId, Long.valueOf(0L), null, pageLink));
    }
}

