/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.domain.Domain;
import org.thingsboard.server.common.data.domain.DomainInfo;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DomainId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.domain.DomainService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.domain.TbDomainService;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class DomainController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DomainController.class);
    private final TbDomainService tbDomainService;

    @ApiOperation(value="Save or Update Domain (saveDomain)", notes="Create or update the Domain. When creating domain, platform generates Domain Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Domain Id will be present in the response. Specify existing Domain Id to update the domain. Referencing non-existing Domain Id will cause 'Not Found' error.\n\nDomain name is unique for entire platform setup.\n\n\n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN')")
    @PostMapping(value={"/domain"})
    public Domain saveDomain(@Parameter(description="A JSON value representing the Domain.", required=true) @RequestBody @Valid Domain domain, @Parameter(description="A list of oauth2 client registration ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(name="oauth2ClientIds", required=false) UUID[] ids) throws Exception {
        domain.setTenantId(this.getTenantId());
        this.checkEntity((EntityId)((DomainId)domain.getId()), (HasTenantId)domain, Resource.DOMAIN);
        return this.tbDomainService.save(domain, this.getOAuth2ClientIds(ids), (User)this.getCurrentUser());
    }

    @ApiOperation(value="Update oauth2 clients (updateOauth2Clients)", notes="Update oauth2 clients for the specified domain. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN')")
    @PutMapping(value={"/domain/{id}/oauth2Clients"})
    public void updateOauth2Clients(@PathVariable UUID id, @RequestBody UUID[] clientIds) throws ThingsboardException {
        DomainId domainId = new DomainId(id);
        Domain domain = this.checkDomainId(domainId, Operation.WRITE);
        List oAuth2ClientIds = this.getOAuth2ClientIds(clientIds);
        this.tbDomainService.updateOauth2Clients(domain, oAuth2ClientIds, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Domain infos (getTenantDomainInfos)", notes="\n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN')")
    @GetMapping(value={"/domain/infos"})
    public PageData<DomainInfo> getTenantDomainInfos(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filter based on domain's name") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getCurrentUser(), Resource.DOMAIN, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.domainService.findDomainInfosByTenantId(this.getTenantId(), pageLink);
    }

    @ApiOperation(value="Get Domain info by Id (getDomainInfoById)", notes="\n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN')")
    @GetMapping(value={"/domain/info/{id}"})
    public DomainInfo getDomainInfoById(@PathVariable UUID id) throws ThingsboardException {
        DomainId domainId = new DomainId(id);
        return (DomainInfo)this.checkEntityId((EntityId)domainId, (arg_0, arg_1) -> ((DomainService)this.domainService).findDomainInfoById(arg_0, arg_1), Operation.READ);
    }

    @ApiOperation(value="Delete Domain by ID (deleteDomain)", notes="Deletes Domain by ID. Referencing non-existing domain Id will cause an error.\n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @DeleteMapping(value={"/domain/{id}"})
    public void deleteDomain(@PathVariable UUID id) throws Exception {
        DomainId domainId = new DomainId(id);
        Domain domain = this.checkDomainId(domainId, Operation.DELETE);
        this.tbDomainService.delete(domain, (User)this.getCurrentUser());
    }

    @ConstructorProperties(value={"tbDomainService"})
    @Generated
    public DomainController(TbDomainService tbDomainService) {
        this.tbDomainService = tbDomainService;
    }
}

