/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HomeDashboard;
import org.thingsboard.server.common.data.HomeDashboardInfo;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.dashboard.TbDashboardService;
import org.thingsboard.server.service.resource.TbResourceService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class DashboardController
extends BaseController {
    private final TbDashboardService tbDashboardService;
    private final TbResourceService tbResourceService;
    public static final String DASHBOARD_ID = "dashboardId";
    private static final String HOME_DASHBOARD_ID = "homeDashboardId";
    private static final String HOME_DASHBOARD_HIDE_TOOLBAR = "homeDashboardHideToolbar";
    public static final String DASHBOARD_INFO_DEFINITION = "The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON.";
    public static final String DASHBOARD_DEFINITION = "The Dashboard object is a heavyweight object that contains information about the dashboard (e.g. title, image, assigned customers) and also configuration JSON (e.g. layouts, widgets, entity aliases).";
    public static final String HIDDEN_FOR_MOBILE = "Exclude dashboards that are hidden for mobile";
    @Value(value="${ui.dashboard.max_datapoints_limit}")
    private long maxDatapointsLimit;

    @ApiOperation(value="Get server time (getServerTime)", notes="Get the server time (milliseconds since January 1, 1970 UTC). Used to adjust view of the dashboards according to the difference between browser and server time.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboard/serverTime"})
    @ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", examples={@ExampleObject(value="1636023857137")})})
    public long getServerTime() throws ThingsboardException {
        return System.currentTimeMillis();
    }

    @ApiOperation(value="Get max data points limit (getMaxDatapointsLimit)", notes="Get the maximum number of data points that dashboard may request from the server per in a single subscription command. This value impacts the time window behavior. It impacts 'Max values' parameter in case user selects 'None' as 'Data aggregation function'. It also impacts the 'Grouping interval' in case of any other 'Data aggregation function' is selected. The actual value of the limit is configurable in the system configuration file.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboard/maxDatapointsLimit"})
    @ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", examples={@ExampleObject(value="5000")})})
    public long getMaxDatapointsLimit() throws ThingsboardException {
        return this.maxDatapointsLimit;
    }

    @ApiOperation(value="Get Dashboard Info (getDashboardInfoById)", notes="Get the information about the dashboard based on 'dashboardId' parameter. The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboard/info/{dashboardId}"})
    public DashboardInfo getDashboardInfoById(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId) throws ThingsboardException {
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        return this.checkDashboardInfoId(dashboardId, Operation.READ);
    }

    @ApiOperation(value="Get Dashboard (getDashboardById)", notes="Get the dashboard based on 'dashboardId' parameter. The Dashboard object is a heavyweight object that contains information about the dashboard (e.g. title, image, assigned customers) and also configuration JSON (e.g. layouts, widgets, entity aliases).\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboard/{dashboardId}"})
    public void getDashboardById(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId, @Parameter(description="Export used resources and replace resource links with resource metadata") @RequestParam(value="includeResources", required=false) boolean includeResources, @RequestHeader(name="Accept-Encoding", required=false) String acceptEncodingHeader, HttpServletResponse response) throws Exception {
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.READ);
        if (includeResources) {
            dashboard.setResources(this.tbResourceService.exportResources(dashboard, this.getCurrentUser()));
        }
        response.setContentType("application/json");
        this.compressResponseWithGzipIFAccepted(acceptEncodingHeader, response, JacksonUtil.writeValueAsBytes((Object)dashboard));
    }

    @ApiOperation(value="Create Or Update Dashboard (saveDashboard)", notes="Create or update the Dashboard. When creating dashboard, platform generates Dashboard Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Dashboard id will be present in the response. Specify existing Dashboard id to update the dashboard. Referencing non-existing dashboard Id will cause 'Not Found' error. Remove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new Dashboard entity. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/dashboard"})
    public void saveDashboard(@RequestBody(description="A JSON value representing the dashboard.") @org.springframework.web.bind.annotation.RequestBody Dashboard dashboard, @RequestHeader(name="Accept-Encoding", required=false) String acceptEncodingHeader, HttpServletResponse response) throws Exception {
        dashboard.setTenantId(this.getTenantId());
        this.checkEntity((EntityId)dashboard.getId(), (HasTenantId)dashboard, Resource.DASHBOARD);
        Dashboard savedDashboard = (Dashboard)this.tbDashboardService.save((Object)dashboard, this.getCurrentUser());
        response.setContentType("application/json");
        this.compressResponseWithGzipIFAccepted(acceptEncodingHeader, response, JacksonUtil.writeValueAsBytes((Object)savedDashboard));
    }

    @ApiOperation(value="Delete the Dashboard (deleteDashboard)", notes="Delete the Dashboard.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/dashboard/{dashboardId}"})
    public void deleteDashboard(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId) throws ThingsboardException {
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.DELETE);
        this.tbDashboardService.delete((Object)dashboard, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Assign the Dashboard (assignDashboardToCustomer)", notes="Assign the Dashboard to specified Customer or do nothing if the Dashboard is already assigned to that Customer. Returns the Dashboard object.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/customer/{customerId}/dashboard/{dashboardId}"})
    public Dashboard assignDashboardToCustomer(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId, @Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        Customer customer = this.checkCustomerId(customerId, Operation.READ);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.ASSIGN_TO_CUSTOMER);
        return this.tbDashboardService.assignDashboardToCustomer(dashboard, customer, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Unassign the Dashboard (unassignDashboardFromCustomer)", notes="Unassign the Dashboard from specified Customer or do nothing if the Dashboard is already assigned to that Customer. Returns the Dashboard object.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/customer/{customerId}/dashboard/{dashboardId}"})
    public Dashboard unassignDashboardFromCustomer(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId, @Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        Customer customer = this.checkCustomerId(customerId, Operation.READ);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.UNASSIGN_FROM_CUSTOMER);
        return this.tbDashboardService.unassignDashboardFromCustomer(dashboard, customer, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Update the Dashboard Customers (updateDashboardCustomers)", notes="Updates the list of Customers that this Dashboard is assigned to. Removes previous assignments to customers that are not in the provided list. Returns the Dashboard object. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/dashboard/{dashboardId}/customers"})
    public Dashboard updateDashboardCustomers(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId, @Parameter(description="JSON array with the list of customer ids, or empty to remove all customers") @org.springframework.web.bind.annotation.RequestBody(required=false) String[] strCustomerIds) throws ThingsboardException {
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.ASSIGN_TO_CUSTOMER);
        Set customerIds = this.customerIdFromStr(strCustomerIds);
        return this.tbDashboardService.updateDashboardCustomers(dashboard, customerIds, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Adds the Dashboard Customers (addDashboardCustomers)", notes="Adds the list of Customers to the existing list of assignments for the Dashboard. Keeps previous assignments to customers that are not in the provided list. Returns the Dashboard object.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/dashboard/{dashboardId}/customers/add"})
    public Dashboard addDashboardCustomers(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId, @Parameter(description="JSON array with the list of customer ids") @org.springframework.web.bind.annotation.RequestBody String[] strCustomerIds) throws ThingsboardException {
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.ASSIGN_TO_CUSTOMER);
        Set customerIds = this.customerIdFromStr(strCustomerIds);
        return this.tbDashboardService.addDashboardCustomers(dashboard, customerIds, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Remove the Dashboard Customers (removeDashboardCustomers)", notes="Removes the list of Customers from the existing list of assignments for the Dashboard. Keeps other assignments to customers that are not in the provided list. Returns the Dashboard object.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/dashboard/{dashboardId}/customers/remove"})
    public Dashboard removeDashboardCustomers(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId, @Parameter(description="JSON array with the list of customer ids") @org.springframework.web.bind.annotation.RequestBody String[] strCustomerIds) throws ThingsboardException {
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.UNASSIGN_FROM_CUSTOMER);
        Set customerIds = this.customerIdFromStr(strCustomerIds);
        return this.tbDashboardService.removeDashboardCustomers(dashboard, customerIds, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Assign the Dashboard to Public Customer (assignDashboardToPublicCustomer)", notes="Assigns the dashboard to a special, auto-generated 'Public' Customer. Once assigned, unauthenticated users may browse the dashboard. This method is useful if you like to embed the dashboard on public web pages to be available for users that are not logged in. Be aware that making the dashboard public does not mean that it automatically makes all devices and assets you use in the dashboard to be public.Use [assign Asset to Public Customer](#!/asset-controller/assignAssetToPublicCustomerUsingPOST) and [assign Device to Public Customer](#!/device-controller/assignDeviceToPublicCustomerUsingPOST) for this purpose. Returns the Dashboard object.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customer/public/dashboard/{dashboardId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Dashboard assignDashboardToPublicCustomer(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId) throws ThingsboardException {
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.ASSIGN_TO_CUSTOMER);
        return this.tbDashboardService.assignDashboardToPublicCustomer(dashboard, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Unassign the Dashboard from Public Customer (unassignDashboardFromPublicCustomer)", notes="Unassigns the dashboard from a special, auto-generated 'Public' Customer. Once unassigned, unauthenticated users may no longer browse the dashboard. Returns the Dashboard object.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customer/public/dashboard/{dashboardId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Dashboard unassignDashboardFromPublicCustomer(@Parameter(description="A string value representing the dashboard id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="dashboardId") String strDashboardId) throws ThingsboardException {
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.UNASSIGN_FROM_CUSTOMER);
        return this.tbDashboardService.unassignDashboardFromPublicCustomer(dashboard, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Tenant Dashboards by System Administrator (getTenantDashboards)", notes="Returns a page of dashboard info objects owned by tenant. The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('SYS_ADMIN')")
    @RequestMapping(value={"/tenant/{tenantId}/dashboards"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<DashboardInfo> getTenantDashboards(@Parameter(description="A string value representing the tenant id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="tenantId") String strTenantId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the dashboard title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        TenantId tenantId = TenantId.fromUUID((UUID)this.toUUID(strTenantId));
        this.checkTenantId(tenantId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return (PageData)this.checkNotNull((Object)this.dashboardService.findDashboardsByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Tenant Dashboards (getTenantDashboards)", notes="Returns a page of dashboard info objects owned by the tenant of a current user. The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/dashboards"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<DashboardInfo> getTenantDashboards(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Exclude dashboards that are hidden for mobile") @RequestParam(required=false) Boolean mobile, @Parameter(description="The case insensitive 'substring' filter based on the dashboard title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (mobile != null && mobile.booleanValue()) {
            return (PageData)this.checkNotNull((Object)this.dashboardService.findMobileDashboardsByTenantId(tenantId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.dashboardService.findDashboardsByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Customer Dashboards (getCustomerDashboards)", notes="Returns a page of dashboard info objects owned by the specified customer. The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/dashboards"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<DashboardInfo> getCustomerDashboards(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Exclude dashboards that are hidden for mobile") @RequestParam(required=false) Boolean mobile, @Parameter(description="The case insensitive 'substring' filter based on the dashboard title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (mobile != null && mobile.booleanValue()) {
            return (PageData)this.checkNotNull((Object)this.dashboardService.findMobileDashboardsByTenantIdAndCustomerId(tenantId, customerId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.dashboardService.findDashboardsByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Home Dashboard (getHomeDashboard)", notes="Returns the home dashboard object that is configured as 'homeDashboardId' parameter in the 'additionalInfo' of the User. If 'homeDashboardId' parameter is not set on the User level and the User has authority 'CUSTOMER_USER', check the same parameter for the corresponding Customer. If 'homeDashboardId' parameter is not set on the User and Customer levels then checks the same parameter for the Tenant that owns the user. The Dashboard object is a heavyweight object that contains information about the dashboard (e.g. title, image, assigned customers) and also configuration JSON (e.g. layouts, widgets, entity aliases).\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/dashboard/home"})
    public void getHomeDashboard(@RequestHeader(name="Accept-Encoding", required=false) String acceptEncodingHeader, HttpServletResponse response) throws Exception {
        SecurityUser securityUser = this.getCurrentUser();
        response.setContentType("application/json");
        if (securityUser.isSystemAdmin()) {
            return;
        }
        User user = this.userService.findUserById(securityUser.getTenantId(), securityUser.getId());
        JsonNode additionalInfo = user.getAdditionalInfo();
        HomeDashboard homeDashboard = this.extractHomeDashboardFromAdditionalInfo(additionalInfo);
        if (homeDashboard == null) {
            if (securityUser.isCustomerUser()) {
                Customer customer = this.customerService.findCustomerById(securityUser.getTenantId(), securityUser.getCustomerId());
                additionalInfo = customer.getAdditionalInfo();
                homeDashboard = this.extractHomeDashboardFromAdditionalInfo(additionalInfo);
            }
            if (homeDashboard == null) {
                Tenant tenant = this.tenantService.findTenantById(securityUser.getTenantId());
                additionalInfo = tenant.getAdditionalInfo();
                homeDashboard = this.extractHomeDashboardFromAdditionalInfo(additionalInfo);
            }
        }
        if (homeDashboard != null) {
            this.compressResponseWithGzipIFAccepted(acceptEncodingHeader, response, JacksonUtil.writeValueAsBytes((Object)homeDashboard));
        }
    }

    @ApiOperation(value="Get Home Dashboard Info (getHomeDashboardInfo)", notes="Returns the home dashboard info object that is configured as 'homeDashboardId' parameter in the 'additionalInfo' of the User. If 'homeDashboardId' parameter is not set on the User level and the User has authority 'CUSTOMER_USER', check the same parameter for the corresponding Customer. If 'homeDashboardId' parameter is not set on the User and Customer levels then checks the same parameter for the Tenant that owns the user. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/dashboard/home/info"}, method={RequestMethod.GET})
    @ResponseBody
    public HomeDashboardInfo getHomeDashboardInfo() throws ThingsboardException {
        SecurityUser securityUser = this.getCurrentUser();
        if (securityUser.isSystemAdmin()) {
            return null;
        }
        User user = this.userService.findUserById(securityUser.getTenantId(), securityUser.getId());
        JsonNode additionalInfo = user.getAdditionalInfo();
        return this.getHomeDashboardInfo(securityUser, additionalInfo);
    }

    @ApiOperation(value="Get Tenant Home Dashboard Info (getTenantHomeDashboardInfo)", notes="Returns the home dashboard info object that is configured as 'homeDashboardId' parameter in the 'additionalInfo' of the corresponding tenant. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/dashboard/home/info"}, method={RequestMethod.GET})
    @ResponseBody
    public HomeDashboardInfo getTenantHomeDashboardInfo() throws ThingsboardException {
        Tenant tenant = this.tenantService.findTenantById(this.getTenantId());
        JsonNode additionalInfo = tenant.getAdditionalInfo();
        DashboardId dashboardId = null;
        boolean hideDashboardToolbar = true;
        if (additionalInfo != null && additionalInfo.has(HOME_DASHBOARD_ID) && !additionalInfo.get(HOME_DASHBOARD_ID).isNull()) {
            String strDashboardId = additionalInfo.get(HOME_DASHBOARD_ID).asText();
            dashboardId = new DashboardId(this.toUUID(strDashboardId));
            if (additionalInfo.has(HOME_DASHBOARD_HIDE_TOOLBAR)) {
                hideDashboardToolbar = additionalInfo.get(HOME_DASHBOARD_HIDE_TOOLBAR).asBoolean();
            }
        }
        return new HomeDashboardInfo(dashboardId, hideDashboardToolbar);
    }

    @ApiOperation(value="Update Tenant Home Dashboard Info (getTenantHomeDashboardInfo)", notes="Update the home dashboard assignment for the current tenant. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/dashboard/home/info"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void setTenantHomeDashboardInfo(@Parameter(description="A JSON object that represents home dashboard id and other parameters", required=true) @org.springframework.web.bind.annotation.RequestBody HomeDashboardInfo homeDashboardInfo) throws ThingsboardException {
        Tenant tenant;
        JsonNode additionalInfo;
        if (homeDashboardInfo.getDashboardId() != null) {
            this.checkDashboardId(homeDashboardInfo.getDashboardId(), Operation.READ);
        }
        if (!((additionalInfo = (tenant = this.tenantService.findTenantById(this.getTenantId())).getAdditionalInfo()) instanceof ObjectNode)) {
            additionalInfo = JacksonUtil.newObjectNode();
        }
        if (homeDashboardInfo.getDashboardId() != null) {
            ((ObjectNode)additionalInfo).put(HOME_DASHBOARD_ID, homeDashboardInfo.getDashboardId().getId().toString());
            ((ObjectNode)additionalInfo).put(HOME_DASHBOARD_HIDE_TOOLBAR, homeDashboardInfo.isHideDashboardToolbar());
        } else {
            ((ObjectNode)additionalInfo).remove(HOME_DASHBOARD_ID);
            ((ObjectNode)additionalInfo).remove(HOME_DASHBOARD_HIDE_TOOLBAR);
        }
        tenant.setAdditionalInfo(additionalInfo);
        this.tenantService.saveTenant(tenant);
    }

    private HomeDashboard extractHomeDashboardFromAdditionalInfo(JsonNode additionalInfo) {
        try {
            if (additionalInfo != null && additionalInfo.has(HOME_DASHBOARD_ID) && !additionalInfo.get(HOME_DASHBOARD_ID).isNull()) {
                String strDashboardId = additionalInfo.get(HOME_DASHBOARD_ID).asText();
                DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
                Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.READ);
                boolean hideDashboardToolbar = true;
                if (additionalInfo.has(HOME_DASHBOARD_HIDE_TOOLBAR)) {
                    hideDashboardToolbar = additionalInfo.get(HOME_DASHBOARD_HIDE_TOOLBAR).asBoolean();
                }
                return new HomeDashboard(dashboard, hideDashboardToolbar);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @ApiOperation(value="Assign dashboard to edge (assignDashboardToEdge)", notes="Creates assignment of an existing dashboard to an instance of The Edge. Assignment works in async way - first, notification event pushed to edge service queue on platform. Second, remote edge service will receive a copy of assignment dashboard (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once dashboard will be delivered to edge service, it's going to be available for usage on remote edge instance.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/edge/{edgeId}/dashboard/{dashboardId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Dashboard assignDashboardToEdge(@PathVariable(value="edgeId") String strEdgeId, @PathVariable(value="dashboardId") String strDashboardId) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.READ);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        this.checkDashboardId(dashboardId, Operation.READ);
        return this.tbDashboardService.asignDashboardToEdge(this.getTenantId(), dashboardId, edge, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Unassign dashboard from edge (unassignDashboardFromEdge)", notes="Clears assignment of the dashboard to the edge. Unassignment works in async way - first, 'unassign' notification event pushed to edge queue on platform. Second, remote edge service will receive an 'unassign' command to remove dashboard (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once 'unassign' command will be delivered to edge service, it's going to remove dashboard locally.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/edge/{edgeId}/dashboard/{dashboardId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Dashboard unassignDashboardFromEdge(@PathVariable(value="edgeId") String strEdgeId, @PathVariable(value="dashboardId") String strDashboardId) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        this.checkParameter(DASHBOARD_ID, strDashboardId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.READ);
        DashboardId dashboardId = new DashboardId(this.toUUID(strDashboardId));
        Dashboard dashboard = this.checkDashboardId(dashboardId, Operation.READ);
        return this.tbDashboardService.unassignDashboardFromEdge(dashboard, edge, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Edge Dashboards (getEdgeDashboards)", notes="Returns a page of dashboard info objects assigned to the specified edge. The Dashboard Info object contains lightweight information about the dashboard (e.g. title, image, assigned customers) but does not contain the heavyweight configuration JSON. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/edge/{edgeId}/dashboards"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<DashboardInfo> getEdgeDashboards(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the dashboard title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        this.checkEdgeId(edgeId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        PageData nonFilteredResult = this.dashboardService.findDashboardsByTenantIdAndEdgeId(tenantId, edgeId, pageLink);
        List filteredDashboards = nonFilteredResult.getData().stream().filter(dashboardInfo -> {
            try {
                this.accessControlService.checkPermission(this.getCurrentUser(), Resource.DASHBOARD, Operation.READ, (EntityId)dashboardInfo.getId(), (HasTenantId)dashboardInfo);
                return true;
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).collect(Collectors.toList());
        PageData filteredResult = new PageData(filteredDashboards, nonFilteredResult.getTotalPages(), nonFilteredResult.getTotalElements(), nonFilteredResult.hasNext());
        return (PageData)this.checkNotNull((Object)filteredResult);
    }

    private Set<CustomerId> customerIdFromStr(String[] strCustomerIds) {
        HashSet<CustomerId> customerIds = new HashSet<CustomerId>();
        if (strCustomerIds != null) {
            for (String strCustomerId : strCustomerIds) {
                customerIds.add(new CustomerId(UUID.fromString(strCustomerId)));
            }
        }
        return customerIds;
    }

    @ConstructorProperties(value={"tbDashboardService", "tbResourceService"})
    @Generated
    public DashboardController(TbDashboardService tbDashboardService, TbResourceService tbResourceService) {
        this.tbDashboardService = tbDashboardService;
        this.tbResourceService = tbResourceService;
    }
}

