/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.customer.TbCustomerService;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class CustomerController
extends BaseController {
    private final TbCustomerService tbCustomerService;
    public static final String IS_PUBLIC = "isPublic";
    public static final String CUSTOMER_SECURITY_CHECK = "If the user has the authority of 'Tenant Administrator', the server checks that the customer is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the user belongs to the customer.";

    @ApiOperation(value="Get Customer (getCustomerById)", notes="Get the Customer object based on the provided Customer Id. If the user has the authority of 'Tenant Administrator', the server checks that the customer is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the user belongs to the customer.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Customer getCustomerById(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        Customer customer = this.checkCustomerId(customerId, Operation.READ);
        this.checkDashboardInfo(customer.getAdditionalInfo(), "homeDashboardId");
        return customer;
    }

    @ApiOperation(value="Get short Customer info (getShortCustomerInfoById)", notes="Get the short customer object that contains only the title and 'isPublic' flag. If the user has the authority of 'Tenant Administrator', the server checks that the customer is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the user belongs to the customer.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/shortInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonNode getShortCustomerInfoById(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        Customer customer = this.checkCustomerId(customerId, Operation.READ);
        ObjectNode infoObject = JacksonUtil.newObjectNode();
        infoObject.put("title", customer.getTitle());
        infoObject.put(IS_PUBLIC, customer.isPublic());
        return infoObject;
    }

    @ApiOperation(value="Get Customer Title (getCustomerTitleById)", notes="Get the title of the customer. If the user has the authority of 'Tenant Administrator', the server checks that the customer is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the user belongs to the customer.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/title"}, method={RequestMethod.GET}, produces={"application/text"})
    @ResponseBody
    public String getCustomerTitleById(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        Customer customer = this.checkCustomerId(customerId, Operation.READ);
        return customer.getTitle();
    }

    @ApiOperation(value="Create or update Customer (saveCustomer)", notes="Creates or Updates the Customer. When creating customer, platform generates Customer Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Customer Id will be present in the response. Specify existing Customer Id to update the Customer. Referencing non-existing Customer Id will cause 'Not Found' error.Remove 'id', 'tenantId' from the request body example (below) to create new Customer entity. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customer"}, method={RequestMethod.POST})
    @ResponseBody
    public Customer saveCustomer(@io.swagger.v3.oas.annotations.parameters.RequestBody(description="A JSON value representing the customer.") @RequestBody Customer customer) throws Exception {
        customer.setTenantId(this.getTenantId());
        this.checkEntity((EntityId)customer.getId(), (HasTenantId)customer, Resource.CUSTOMER);
        return (Customer)this.tbCustomerService.save((Object)customer, this.getCurrentUser());
    }

    @ApiOperation(value="Delete Customer (deleteCustomer)", notes="Deletes the Customer and all customer Users. All assigned Dashboards, Assets, Devices, etc. will be unassigned but not deleted. Referencing non-existing Customer Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customer/{customerId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteCustomer(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        Customer customer = this.checkCustomerId(customerId, Operation.DELETE);
        this.tbCustomerService.delete((Object)customer, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Tenant Customers (getCustomers)", notes="Returns a page of customers owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customers"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Customer> getCustomers(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the customer title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title", "email", "country", "city"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (PageData)this.checkNotNull((Object)this.customerService.findCustomersByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Tenant Customer by Customer title (getTenantCustomer)", notes="Get the Customer using Customer Title. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/customers"}, params={"customerTitle"}, method={RequestMethod.GET})
    @ResponseBody
    public Customer getTenantCustomer(@Parameter(description="A string value representing the Customer title.") @RequestParam String customerTitle) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (Customer)this.checkNotNull(this.customerService.findCustomerByTenantIdAndTitle(tenantId, customerTitle), "Customer with title [" + customerTitle + "] is not found");
    }

    @ConstructorProperties(value={"tbCustomerService"})
    @Generated
    public CustomerController(TbCustomerService tbCustomerService) {
        this.tbCustomerService = tbCustomerService;
    }
}

